/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.formats.iceberg;

import java.util.Map;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableFormat;
import org.apache.amoro.TableSnapshot;
import org.apache.amoro.formats.iceberg.IcebergSnapshot;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.AuthenticatedFileIOs;
import org.apache.amoro.table.BasicUnkeyedTable;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.utils.MixedFormatCatalogUtil;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;

public class IcebergTable
implements AmoroTable<UnkeyedTable> {
    private final TableIdentifier identifier;
    private final UnkeyedTable table;

    public static IcebergTable newIcebergTable(TableIdentifier identifier, Table icebergTable, TableMetaStore metaStore, Map<String, String> catalogProperties) {
        AuthenticatedFileIO io = AuthenticatedFileIOs.buildAdaptIcebergFileIO(metaStore, icebergTable.io());
        BasicUnkeyedTable wrapped = new BasicUnkeyedTable(identifier, MixedFormatCatalogUtil.useMixedTableOperations(icebergTable, icebergTable.location(), io, metaStore.getConfiguration()), io, (Map)catalogProperties){

            @Override
            public TableFormat format() {
                return TableFormat.ICEBERG;
            }
        };
        return new IcebergTable(identifier, wrapped);
    }

    protected IcebergTable(TableIdentifier identifier, UnkeyedTable table) {
        this.table = table;
        this.identifier = identifier;
    }

    public TableIdentifier id() {
        return this.identifier;
    }

    public TableFormat format() {
        return TableFormat.ICEBERG;
    }

    public Map<String, String> properties() {
        return this.table.properties();
    }

    public UnkeyedTable originalTable() {
        return this.table;
    }

    public TableSnapshot currentSnapshot() {
        Snapshot snapshot = this.table.currentSnapshot();
        return new IcebergSnapshot(snapshot);
    }
}

