/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.table;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.amoro.shade.guava32.com.google.common.base.Charsets;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.base.Strings;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.hash.Hashing;
import org.apache.amoro.shade.guava32.com.google.common.io.ByteStreams;
import org.apache.amoro.utils.ReflectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetaStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(TableMetaStore.class);
    private static final ConcurrentHashMap<TableMetaStore, RuntimeContext> RUNTIME_CONTEXT_CACHE = new ConcurrentHashMap();
    public static final TableMetaStore EMPTY = TableMetaStore.builder().withConfiguration(new Configuration()).build();
    public static final String HADOOP_CONF_DIR = "conf.hadoop.dir";
    public static final String HIVE_SITE = "hive-site";
    public static final String HDFS_SITE = "hdfs-site";
    public static final String CORE_SITE = "core-site";
    public static final String KRB5_CONF = "krb.conf";
    public static final String KEYTAB = "krb.keytab";
    public static final String AUTH_METHOD = "auth.method";
    public static final String KEYTAB_LOGIN_USER = "krb.principal";
    public static final String SIMPLE_USER_NAME = "simple.user.name";
    public static final String AUTH_METHOD_AK_SK = "ak/sk";
    public static final String AUTH_METHOD_SIMPLE = "SIMPLE";
    public static final String AUTH_METHOD_KERBEROS = "KERBEROS";
    private static final String KRB_CONF_FILE_NAME = "krb5.conf";
    private static final String KEY_TAB_FILE_NAME = "krb.keytab";
    private static final String META_STORE_SITE_FILE_NAME = "hive-site.xml";
    private static final String HADOOP_USER_PROPERTY = "HADOOP_USER_NAME";
    private static final String KRB5_CONF_PROPERTY = "java.security.krb5.conf";
    private static Field UGI_PRINCIPLE_FIELD;
    private static Field UGI_KEYTAB_FIELD;
    private static boolean UGI_REFLECT;
    private static final Object lock;
    private final byte[] metaStoreSite;
    private final byte[] hdfsSite;
    private final byte[] coreSite;
    private final String authMethod;
    private final String hadoopUsername;
    private final byte[] krbKeyTab;
    private final byte[] krbConf;
    private final String krbPrincipal;
    private final boolean disableAuth;
    private final String accessKey;
    private final String secretKey;
    private transient RuntimeContext runtimeContext;
    private transient String authInformation;

    public static Builder builder() {
        return new Builder();
    }

    private TableMetaStore(byte[] metaStoreSite, byte[] hdfsSite, byte[] coreSite, String authMethod, String hadoopUsername, byte[] krbKeyTab, byte[] krbConf, String krbPrincipal, String accessKey, String secretKey, boolean disableAuth) {
        Preconditions.checkArgument((authMethod == null || AUTH_METHOD_SIMPLE.equals(authMethod) || AUTH_METHOD_KERBEROS.equals(authMethod) || AUTH_METHOD_AK_SK.equals(authMethod) ? 1 : 0) != 0, (String)"Error auth method:%s", (Object)authMethod);
        this.metaStoreSite = metaStoreSite;
        this.hdfsSite = hdfsSite;
        this.coreSite = coreSite;
        this.authMethod = authMethod;
        this.hadoopUsername = hadoopUsername;
        this.krbKeyTab = krbKeyTab;
        this.krbConf = krbConf;
        this.krbPrincipal = krbPrincipal;
        this.disableAuth = disableAuth;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    private TableMetaStore(Configuration configuration) {
        this.disableAuth = true;
        this.metaStoreSite = null;
        this.hdfsSite = null;
        this.coreSite = null;
        this.authMethod = null;
        this.hadoopUsername = null;
        this.krbKeyTab = null;
        this.krbConf = null;
        this.krbPrincipal = null;
        this.accessKey = null;
        this.secretKey = null;
        this.getRuntimeContext().setConfiguration(configuration);
    }

    public byte[] getMetaStoreSite() {
        return this.metaStoreSite;
    }

    public byte[] getHdfsSite() {
        return this.hdfsSite;
    }

    public byte[] getCoreSite() {
        return this.coreSite;
    }

    public byte[] getKrbKeyTab() {
        return this.krbKeyTab;
    }

    public byte[] getKrbConf() {
        return this.krbConf;
    }

    public String getKrbPrincipal() {
        return this.krbPrincipal;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean isKerberosAuthMethod() {
        return AUTH_METHOD_KERBEROS.equalsIgnoreCase(this.authMethod);
    }

    public String getHadoopUsername() {
        return this.hadoopUsername;
    }

    public synchronized Configuration getConfiguration() {
        return this.getRuntimeContext().getConfiguration();
    }

    private synchronized UserGroupInformation getUGI() {
        return this.getRuntimeContext().getUGI();
    }

    public <T> T doAs(Callable<T> callable) {
        if (this.disableAuth || AUTH_METHOD_AK_SK.equalsIgnoreCase(this.authMethod)) {
            return this.call(callable);
        }
        return (T)Objects.requireNonNull(this.getUGI()).doAs(() -> this.call(callable));
    }

    public <T> T doAsImpersonating(String proxyUser, Callable<T> callable) {
        if (this.disableAuth) {
            return this.call(callable);
        }
        UserGroupInformation proxyUgi = UserGroupInformation.createProxyUser((String)proxyUser, (UserGroupInformation)Objects.requireNonNull(this.getUGI()));
        LOG.debug("Access through the proxy account {}, proxy ugi {}, original ugi {}.", new Object[]{proxyUser, proxyUgi, this.getUGI()});
        return (T)proxyUgi.doAs(() -> this.call(callable));
    }

    private <T> T call(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Run with ugi request failed.", e);
        }
    }

    public synchronized Optional<URL> getHiveSiteLocation() {
        return this.getRuntimeContext().getHiveSiteLocation();
    }

    private RuntimeContext getRuntimeContext() {
        if (this.runtimeContext == null) {
            RUNTIME_CONTEXT_CACHE.putIfAbsent(this, new RuntimeContext());
            this.runtimeContext = RUNTIME_CONTEXT_CACHE.get(this);
        }
        return this.runtimeContext;
    }

    private String authInformation() {
        if (this.authInformation == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.disableAuth) {
                stringBuilder.append("disable authentication");
            } else if (AUTH_METHOD_KERBEROS.equalsIgnoreCase(this.authMethod)) {
                stringBuilder.append(this.authMethod).append("(").append(this.krbPrincipal).append(")");
            } else if (AUTH_METHOD_SIMPLE.equalsIgnoreCase(this.authMethod)) {
                stringBuilder.append(this.authMethod).append("(").append(this.hadoopUsername).append(")");
            }
            this.authInformation = stringBuilder.toString();
        }
        return this.authInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableMetaStore that = (TableMetaStore)o;
        return Arrays.equals(this.metaStoreSite, that.metaStoreSite) && Arrays.equals(this.hdfsSite, that.hdfsSite) && Arrays.equals(this.coreSite, that.coreSite) && Objects.equals(this.authMethod, that.authMethod) && Objects.equals(this.hadoopUsername, that.hadoopUsername) && Arrays.equals(this.krbKeyTab, that.krbKeyTab) && Arrays.equals(this.krbConf, that.krbConf) && Objects.equals(this.krbPrincipal, that.krbPrincipal) && Objects.equals(this.disableAuth, that.disableAuth);
    }

    public int hashCode() {
        int result = Objects.hash(this.disableAuth, this.authMethod, this.hadoopUsername, this.krbPrincipal);
        result = 31 * result + Arrays.hashCode(this.metaStoreSite);
        result = 31 * result + Arrays.hashCode(this.hdfsSite);
        result = 31 * result + Arrays.hashCode(this.coreSite);
        result = 31 * result + Arrays.hashCode(this.krbKeyTab);
        result = 31 * result + Arrays.hashCode(this.krbConf);
        return result;
    }

    public String toString() {
        return this.authInformation();
    }

    static {
        try {
            UGI_PRINCIPLE_FIELD = UserGroupInformation.class.getDeclaredField("keytabPrincipal");
            UGI_PRINCIPLE_FIELD.setAccessible(true);
            UGI_KEYTAB_FIELD = UserGroupInformation.class.getDeclaredField("keytabFile");
            UGI_KEYTAB_FIELD.setAccessible(true);
            UGI_REFLECT = true;
        }
        catch (NoSuchFieldException e) {
            UGI_REFLECT = false;
            LOG.info("Hadoop version is 3.1.0+, configuration modification through reflection is not required.");
        }
        lock = new Object();
    }

    public static class Builder {
        private byte[] metaStoreSite;
        private byte[] hdfsSite;
        private byte[] coreSite;
        private String authMethod;
        private String hadoopUsername;
        private byte[] krbKeyTab;
        private byte[] krbConf;
        private String krbPrincipal;
        private String accessKey;
        private String secretKey;
        private boolean disableAuth = true;
        private final Map<String, String> properties = Maps.newHashMap();
        private Configuration configuration;

        public Builder withMetaStoreSitePath(String metaStoreSitePath) {
            this.metaStoreSite = this.readBytesFromFile(metaStoreSitePath);
            return this;
        }

        public Builder withMetaStoreSite(byte[] metaStoreSiteBytes) {
            this.metaStoreSite = metaStoreSiteBytes;
            return this;
        }

        public Builder withBase64MetaStoreSite(String encodedMetaStoreSite) {
            this.metaStoreSite = StringUtils.isBlank((CharSequence)encodedMetaStoreSite) ? null : Base64.getDecoder().decode(encodedMetaStoreSite);
            return this;
        }

        public Builder withHdfsSitePath(String hdfsSitePath) {
            this.hdfsSite = this.readBytesFromFile(hdfsSitePath);
            return this;
        }

        public Builder withHdfsSite(byte[] hdfsSiteBytes) {
            this.hdfsSite = hdfsSiteBytes;
            return this;
        }

        public Builder withBase64HdfsSite(String encodedHdfsSite) {
            this.hdfsSite = StringUtils.isBlank((CharSequence)encodedHdfsSite) ? null : Base64.getDecoder().decode(encodedHdfsSite);
            return this;
        }

        public Builder withCoreSitePath(String coreSitePath) {
            this.coreSite = this.readBytesFromFile(coreSitePath);
            return this;
        }

        public Builder withCoreSite(byte[] coreSiteBytes) {
            this.coreSite = coreSiteBytes;
            return this;
        }

        public Builder withBase64CoreSite(String encodedCoreSite) {
            this.coreSite = StringUtils.isBlank((CharSequence)encodedCoreSite) ? null : Base64.getDecoder().decode(encodedCoreSite);
            return this;
        }

        public Builder withAkSkAuth(String accessKey, String secretKey) {
            this.disableAuth = false;
            this.authMethod = TableMetaStore.AUTH_METHOD_AK_SK;
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            return this;
        }

        public Builder withSimpleAuth(String hadoopUsername) {
            this.disableAuth = false;
            this.authMethod = TableMetaStore.AUTH_METHOD_SIMPLE;
            this.hadoopUsername = hadoopUsername;
            return this;
        }

        public Builder withKrbAuth(String krbKeyTabPath, String krbConfPath, String krbPrincipal) {
            this.disableAuth = false;
            this.authMethod = TableMetaStore.AUTH_METHOD_KERBEROS;
            this.krbKeyTab = this.readBytesFromFile(krbKeyTabPath);
            this.krbConf = this.readBytesFromFile(krbConfPath);
            this.krbPrincipal = krbPrincipal;
            return this;
        }

        public Builder withKrbAuth(byte[] krbKeyTabBytes, byte[] krbConfBytes, String krbPrincipal) {
            this.disableAuth = false;
            this.authMethod = TableMetaStore.AUTH_METHOD_KERBEROS;
            this.krbKeyTab = krbKeyTabBytes;
            this.krbConf = krbConfBytes;
            this.krbPrincipal = krbPrincipal;
            return this;
        }

        public Builder withBase64KrbAuth(String encodedKrbKeytab, String encodedKrbConf, String krbPrincipal) {
            return this.withKrbAuth(Base64.getDecoder().decode(encodedKrbKeytab), Base64.getDecoder().decode(encodedKrbConf), krbPrincipal);
        }

        public Builder withAuth(String authMethod, String hadoopUsername, byte[] krbKeyTabBytes, byte[] krbConfBytes, String krbPrincipal) {
            this.disableAuth = false;
            this.authMethod = authMethod == null ? null : authMethod.toUpperCase();
            this.hadoopUsername = hadoopUsername;
            this.krbKeyTab = krbKeyTabBytes;
            this.krbConf = krbConfBytes;
            this.krbPrincipal = krbPrincipal;
            return this;
        }

        public Builder withBase64Auth(String authMethod, String hadoopUsername, String encodedKrbKeytab, String encodedKrbConf, String krbPrincipal) {
            this.disableAuth = false;
            byte[] keytab = null;
            if (encodedKrbKeytab != null) {
                keytab = Base64.getDecoder().decode(encodedKrbKeytab);
            }
            byte[] krbConf = null;
            if (krbPrincipal != null) {
                krbConf = Base64.getDecoder().decode(encodedKrbConf);
            }
            return this.withAuth(authMethod, hadoopUsername, keytab, krbConf, krbPrincipal);
        }

        public Builder withProperties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public Builder withConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        private byte[] readBytesFromFile(String filePath) {
            try {
                return IOUtils.toByteArray((InputStream)Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Read config failed:" + filePath, e);
            }
        }

        private void readProperties() {
            String krbConfPath = null;
            String keyTabPath = null;
            if (this.properties.containsKey(TableMetaStore.HADOOP_CONF_DIR)) {
                String hadoopConfDir = this.properties.get(TableMetaStore.HADOOP_CONF_DIR);
                if (this.properties.containsKey(TableMetaStore.CORE_SITE)) {
                    this.withCoreSitePath(String.format("%s/%s", hadoopConfDir, this.properties.get(TableMetaStore.CORE_SITE)));
                }
                if (this.properties.containsKey(TableMetaStore.HDFS_SITE)) {
                    this.withHdfsSitePath(String.format("%s/%s", hadoopConfDir, this.properties.get(TableMetaStore.HDFS_SITE)));
                }
                if (this.properties.containsKey(TableMetaStore.HIVE_SITE)) {
                    this.withMetaStoreSitePath(String.format("%s/%s", hadoopConfDir, this.properties.get(TableMetaStore.HIVE_SITE)));
                }
                if (this.properties.containsKey(TableMetaStore.KRB5_CONF)) {
                    krbConfPath = String.format("%s/%s", hadoopConfDir, this.properties.get(TableMetaStore.KRB5_CONF));
                }
                if (this.properties.containsKey("krb.keytab")) {
                    keyTabPath = String.format("%s/%s", hadoopConfDir, this.properties.get("krb.keytab"));
                }
            }
            if (this.properties.containsKey(TableMetaStore.AUTH_METHOD)) {
                String authMethod = this.properties.get(TableMetaStore.AUTH_METHOD).toUpperCase();
                if (TableMetaStore.AUTH_METHOD_SIMPLE.equals(authMethod) && this.properties.containsKey(TableMetaStore.SIMPLE_USER_NAME)) {
                    this.withSimpleAuth(this.properties.get(TableMetaStore.SIMPLE_USER_NAME));
                } else if (TableMetaStore.AUTH_METHOD_KERBEROS.equals(authMethod) && this.properties.containsKey(TableMetaStore.KEYTAB_LOGIN_USER) && !Strings.isNullOrEmpty(krbConfPath) && !Strings.isNullOrEmpty(keyTabPath)) {
                    this.withKrbAuth(keyTabPath, krbConfPath, this.properties.get(TableMetaStore.KEYTAB_LOGIN_USER));
                }
            }
        }

        public TableMetaStore build() {
            if (this.disableAuth && this.configuration != null) {
                LOG.info("Build table meta store with local configuration:" + this.configuration);
                return new TableMetaStore(this.configuration);
            }
            this.readProperties();
            if (TableMetaStore.AUTH_METHOD_SIMPLE.equals(this.authMethod) || TableMetaStore.AUTH_METHOD_KERBEROS.equals(this.authMethod)) {
                Preconditions.checkNotNull((Object)this.hdfsSite);
                Preconditions.checkNotNull((Object)this.coreSite);
            }
            if (TableMetaStore.AUTH_METHOD_SIMPLE.equals(this.authMethod)) {
                Preconditions.checkNotNull((Object)this.hadoopUsername);
            } else if (TableMetaStore.AUTH_METHOD_KERBEROS.equals(this.authMethod)) {
                Preconditions.checkNotNull((Object)this.krbConf);
                Preconditions.checkNotNull((Object)this.krbKeyTab);
                Preconditions.checkNotNull((Object)this.krbPrincipal);
            } else if (TableMetaStore.AUTH_METHOD_AK_SK.equals(this.authMethod)) {
                Preconditions.checkNotNull((Object)this.accessKey);
                Preconditions.checkNotNull((Object)this.secretKey);
            } else if (this.authMethod != null) {
                throw new IllegalArgumentException("Unsupported auth method:" + this.authMethod);
            }
            LOG.info("Build table meta store with configurations: authMethod:{}, hadoopUsername:{}, krbPrincipal:{}", new Object[]{this.authMethod, this.hadoopUsername, this.krbPrincipal});
            return new TableMetaStore(this.metaStoreSite, this.hdfsSite, this.coreSite, this.authMethod, this.hadoopUsername, this.krbKeyTab, this.krbConf, this.krbPrincipal, this.accessKey, this.secretKey, this.disableAuth);
        }
    }

    class RuntimeContext {
        private Configuration configuration;
        private UserGroupInformation ugi;
        private java.nio.file.Path confCachePath;

        RuntimeContext() {
        }

        Configuration getConfiguration() {
            if (this.configuration == null) {
                this.configuration = this.buildConfiguration(TableMetaStore.this);
            }
            return this.configuration;
        }

        private void setConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }

        synchronized Optional<URL> getHiveSiteLocation() {
            try {
                java.nio.file.Path confPath = this.generateKrbConfPath();
                if (ArrayUtils.isEmpty((byte[])TableMetaStore.this.metaStoreSite)) {
                    return Optional.empty();
                }
                java.nio.file.Path hiveSitePath = Paths.get(confPath.toAbsolutePath().toString(), TableMetaStore.META_STORE_SITE_FILE_NAME);
                if (!hiveSitePath.toFile().exists()) {
                    hiveSitePath = Paths.get(this.saveConfInPath(confPath, TableMetaStore.META_STORE_SITE_FILE_NAME, TableMetaStore.this.metaStoreSite), new String[0]);
                }
                Path hadoopPath = new Path(hiveSitePath.toAbsolutePath().toString());
                Path hadoopPathWithSchema = new Path("file://" + hadoopPath.toUri().toString());
                return Optional.of(hadoopPathWithSchema.toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to generate hive site location", e);
            }
        }

        public UserGroupInformation getUGI() {
            if (this.ugi == null) {
                try {
                    if (TableMetaStore.AUTH_METHOD_SIMPLE.equals(TableMetaStore.this.authMethod)) {
                        this.ugi = UserGroupInformation.createRemoteUser((String)TableMetaStore.this.hadoopUsername);
                    } else if (TableMetaStore.AUTH_METHOD_KERBEROS.equals(TableMetaStore.this.authMethod)) {
                        this.constructKerberosUgi();
                    }
                    LOG.info("Completed to build ugi {}", (Object)TableMetaStore.this.authInformation());
                }
                catch (Exception e) {
                    throw new RuntimeException("Fail to init user group information", e);
                }
            } else if (TableMetaStore.AUTH_METHOD_KERBEROS.equals(TableMetaStore.this.authMethod)) {
                if (!this.ugi.getAuthenticationMethod().toString().equals(TableMetaStore.this.authMethod) || !this.ugi.getUserName().equals(TableMetaStore.this.krbPrincipal) && !StringUtils.substringBefore((String)this.ugi.getUserName(), (String)"@").equals(TableMetaStore.this.krbPrincipal)) {
                    try {
                        this.constructKerberosUgi();
                        LOG.info("Completed to re-build ugi {}", (Object)TableMetaStore.this.authInformation());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Fail to init user group information", e);
                    }
                } else {
                    this.reLoginKerberosUgi();
                }
            }
            return this.ugi;
        }

        private void constructKerberosUgi() throws Exception {
            java.nio.file.Path confPath = this.generateKrbConfPath();
            String krbConfFile = this.saveConfInPath(confPath, TableMetaStore.KRB_CONF_FILE_NAME, TableMetaStore.this.krbConf);
            String keyTabFile = this.saveConfInPath(confPath, "krb.keytab", TableMetaStore.this.krbKeyTab);
            System.clearProperty(TableMetaStore.HADOOP_USER_PROPERTY);
            System.setProperty(TableMetaStore.KRB5_CONF_PROPERTY, krbConfFile);
            if (System.getProperty("java.vendor").contains("IBM")) {
                ReflectionUtils.invoke("com.ibm.security.krb5.internal.Config", "refresh");
            } else {
                ReflectionUtils.invoke("sun.security.krb5.Config", "refresh");
            }
            UserGroupInformation.setConfiguration((Configuration)this.getConfiguration());
            KerberosName.resetDefaultRealm();
            this.ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)TableMetaStore.this.krbPrincipal, (String)keyTabFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reLoginKerberosUgi() {
            Class<UserGroupInformation> clazz = UserGroupInformation.class;
            synchronized (UserGroupInformation.class) {
                String oldKeytabFile = null;
                String oldPrincipal = null;
                if (UGI_REFLECT) {
                    try {
                        oldKeytabFile = (String)UGI_KEYTAB_FIELD.get(null);
                        oldPrincipal = (String)UGI_PRINCIPLE_FIELD.get(null);
                    }
                    catch (IllegalAccessException e) {
                        UGI_REFLECT = false;
                        LOG.warn("Get kerberos configuration through reflection failed.", (Throwable)e);
                    }
                }
                String oldSystemPrincipal = System.getProperty("sun.security.krb5.principal");
                boolean systemPrincipalChanged = false;
                try {
                    if (!UserGroupInformation.isSecurityEnabled()) {
                        UserGroupInformation.setConfiguration((Configuration)this.getConfiguration());
                        LOG.info("Reset authentication method to Kerberos, isSecurityEnabled {}, AuthenticationMethod {}, isKeytab {}", new Object[]{UserGroupInformation.isSecurityEnabled(), this.ugi.getAuthenticationMethod().toString(), this.ugi.isFromKeytab()});
                    }
                    if (UGI_REFLECT) {
                        try {
                            UGI_PRINCIPLE_FIELD.set(null, TableMetaStore.this.krbPrincipal);
                            UGI_KEYTAB_FIELD.set(null, this.getConfPath(this.confCachePath, "krb.keytab"));
                        }
                        catch (IllegalAccessException e) {
                            UGI_REFLECT = false;
                            LOG.warn("Set kerberos configuration through reflection failed", (Throwable)e);
                        }
                    }
                    if (oldSystemPrincipal != null && !oldSystemPrincipal.equals(TableMetaStore.this.krbPrincipal)) {
                        System.setProperty("sun.security.krb5.principal", TableMetaStore.this.krbPrincipal);
                        systemPrincipalChanged = true;
                    }
                    this.ugi.checkTGTAndReloginFromKeytab();
                }
                catch (Exception e) {
                    throw new RuntimeException("Re-login from keytab failed", e);
                }
                finally {
                    if (UGI_REFLECT) {
                        try {
                            UGI_PRINCIPLE_FIELD.set(null, oldPrincipal);
                            UGI_KEYTAB_FIELD.set(null, oldKeytabFile);
                        }
                        catch (IllegalAccessException e) {
                            UGI_REFLECT = false;
                            LOG.warn("Get kerberos configuration through reflection failed", (Throwable)e);
                        }
                    }
                    if (systemPrincipalChanged) {
                        System.setProperty("sun.security.krb5.principal", oldSystemPrincipal);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private java.nio.file.Path generateKrbConfPath() {
            if (this.confCachePath == null) {
                String path = Paths.get("", new String[0]).toAbsolutePath().toString();
                String confPath = String.format("%s/%s/%s", path, "amoro_krb_conf", this.md5() + "_" + ManagementFactory.getRuntimeMXBean().getName());
                LOG.info("Generated conf path: {}", (Object)confPath);
                java.nio.file.Path p = Paths.get(confPath, new String[0]);
                if (!p.toFile().exists()) {
                    p.toFile().mkdirs();
                }
                this.confCachePath = p;
            }
            return this.confCachePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String saveConfInPath(java.nio.file.Path confPath, String confName, byte[] confValues) {
            String confFile = this.getConfPath(confPath, confName);
            Object object = lock;
            synchronized (object) {
                block18: {
                    if (!Paths.get(confFile, new String[0]).toFile().exists()) {
                        try (FileOutputStream fileOutputStream = new FileOutputStream(confFile);){
                            ByteStreams.copy((InputStream)new ByteArrayInputStream(confValues), (OutputStream)fileOutputStream);
                            LOG.info("Saved the configuration file to path {}.", (Object)confFile);
                            break block18;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException("Fail to save conf files in work space", e);
                        }
                    }
                    LOG.info("Configuration file already exists in {}.", (Object)confFile);
                }
            }
            return confFile;
        }

        private String getConfPath(java.nio.file.Path confPath, String confName) {
            return String.format("%s/%s", confPath.toString(), confName);
        }

        private Configuration buildConfiguration(TableMetaStore metaStore) {
            Configuration configuration = new Configuration();
            if (!ArrayUtils.isEmpty((byte[])metaStore.getCoreSite())) {
                configuration.addResource((InputStream)new ByteArrayInputStream(metaStore.getCoreSite()));
            }
            if (!ArrayUtils.isEmpty((byte[])metaStore.getHdfsSite())) {
                configuration.addResource((InputStream)new ByteArrayInputStream(metaStore.getHdfsSite()));
            }
            if (!ArrayUtils.isEmpty((byte[])metaStore.getMetaStoreSite())) {
                configuration.addResource((InputStream)new ByteArrayInputStream(metaStore.getMetaStoreSite()));
            }
            configuration.set("ipc.client.fallback-to-simple-auth-allowed", "true");
            configuration.get("fs.defaultFS");
            configuration.set("hive.metastore.schema.verification", "false");
            configuration.set("datanucleus.schema.autoCreateAll", "true");
            return configuration;
        }

        private String md5() {
            return Hashing.md5().newHasher().putString((CharSequence)("tableMetaStore:" + this.base64(TableMetaStore.this.getHdfsSite()) + this.base64(TableMetaStore.this.getCoreSite()) + this.base64(TableMetaStore.this.getMetaStoreSite()) + this.base64(TableMetaStore.this.getKrbConf()) + this.base64(TableMetaStore.this.getKrbKeyTab()) + TableMetaStore.this.getKrbPrincipal()), Charsets.UTF_8).hash().toString();
        }

        private String base64(byte[] bytes) {
            return bytes == null ? "" : Base64.getEncoder().encodeToString(bytes);
        }
    }
}

