/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import com.google.errorprone.annotations.FormatMethod;
import java.io.IOException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;

public class SparkExceptionUtil {
    private SparkExceptionUtil() {
    }

    @FormatMethod
    public static RuntimeException toUncheckedException(Throwable cause, String message, Object ... args) {
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        if (cause instanceof NoSuchDatabaseException) {
            return new NoSuchNamespaceException(cause, message, args);
        }
        if (cause instanceof NoSuchTableException) {
            return new org.apache.iceberg.exceptions.NoSuchTableException(cause, message, args);
        }
        if (cause instanceof AnalysisException) {
            return new ValidationException(cause, message, args);
        }
        if (cause instanceof IOException) {
            return new RuntimeIOException((IOException)cause, message, args);
        }
        return new RuntimeException(String.format(message, args), cause);
    }
}

