/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.SupportsBulkOperations;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.apache.spark.TaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SparkCleanupUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SparkCleanupUtil.class);
    private static final int DELETE_NUM_RETRIES = 3;
    private static final int DELETE_MIN_RETRY_WAIT_MS = 100;
    private static final int DELETE_MAX_RETRY_WAIT_MS = 30000;
    private static final int DELETE_TOTAL_RETRY_TIME_MS = 120000;

    private SparkCleanupUtil() {
    }

    public static void deleteTaskFiles(FileIO io, List<? extends ContentFile<?>> files) {
        SparkCleanupUtil.deleteFiles(SparkCleanupUtil.taskInfo(), io, files);
    }

    private static String taskInfo() {
        TaskContext taskContext = TaskContext.get();
        if (taskContext == null) {
            return "unknown task";
        }
        return String.format("partition %d (task %d, attempt %d, stage %d.%d)", taskContext.partitionId(), taskContext.taskAttemptId(), taskContext.attemptNumber(), taskContext.stageId(), taskContext.stageAttemptNumber());
    }

    public static void deleteFiles(String context, FileIO io, List<? extends ContentFile<?>> files) {
        List paths = Lists.transform(files, file -> file.path().toString());
        SparkCleanupUtil.deletePaths(context, io, paths);
    }

    private static void deletePaths(String context, FileIO io, List<String> paths) {
        if (io instanceof SupportsBulkOperations) {
            SupportsBulkOperations bulkIO = (SupportsBulkOperations)io;
            SparkCleanupUtil.bulkDelete(context, bulkIO, paths);
        } else {
            SparkCleanupUtil.delete(context, io, paths);
        }
    }

    private static void bulkDelete(String context, SupportsBulkOperations io, List<String> paths) {
        try {
            io.deleteFiles(paths);
            LOG.info("Deleted {} file(s) using bulk deletes ({})", (Object)paths.size(), (Object)context);
        }
        catch (BulkDeletionFailureException e) {
            int deletedFilesCount = paths.size() - e.numberFailedObjects();
            LOG.warn("Deleted only {} of {} file(s) using bulk deletes ({})", new Object[]{deletedFilesCount, paths.size(), context});
        }
    }

    private static void delete(String context, FileIO io, List<String> paths) {
        AtomicInteger deletedFilesCount = new AtomicInteger(0);
        Tasks.foreach(paths).executeWith(ThreadPools.getWorkerPool()).stopRetryOn(new Class[]{NotFoundException.class}).suppressFailureWhenFinished().onFailure((path, exc) -> LOG.warn("Failed to delete {} ({})", new Object[]{path, context, exc})).retry(3).exponentialBackoff(100L, 30000L, 120000L, 2.0).run(path -> {
            io.deleteFile(path);
            deletedFilesCount.incrementAndGet();
        });
        if (deletedFilesCount.get() < paths.size()) {
            LOG.warn("Deleted only {} of {} file(s) ({})", new Object[]{deletedFilesCount, paths.size(), context});
        } else {
            LOG.info("Deleted {} file(s) ({})", (Object)paths.size(), (Object)context);
        }
    }
}

