/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;

@PublicEvolving
public class StateChangelogOptions {
    @Documentation.Section(value={"state_changelog"})
    public static final ConfigOption<Boolean> PERIODIC_MATERIALIZATION_ENABLED = ConfigOptions.key("state.changelog.periodic-materialize.enabled").booleanType().defaultValue(true).withDeprecatedKeys("state.backend.changelog.periodic-materialize.enabled").withDescription("Defines whether to enable periodic materialization, all changelogs will not be truncated which may increase the space of checkpoint if disabled");
    @Documentation.Section(value={"state_changelog"})
    public static final ConfigOption<Duration> PERIODIC_MATERIALIZATION_INTERVAL = ConfigOptions.key("state.changelog.periodic-materialize.interval").durationType().defaultValue(Duration.ofMinutes(10L)).withDeprecatedKeys("state.backend.changelog.periodic-materialize.interval").withDescription("Defines the interval in milliseconds to perform periodic materialization for state backend. It only takes effect when " + PERIODIC_MATERIALIZATION_ENABLED.key() + " is true");
    @Documentation.Section(value={"state_changelog"})
    public static final ConfigOption<Integer> MATERIALIZATION_MAX_FAILURES_ALLOWED = ConfigOptions.key("state.changelog.max-failures-allowed").intType().defaultValue(3).withDeprecatedKeys("state.backend.changelog.max-failures-allowed").withDescription("Max number of consecutive materialization failures allowed.");
    @Documentation.Section(value={"state_changelog"})
    public static final ConfigOption<Boolean> ENABLE_STATE_CHANGE_LOG = ConfigOptions.key("state.changelog.enabled").booleanType().defaultValue(false).withDeprecatedKeys("state.backend.changelog.enabled").withDescription("Whether to enable state backend to write state changes to StateChangelog. If this config is not set explicitly, it means no preference for enabling the change log, and the value in lower config level will take effect. The default value 'false' here means if no value set (job or cluster), the change log will not be enabled.");
    @Documentation.Section(value={"state_changelog"})
    public static final ConfigOption<String> STATE_CHANGE_LOG_STORAGE = ConfigOptions.key("state.changelog.storage").stringType().defaultValue("memory").withDeprecatedKeys("state.backend.changelog.storage").withDescription(Description.builder().text("The storage to be used to store state changelog.").linebreak().text("The implementation can be specified via their shortcut name.").linebreak().text("The list of recognized shortcut names currently includes 'memory' and 'filesystem'.").build());
}

