/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.minlog.Log;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class BeanSerializer<T>
extends Serializer<T> {
    static final Object[] noArgs = new Object[0];
    private CachedProperty[] properties;
    Object access;

    public BeanSerializer(Kryo kryo, Class type) {
        BeanInfo info;
        try {
            info = Introspector.getBeanInfo(type);
        }
        catch (IntrospectionException ex) {
            throw new KryoException("Error getting bean info.", ex);
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        Arrays.sort(descriptors, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor o1, PropertyDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList cachedProperties = new ArrayList(descriptors.length);
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            String name = propertyDescriptor.getName();
            if (name.equals("class")) continue;
            Method getMethod = propertyDescriptor.getReadMethod();
            Method setMethod = propertyDescriptor.getWriteMethod();
            if (getMethod == null || setMethod == null) continue;
            Serializer serializer = null;
            Class<?> returnType = getMethod.getReturnType();
            if (kryo.isFinal(returnType)) {
                serializer = kryo.getRegistration(returnType).getSerializer();
            }
            CachedProperty cachedProperty = new CachedProperty();
            cachedProperty.name = name;
            cachedProperty.getMethod = getMethod;
            cachedProperty.setMethod = setMethod;
            cachedProperty.serializer = serializer;
            cachedProperty.setMethodType = setMethod.getParameterTypes()[0];
            cachedProperties.add(cachedProperty);
        }
        this.properties = cachedProperties.toArray(new CachedProperty[cachedProperties.size()]);
        try {
            this.access = MethodAccess.get((Class)type);
            for (CachedProperty cachedProperty : this.properties) {
                cachedProperty.getterAccessIndex = ((MethodAccess)this.access).getIndex(cachedProperty.getMethod.getName(), (Class[])cachedProperty.getMethod.getParameterTypes());
                cachedProperty.setterAccessIndex = ((MethodAccess)this.access).getIndex(cachedProperty.setMethod.getName(), (Class[])cachedProperty.setMethod.getParameterTypes());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        Class<?> type = object.getClass();
        for (CachedProperty property : this.properties) {
            try {
                if (Log.TRACE) {
                    Log.trace((String)"kryo", (String)("Write property: " + property + " (" + type.getName() + ")"));
                }
                Object value = property.get(object);
                Serializer serializer = property.serializer;
                if (serializer != null) {
                    kryo.writeObjectOrNull(output, value, serializer);
                    continue;
                }
                kryo.writeClassAndObject(output, value);
            }
            catch (IllegalAccessException ex) {
                throw new KryoException("Error accessing getter method: " + property + " (" + type.getName() + ")", ex);
            }
            catch (InvocationTargetException ex) {
                throw new KryoException("Error invoking getter method: " + property + " (" + type.getName() + ")", ex);
            }
            catch (KryoException ex) {
                ex.addTrace(property + " (" + type.getName() + ")");
                throw ex;
            }
            catch (RuntimeException runtimeEx) {
                KryoException ex = new KryoException(runtimeEx);
                ex.addTrace(property + " (" + type.getName() + ")");
                throw ex;
            }
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type) {
        T object = kryo.newInstance(type);
        kryo.reference(object);
        for (CachedProperty property : this.properties) {
            try {
                Serializer serializer;
                if (Log.TRACE) {
                    Log.trace((String)"kryo", (String)("Read property: " + property + " (" + object.getClass() + ")"));
                }
                Object value = (serializer = property.serializer) != null ? kryo.readObjectOrNull(input, property.setMethodType, serializer) : kryo.readClassAndObject(input);
                property.set(object, value);
            }
            catch (IllegalAccessException ex) {
                throw new KryoException("Error accessing setter method: " + property + " (" + object.getClass().getName() + ")", ex);
            }
            catch (InvocationTargetException ex) {
                throw new KryoException("Error invoking setter method: " + property + " (" + object.getClass().getName() + ")", ex);
            }
            catch (KryoException ex) {
                ex.addTrace(property + " (" + object.getClass().getName() + ")");
                throw ex;
            }
            catch (RuntimeException runtimeEx) {
                KryoException ex = new KryoException(runtimeEx);
                ex.addTrace(property + " (" + object.getClass().getName() + ")");
                throw ex;
            }
        }
        return object;
    }

    @Override
    public T copy(Kryo kryo, T original) {
        Object copy = kryo.newInstance(original.getClass());
        for (CachedProperty property : this.properties) {
            try {
                Object value = property.get(original);
                property.set(copy, value);
            }
            catch (KryoException ex) {
                ex.addTrace(property + " (" + copy.getClass().getName() + ")");
                throw ex;
            }
            catch (RuntimeException runtimeEx) {
                KryoException ex = new KryoException(runtimeEx);
                ex.addTrace(property + " (" + copy.getClass().getName() + ")");
                throw ex;
            }
            catch (Exception ex) {
                throw new KryoException("Error copying bean property: " + property + " (" + copy.getClass().getName() + ")", ex);
            }
        }
        return (T)copy;
    }

    class CachedProperty<X> {
        String name;
        Method getMethod;
        Method setMethod;
        Class setMethodType;
        Serializer serializer;
        int getterAccessIndex;
        int setterAccessIndex;

        CachedProperty() {
        }

        public String toString() {
            return this.name;
        }

        Object get(Object object) throws IllegalAccessException, InvocationTargetException {
            if (BeanSerializer.this.access != null) {
                return ((MethodAccess)BeanSerializer.this.access).invoke(object, this.getterAccessIndex, new Object[0]);
            }
            return this.getMethod.invoke(object, noArgs);
        }

        void set(Object object, Object value) throws IllegalAccessException, InvocationTargetException {
            if (BeanSerializer.this.access != null) {
                ((MethodAccess)BeanSerializer.this.access).invoke(object, this.setterAccessIndex, new Object[]{value});
                return;
            }
            this.setMethod.invoke(object, value);
        }
    }
}

