/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.model;

import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;

public class TableOptimizingInfo {
    private final ServerTableIdentifier tableIdentifier;
    private String tableName;
    private String optimizeStatus = OptimizingStatus.IDLE.displayValue();
    private long duration = 0L;
    private long fileCount = 0L;
    private long fileSize = 0L;
    private double quota = 0.0;
    private double quotaOccupation = 0.0;
    private String groupName = "default";

    public TableOptimizingInfo(ServerTableIdentifier tableIdentifier) {
        this.tableIdentifier = tableIdentifier;
        this.tableName = tableIdentifier.getCatalog().concat(".").concat(tableIdentifier.getDatabase()).concat(".").concat(tableIdentifier.getTableName());
    }

    public ServerTableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getOptimizeStatus() {
        return this.optimizeStatus;
    }

    public void setOptimizeStatus(String optimizeStatus) {
        this.optimizeStatus = optimizeStatus;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(long fileCount) {
        this.fileCount = fileCount;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public double getQuota() {
        return this.quota;
    }

    public void setQuota(double quota) {
        this.quota = quota;
    }

    public double getQuotaOccupation() {
        return this.quotaOccupation;
    }

    public void setQuotaOccupation(double quotaOccupation) {
        this.quotaOccupation = quotaOccupation;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableIdentifier", (Object)this.tableIdentifier).add("tableName", (Object)this.tableName).add("optimizeStatus", (Object)this.optimizeStatus).add("duration", this.duration).add("fileCount", this.fileCount).add("fileSize", this.fileSize).add("quota", this.quota).add("quotaOccupation", this.quotaOccupation).add("groupName", (Object)this.groupName).toString();
    }
}

