/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing.maintainer;

import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableFormat;
import org.apache.amoro.server.optimizing.maintainer.IcebergTableMaintainer;
import org.apache.amoro.server.optimizing.maintainer.MixedTableMaintainer;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.Table;

public interface TableMaintainer {
    public void cleanOrphanFiles(TableRuntime var1);

    default public void cleanDanglingDeleteFiles(TableRuntime tableRuntime) {
    }

    public void expireSnapshots(TableRuntime var1);

    public void expireData(TableRuntime var1);

    public void autoCreateTags(TableRuntime var1);

    public static TableMaintainer ofTable(AmoroTable<?> amoroTable) {
        TableFormat format = amoroTable.format();
        if (format.in(new TableFormat[]{TableFormat.MIXED_HIVE, TableFormat.MIXED_ICEBERG})) {
            return new MixedTableMaintainer((MixedTable)amoroTable.originalTable());
        }
        if (TableFormat.ICEBERG.equals((Object)format)) {
            return new IcebergTableMaintainer((Table)amoroTable.originalTable());
        }
        throw new RuntimeException("Unsupported table type" + amoroTable.originalTable().getClass());
    }
}

