/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.audit.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.audit.CommonAuditContext;
import org.apache.hadoop.fs.s3a.audit.AWSRequestAnalyzer;
import org.apache.hadoop.fs.s3a.audit.AuditFailureException;
import org.apache.hadoop.fs.s3a.audit.AuditOperationRejectedException;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.fs.s3a.audit.impl.AbstractAuditSpanImpl;
import org.apache.hadoop.fs.s3a.audit.impl.AbstractOperationAuditor;
import org.apache.hadoop.fs.s3a.commit.CommitUtils;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.apache.hadoop.fs.store.audit.HttpReferrerAuditHeader;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;

@InterfaceAudience.Private
public class LoggingAuditor
extends AbstractOperationAuditor {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingAuditor.class);
    private final AWSRequestAnalyzer analyzer = new AWSRequestAnalyzer();
    private AuditSpanS3A warningSpan;
    private boolean rejectOutOfSpan;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private boolean headerEnabled;
    private volatile String lastHeader = "";
    private Collection<String> filters;
    private boolean isMultipartUploadEnabled;
    private static final LogExactlyOnce WARN_INCORRECT_RANGE = new LogExactlyOnce(LOG);

    public LoggingAuditor() {
        super("LoggingAuditor ");
        this.attributes.put("fs", this.getAuditorId());
        try {
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            this.addAttribute("pr", ugi.getUserName());
        }
        catch (IOException ex) {
            LOG.warn("Auditor unable to determine principal", (Throwable)ex);
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.rejectOutOfSpan = conf.getBoolean("fs.s3a.audit.reject.out.of.span.operations", false);
        String jobID = CommitUtils.extractJobID(conf);
        if (jobID != null) {
            this.addAttribute("ji", jobID);
        }
        this.headerEnabled = this.getConfig().getBoolean("fs.s3a.audit.referrer.enabled", true);
        this.filters = conf.getTrimmedStringCollection("fs.s3a.audit.referrer.filter");
        CommonAuditContext currentContext = CommonAuditContext.currentAuditContext();
        this.warningSpan = new WarningSpan("outside-span", currentContext, this.createSpanID(), null, null);
        this.isMultipartUploadEnabled = conf.getBoolean("fs.s3a.multipart.uploads.enabled", true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LoggingAuditor{");
        sb.append("ID='").append(this.getAuditorId()).append('\'');
        sb.append(", headerEnabled=").append(this.headerEnabled);
        sb.append(", rejectOutOfSpan=").append(this.rejectOutOfSpan);
        sb.append(", isMultipartUploadEnabled=").append(this.isMultipartUploadEnabled);
        sb.append('}');
        return sb.toString();
    }

    public AuditSpanS3A createSpan(String operation, @Nullable String path1, @Nullable String path2) {
        LoggingAuditSpan span = new LoggingAuditSpan(this.createSpanID(), operation, this.prepareActiveContext(), path1, path2);
        span.start();
        return span;
    }

    private CommonAuditContext prepareActiveContext() {
        return CommonAuditContext.currentAuditContext();
    }

    public final void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    @Override
    public AuditSpanS3A getUnbondedSpan() {
        return this.warningSpan;
    }

    public String getLastHeader() {
        return this.lastHeader;
    }

    private void setLastHeader(String lastHeader) {
        this.lastHeader = lastHeader;
    }

    private final class WarningSpan
    extends LoggingAuditSpan {
        private WarningSpan(String name, CommonAuditContext context, String spanId, String path1, String path2) {
            super(spanId, name, context, path1, path2);
        }

        @Override
        public void start() {
            LOG.warn("[{}] {} Start {}", new Object[]{CommonAuditContext.currentThreadID(), this.getSpanId(), this.getDescription()});
        }

        @Override
        public AuditSpanS3A activate() {
            LOG.warn("[{}] {} Activate {}", new Object[]{CommonAuditContext.currentThreadID(), this.getSpanId(), this.getDescription()});
            return this;
        }

        public boolean isValidSpan() {
            return false;
        }

        @Override
        public void requestCreated(SdkRequest.Builder builder) {
            String error = "Creating a request outside an audit span " + LoggingAuditor.this.analyzer.analyze(builder.build());
            LOG.info(error);
            if (LOG.isDebugEnabled()) {
                LOG.debug(error, (Throwable)((Object)new AuditFailureException("unaudited")));
            }
        }

        public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
            String error = "executing a request outside an audit span " + LoggingAuditor.this.analyzer.analyze(context.request());
            String unaudited = this.getSpanId() + " " + "unaudited operation" + " " + error;
            if (AWSRequestAnalyzer.isRequestNotAlwaysInSpan(context.request())) {
                LOG.debug(unaudited);
            } else {
                AuditFailureException ex = new AuditFailureException(unaudited);
                LOG.debug(unaudited, (Throwable)((Object)ex));
                if (LoggingAuditor.this.rejectOutOfSpan) {
                    throw ex;
                }
            }
            super.beforeExecution(context, executionAttributes);
        }
    }

    private class LoggingAuditSpan
    extends AbstractAuditSpanImpl {
        private final HttpReferrerAuditHeader referrer;
        private final String description;

        private void attachRangeFromRequest(SdkHttpRequest request, ExecutionAttributes executionAttributes) {
            String[] rangeHeader;
            String operationName = (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME);
            if (operationName != null && operationName.equals("GetObject") && request.headers() != null && request.headers().get("Range") != null && (rangeHeader = ((String)((List)request.headers().get("Range")).get(0)).split("="))[0].equals("bytes")) {
                this.referrer.set("rg", rangeHeader[1]);
            }
        }

        private LoggingAuditSpan(String spanId, String operationName, CommonAuditContext context, String path1, String path2) {
            super(spanId, operationName);
            this.referrer = HttpReferrerAuditHeader.builder().withContextId(LoggingAuditor.this.getAuditorId()).withSpanId(spanId).withOperationName(operationName).withPath1(path1).withPath2(path2).withAttributes(LoggingAuditor.this.attributes).withAttribute("t0", CommonAuditContext.currentThreadID()).withAttribute("ts", Long.toString(this.getTimestamp())).withEvaluated(context.getEvaluatedEntries()).withFilter(LoggingAuditor.this.filters).build();
            this.description = this.referrer.buildHttpReferrer();
        }

        public void start() {
            LOG.trace("{} Start {}", (Object)this.getSpanId(), (Object)this.getDescription());
        }

        protected String getDescription() {
            return this.description;
        }

        @Override
        public AuditSpanS3A activate() {
            LOG.trace("[{}] {} Activate {}", new Object[]{CommonAuditContext.currentThreadID(), this.getSpanId(), this.getDescription()});
            return this;
        }

        public void deactivate() {
            LOG.trace("[{}] {} Deactivate {}", new Object[]{CommonAuditContext.currentThreadID(), this.getSpanId(), this.getDescription()});
        }

        public void set(String key, String value) {
            this.referrer.set(key, value);
        }

        public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
            SdkHttpRequest httpRequest = context.httpRequest();
            SdkRequest sdkRequest = context.request();
            this.attachRangeFromRequest(httpRequest, executionAttributes);
            this.attachDeleteKeySizeAttribute(sdkRequest);
            String header = this.referrer.buildHttpReferrer();
            LoggingAuditor.this.setLastHeader(header);
            if (LoggingAuditor.this.headerEnabled) {
                httpRequest = (SdkHttpRequest)((SdkHttpRequest.Builder)httpRequest.toBuilder()).appendHeader("Referer", header).build();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("[{}] {} Executing {} with {}; {}", new Object[]{CommonAuditContext.currentThreadID(), this.getSpanId(), this.getOperationName(), LoggingAuditor.this.analyzer.analyze(context.request()), header});
            }
            if (!LoggingAuditor.this.isMultipartUploadEnabled && AWSRequestAnalyzer.isRequestMultipartIO(sdkRequest)) {
                throw new AuditOperationRejectedException("Multipart IO request " + sdkRequest + " rejected " + header);
            }
            return httpRequest;
        }

        private void attachDeleteKeySizeAttribute(SdkRequest request) {
            String key;
            if (request instanceof DeleteObjectsRequest) {
                int keySize = ((DeleteObjectsRequest)request).delete().objects().size();
                this.referrer.set("ks", String.valueOf(keySize));
            } else if (request instanceof DeleteObjectRequest && (key = ((DeleteObjectRequest)request).key()) != null && key.length() > 0) {
                this.referrer.set("ks", "1");
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("LoggingAuditSpan{");
            sb.append(", id='").append(this.getSpanId()).append('\'');
            sb.append("description='").append(this.description).append('\'');
            sb.append('}');
            return sb.toString();
        }

        HttpReferrerAuditHeader getReferrer() {
            return this.referrer;
        }
    }
}

