/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.amoro.shade.zookeeper3.org.apache.jute.Record;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.MultiOperationRecord;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.MultiResponse;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.Op;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.OpResult;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.Watcher;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.audit.AuditHelper;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.common.Time;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.data.ACL;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.data.Id;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.data.Stat;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.AddWatchRequest;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.CheckWatchesRequest;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.Create2Response;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.CreateResponse;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.ErrorResponse;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.ExistsRequest;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.ExistsResponse;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.GetACLRequest;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.GetACLResponse;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.GetAllChildrenNumberRequest;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.GetAllChildrenNumberResponse;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.GetChildren2Request;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.GetChildren2Response;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.GetChildrenRequest;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.GetChildrenResponse;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.GetDataRequest;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.GetDataResponse;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.GetEphemeralsRequest;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.GetEphemeralsResponse;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.RemoveWatchesRequest;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.ReplyHeader;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.SetACLResponse;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.SetDataResponse;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.SetWatches;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.SetWatches2;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.SyncRequest;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.SyncResponse;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.proto.WhoAmIResponse;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.DataNode;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.DataTree;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.Request;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.RequestProcessor;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.ServerCnxn;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.ServerMetrics;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.ZooTrace;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.util.AuthUtil;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.util.RequestPathMetricsCollector;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.txn.ErrorTxn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FinalRequestProcessor.class);
    private final RequestPathMetricsCollector requestPathMetricsCollector;
    ZooKeeperServer zks;

    public FinalRequestProcessor(ZooKeeperServer zks) {
        this.zks = zks;
        this.requestPathMetricsCollector = zks.getRequestPathMetricsCollector();
    }

    private DataTree.ProcessTxnResult applyRequest(Request request) {
        long propagationLatency;
        DataTree.ProcessTxnResult rc = this.zks.processTxn(request);
        if (request.type == -11 && this.connClosedByClient(request) && (this.closeSession(this.zks.serverCnxnFactory, request.sessionId) || this.closeSession(this.zks.secureServerCnxnFactory, request.sessionId))) {
            return rc;
        }
        if (request.getHdr() != null && (propagationLatency = Time.currentWallTime() - request.getHdr().getTime()) >= 0L) {
            ServerMetrics.getMetrics().PROPAGATION_LATENCY.add(propagationLatency);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(Request request) {
        LOG.debug("Processing request:: {}", (Object)request);
        if (LOG.isTraceEnabled()) {
            long traceMask = 2L;
            if (request.type == 11) {
                traceMask = 128L;
            }
            ZooTrace.logRequest(LOG, traceMask, 'E', request, "");
        }
        DataTree.ProcessTxnResult rc = null;
        if (!request.isThrottled()) {
            rc = this.applyRequest(request);
        }
        if (request.cnxn == null) {
            return;
        }
        ServerCnxn cnxn = request.cnxn;
        long lastZxid = this.zks.getZKDatabase().getDataTreeLastProcessedZxid();
        String lastOp = "NA";
        this.zks.decInProcess();
        this.zks.requestFinished(request);
        KeeperException.Code err = KeeperException.Code.OK;
        Record rsp = null;
        String path = null;
        int responseSize = 0;
        try {
            if (request.getHdr() != null && request.getHdr().getType() == -1) {
                AuditHelper.addAuditLog(request, rc, true);
                if (request.getException() != null) {
                    throw request.getException();
                }
                throw KeeperException.create(KeeperException.Code.get(((ErrorTxn)request.getTxn()).getErr()));
            }
            KeeperException ke = request.getException();
            if (ke instanceof KeeperException.SessionMovedException) {
                throw ke;
            }
            if (ke != null && request.type != 14) {
                throw ke;
            }
            LOG.debug("{}", (Object)request);
            if (request.isStale()) {
                ServerMetrics.getMetrics().STALE_REPLIES.add(1L);
            }
            if (request.isThrottled()) {
                throw KeeperException.create(KeeperException.Code.THROTTLEDOP);
            }
            AuditHelper.addAuditLog(request, rc);
            switch (request.type) {
                case 11: {
                    lastOp = "PING";
                    this.updateStats(request, lastOp, lastZxid);
                    responseSize = cnxn.sendResponse(new ReplyHeader(-2, lastZxid, 0), null, "response");
                    return;
                }
                case -10: {
                    lastOp = "SESS";
                    this.updateStats(request, lastOp, lastZxid);
                    this.zks.finishSessionInit(request.cnxn, true);
                    return;
                }
                case 14: {
                    lastOp = "MULT";
                    rsp = new MultiResponse();
                    for (DataTree.ProcessTxnResult subTxnResult : rc.multiResult) {
                        OpResult subResult;
                        switch (subTxnResult.type) {
                            case 13: {
                                subResult = new OpResult.CheckResult();
                                break;
                            }
                            case 1: {
                                subResult = new OpResult.CreateResult(subTxnResult.path);
                                break;
                            }
                            case 15: 
                            case 19: 
                            case 21: {
                                subResult = new OpResult.CreateResult(subTxnResult.path, subTxnResult.stat);
                                break;
                            }
                            case 2: 
                            case 20: {
                                subResult = new OpResult.DeleteResult();
                                break;
                            }
                            case 5: {
                                subResult = new OpResult.SetDataResult(subTxnResult.stat);
                                break;
                            }
                            case -1: {
                                subResult = new OpResult.ErrorResult(subTxnResult.err);
                                if (subTxnResult.err != KeeperException.Code.SESSIONMOVED.intValue()) break;
                                throw new KeeperException.SessionMovedException();
                            }
                            default: {
                                throw new IOException("Invalid type of op");
                            }
                        }
                        ((MultiResponse)rsp).add(subResult);
                    }
                    break;
                }
                case 22: {
                    lastOp = "MLTR";
                    MultiOperationRecord multiReadRecord = request.readRequestRecord(MultiOperationRecord::new);
                    rsp = new MultiResponse();
                    for (Op readOp : multiReadRecord) {
                        OpResult subResult;
                        try {
                            switch (readOp.getType()) {
                                case 8: {
                                    Record rec = this.handleGetChildrenRequest(readOp.toRequestRecord(), cnxn, request.authInfo);
                                    subResult = new OpResult.GetChildrenResult(((GetChildrenResponse)rec).getChildren());
                                    break;
                                }
                                case 4: {
                                    Record rec = this.handleGetDataRequest(readOp.toRequestRecord(), cnxn, request.authInfo);
                                    GetDataResponse gdr = (GetDataResponse)rec;
                                    subResult = new OpResult.GetDataResult(gdr.getData(), gdr.getStat());
                                    break;
                                }
                                default: {
                                    throw new IOException("Invalid type of readOp");
                                }
                            }
                        }
                        catch (KeeperException e) {
                            subResult = new OpResult.ErrorResult(e.code().intValue());
                        }
                        ((MultiResponse)rsp).add(subResult);
                    }
                    break;
                }
                case 1: {
                    lastOp = "CREA";
                    rsp = new CreateResponse(rc.path);
                    err = KeeperException.Code.get(rc.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case 15: 
                case 19: 
                case 21: {
                    lastOp = "CREA";
                    rsp = new Create2Response(rc.path, rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case 2: 
                case 20: {
                    lastOp = "DELE";
                    err = KeeperException.Code.get(rc.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case 5: {
                    lastOp = "SETD";
                    rsp = new SetDataResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case 16: {
                    lastOp = "RECO";
                    rsp = new GetDataResponse(((QuorumZooKeeperServer)this.zks).self.getQuorumVerifier().toString().getBytes(StandardCharsets.UTF_8), rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 7: {
                    lastOp = "SETA";
                    rsp = new SetACLResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case -11: {
                    lastOp = "CLOS";
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 9: {
                    lastOp = "SYNC";
                    SyncRequest syncRequest = request.readRequestRecord(SyncRequest::new);
                    rsp = new SyncResponse(syncRequest.getPath());
                    this.requestPathMetricsCollector.registerRequest(request.type, syncRequest.getPath());
                    break;
                }
                case 13: {
                    lastOp = "CHEC";
                    rsp = new SetDataResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 3: {
                    lastOp = "EXIS";
                    ExistsRequest existsRequest = request.readRequestRecord(ExistsRequest::new);
                    path = existsRequest.getPath();
                    if (path.indexOf(0) != -1) {
                        throw new KeeperException.BadArgumentsException();
                    }
                    Stat stat = this.zks.getZKDatabase().statNode(path, existsRequest.getWatch() ? cnxn : null);
                    rsp = new ExistsResponse(stat);
                    this.requestPathMetricsCollector.registerRequest(request.type, path);
                    break;
                }
                case 4: {
                    lastOp = "GETD";
                    GetDataRequest getDataRequest = request.readRequestRecord(GetDataRequest::new);
                    path = getDataRequest.getPath();
                    rsp = this.handleGetDataRequest(getDataRequest, cnxn, request.authInfo);
                    this.requestPathMetricsCollector.registerRequest(request.type, path);
                    break;
                }
                case 101: {
                    lastOp = "SETW";
                    Record setWatches = request.readRequestRecord(SetWatches::new);
                    long relativeZxid = ((SetWatches)setWatches).getRelativeZxid();
                    this.zks.getZKDatabase().setWatches(relativeZxid, ((SetWatches)setWatches).getDataWatches(), ((SetWatches)setWatches).getExistWatches(), ((SetWatches)setWatches).getChildWatches(), Collections.emptyList(), Collections.emptyList(), cnxn);
                    break;
                }
                case 105: {
                    lastOp = "STW2";
                    Record setWatches = request.readRequestRecord(SetWatches2::new);
                    long relativeZxid = ((SetWatches2)setWatches).getRelativeZxid();
                    this.zks.getZKDatabase().setWatches(relativeZxid, ((SetWatches2)setWatches).getDataWatches(), ((SetWatches2)setWatches).getExistWatches(), ((SetWatches2)setWatches).getChildWatches(), ((SetWatches2)setWatches).getPersistentWatches(), ((SetWatches2)setWatches).getPersistentRecursiveWatches(), cnxn);
                    break;
                }
                case 106: {
                    lastOp = "ADDW";
                    AddWatchRequest addWatcherRequest = request.readRequestRecord(AddWatchRequest::new);
                    this.zks.getZKDatabase().addWatch(addWatcherRequest.getPath(), cnxn, addWatcherRequest.getMode());
                    rsp = new ErrorResponse(0);
                    break;
                }
                case 6: {
                    lastOp = "GETA";
                    GetACLRequest getACLRequest = request.readRequestRecord(GetACLRequest::new);
                    path = getACLRequest.getPath();
                    DataNode n = this.zks.getZKDatabase().getNode(path);
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    this.zks.checkACL(request.cnxn, this.zks.getZKDatabase().aclForNode(n), 17, request.authInfo, path, null);
                    Stat stat = new Stat();
                    List<ACL> acl = this.zks.getZKDatabase().getACL(path, stat);
                    this.requestPathMetricsCollector.registerRequest(request.type, getACLRequest.getPath());
                    try {
                        this.zks.checkACL(request.cnxn, this.zks.getZKDatabase().aclForNode(n), 16, request.authInfo, path, null);
                        rsp = new GetACLResponse(acl, stat);
                    }
                    catch (KeeperException.NoAuthException e) {
                        ArrayList<ACL> acl1 = new ArrayList<ACL>(acl.size());
                        for (ACL a : acl) {
                            if ("digest".equals(a.getId().getScheme())) {
                                Id id = a.getId();
                                Id id1 = new Id(id.getScheme(), id.getId().replaceAll(":.*", ":x"));
                                acl1.add(new ACL(a.getPerms(), id1));
                                continue;
                            }
                            acl1.add(a);
                        }
                        rsp = new GetACLResponse(acl1, stat);
                    }
                    break;
                }
                case 8: {
                    lastOp = "GETC";
                    GetChildrenRequest getChildrenRequest = request.readRequestRecord(GetChildrenRequest::new);
                    path = getChildrenRequest.getPath();
                    rsp = this.handleGetChildrenRequest(getChildrenRequest, cnxn, request.authInfo);
                    this.requestPathMetricsCollector.registerRequest(request.type, path);
                    break;
                }
                case 104: {
                    lastOp = "GETACN";
                    GetAllChildrenNumberRequest getAllChildrenNumberRequest = request.readRequestRecord(GetAllChildrenNumberRequest::new);
                    path = getAllChildrenNumberRequest.getPath();
                    DataNode n = this.zks.getZKDatabase().getNode(path);
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    this.zks.checkACL(request.cnxn, this.zks.getZKDatabase().aclForNode(n), 1, request.authInfo, path, null);
                    int number = this.zks.getZKDatabase().getAllChildrenNumber(path);
                    rsp = new GetAllChildrenNumberResponse(number);
                    break;
                }
                case 12: {
                    lastOp = "GETC";
                    GetChildren2Request getChildren2Request = request.readRequestRecord(GetChildren2Request::new);
                    Stat stat = new Stat();
                    path = getChildren2Request.getPath();
                    DataNode n = this.zks.getZKDatabase().getNode(path);
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    this.zks.checkACL(request.cnxn, this.zks.getZKDatabase().aclForNode(n), 1, request.authInfo, path, null);
                    List<String> children = this.zks.getZKDatabase().getChildren(path, stat, getChildren2Request.getWatch() ? cnxn : null);
                    rsp = new GetChildren2Response(children, stat);
                    this.requestPathMetricsCollector.registerRequest(request.type, path);
                    break;
                }
                case 17: {
                    lastOp = "CHKW";
                    CheckWatchesRequest checkWatches = request.readRequestRecord(CheckWatchesRequest::new);
                    Watcher.WatcherType type = Watcher.WatcherType.fromInt(checkWatches.getType());
                    path = checkWatches.getPath();
                    boolean containsWatcher = this.zks.getZKDatabase().containsWatcher(path, type, cnxn);
                    if (!containsWatcher) {
                        String msg = String.format(Locale.ENGLISH, "%s (type: %s)", new Object[]{path, type});
                        throw new KeeperException.NoWatcherException(msg);
                    }
                    this.requestPathMetricsCollector.registerRequest(request.type, checkWatches.getPath());
                    break;
                }
                case 18: {
                    lastOp = "REMW";
                    RemoveWatchesRequest removeWatches = request.readRequestRecord(RemoveWatchesRequest::new);
                    Watcher.WatcherType type = Watcher.WatcherType.fromInt(removeWatches.getType());
                    path = removeWatches.getPath();
                    boolean removed = this.zks.getZKDatabase().removeWatch(path, type, cnxn);
                    if (!removed) {
                        String msg = String.format(Locale.ENGLISH, "%s (type: %s)", new Object[]{path, type});
                        throw new KeeperException.NoWatcherException(msg);
                    }
                    this.requestPathMetricsCollector.registerRequest(request.type, removeWatches.getPath());
                    break;
                }
                case 107: {
                    lastOp = "HOMI";
                    rsp = new WhoAmIResponse(AuthUtil.getClientInfos(request.authInfo));
                    break;
                }
                case 103: {
                    lastOp = "GETE";
                    GetEphemeralsRequest getEphemerals = request.readRequestRecord(GetEphemeralsRequest::new);
                    String prefixPath = getEphemerals.getPrefixPath();
                    Set<String> allEphems = this.zks.getZKDatabase().getDataTree().getEphemerals(request.sessionId);
                    ArrayList<String> ephemerals = new ArrayList<String>();
                    if (prefixPath == null || prefixPath.trim().isEmpty() || "/".equals(prefixPath.trim())) {
                        ephemerals.addAll(allEphems);
                    } else {
                        for (String p : allEphems) {
                            if (!p.startsWith(prefixPath)) continue;
                            ephemerals.add(p);
                        }
                    }
                    rsp = new GetEphemeralsResponse(ephemerals);
                    break;
                }
            }
        }
        catch (KeeperException.SessionMovedException e) {
            cnxn.sendCloseSession();
            return;
        }
        catch (KeeperException e) {
            err = e.code();
        }
        catch (Exception e) {
            LOG.error("Failed to process {}", (Object)request, (Object)e);
            String digest = request.requestDigest();
            LOG.error("Dumping request buffer for request type {}: 0x{}", (Object)Request.op2String(request.type), (Object)digest);
            err = KeeperException.Code.MARSHALLINGERROR;
        }
        ReplyHeader hdr = new ReplyHeader(request.cxid, lastZxid, err.intValue());
        this.updateStats(request, lastOp, lastZxid);
        try {
            if (path == null || rsp == null) {
                responseSize = cnxn.sendResponse(hdr, rsp, "response");
            } else {
                int opCode = request.type;
                Stat stat = null;
                switch (opCode) {
                    case 4: {
                        GetDataResponse getDataResponse = (GetDataResponse)rsp;
                        stat = getDataResponse.getStat();
                        responseSize = cnxn.sendResponse(hdr, rsp, "response", path, stat, opCode);
                        break;
                    }
                    case 12: {
                        GetChildren2Response getChildren2Response = (GetChildren2Response)rsp;
                        stat = getChildren2Response.getStat();
                        responseSize = cnxn.sendResponse(hdr, rsp, "response", path, stat, opCode);
                        break;
                    }
                    default: {
                        responseSize = cnxn.sendResponse(hdr, rsp, "response");
                    }
                }
            }
            if (request.type == -11) {
                cnxn.sendCloseSession();
            }
        }
        catch (IOException e) {
            LOG.error("FIXMSG", (Throwable)e);
        }
        finally {
            ServerMetrics.getMetrics().RESPONSE_BYTES.add(responseSize);
        }
    }

    private Record handleGetChildrenRequest(Record request, ServerCnxn cnxn, List<Id> authInfo) throws KeeperException, IOException {
        GetChildrenRequest getChildrenRequest = (GetChildrenRequest)request;
        String path = getChildrenRequest.getPath();
        DataNode n = this.zks.getZKDatabase().getNode(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        this.zks.checkACL(cnxn, this.zks.getZKDatabase().aclForNode(n), 1, authInfo, path, null);
        List<String> children = this.zks.getZKDatabase().getChildren(path, null, getChildrenRequest.getWatch() ? cnxn : null);
        return new GetChildrenResponse(children);
    }

    private Record handleGetDataRequest(Record request, ServerCnxn cnxn, List<Id> authInfo) throws KeeperException, IOException {
        GetDataRequest getDataRequest = (GetDataRequest)request;
        String path = getDataRequest.getPath();
        DataNode n = this.zks.getZKDatabase().getNode(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        this.zks.checkACL(cnxn, this.zks.getZKDatabase().aclForNode(n), 1, authInfo, path, null);
        Stat stat = new Stat();
        byte[] b = this.zks.getZKDatabase().getData(path, stat, getDataRequest.getWatch() ? cnxn : null);
        return new GetDataResponse(b, stat);
    }

    private boolean closeSession(ServerCnxnFactory serverCnxnFactory, long sessionId) {
        if (serverCnxnFactory == null) {
            return false;
        }
        return serverCnxnFactory.closeSession(sessionId, ServerCnxn.DisconnectReason.CLIENT_CLOSED_SESSION);
    }

    private boolean connClosedByClient(Request request) {
        return request.cnxn == null;
    }

    @Override
    public void shutdown() {
        LOG.info("shutdown of request processor complete");
    }

    private void updateStats(Request request, String lastOp, long lastZxid) {
        if (request.cnxn == null) {
            return;
        }
        long currentTime = Time.currentElapsedTime();
        this.zks.serverStats().updateLatency(request, currentTime);
        request.cnxn.updateStatsForResponse(request.cxid, lastZxid, lastOp, request.createTime, currentTime);
    }
}

