/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import java.util.List;
import org.apache.iceberg.arrow.vectorized.BaseBatchReader;
import org.apache.iceberg.arrow.vectorized.ColumnVector;
import org.apache.iceberg.arrow.vectorized.ColumnarBatch;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class ArrowBatchReader
extends BaseBatchReader<ColumnarBatch> {
    ArrowBatchReader(List<VectorizedReader<?>> readers) {
        super(readers);
    }

    public final ColumnarBatch read(ColumnarBatch reuse, int numRowsToRead) {
        Preconditions.checkArgument((numRowsToRead > 0 ? 1 : 0) != 0, (String)"Invalid number of rows to read: %s", (int)numRowsToRead);
        if (reuse == null) {
            this.closeVectors();
        }
        ColumnVector[] columnVectors = new ColumnVector[this.readers.length];
        for (int i = 0; i < this.readers.length; ++i) {
            this.vectorHolders[i] = this.readers[i].read(this.vectorHolders[i], numRowsToRead);
            int numRowsInVector = this.vectorHolders[i].numValues();
            Preconditions.checkState((numRowsInVector == numRowsToRead ? 1 : 0) != 0, (String)"Number of rows in the vector %s didn't match expected %s ", (int)numRowsInVector, (int)numRowsToRead);
            columnVectors[i] = new ColumnVector(this.vectorHolders[i]);
        }
        return new ColumnarBatch(numRowsToRead, columnVectors);
    }
}

