/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.services.kms.model.MacAlgorithmSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyMacRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, VerifyMacRequest> {
    private static final SdkField<SdkBytes> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Message").getter(VerifyMacRequest.getter(VerifyMacRequest::message)).setter(VerifyMacRequest.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(VerifyMacRequest.getter(VerifyMacRequest::keyId)).setter(VerifyMacRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> MAC_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacAlgorithm").getter(VerifyMacRequest.getter(VerifyMacRequest::macAlgorithmAsString)).setter(VerifyMacRequest.setter(Builder::macAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAlgorithm").build()}).build();
    private static final SdkField<SdkBytes> MAC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Mac").getter(VerifyMacRequest.getter(VerifyMacRequest::mac)).setter(VerifyMacRequest.setter(Builder::mac)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mac").build()}).build();
    private static final SdkField<List<String>> GRANT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GrantTokens").getter(VerifyMacRequest.getter(VerifyMacRequest::grantTokens)).setter(VerifyMacRequest.setter(Builder::grantTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(VerifyMacRequest.getter(VerifyMacRequest::dryRun)).setter(VerifyMacRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, KEY_ID_FIELD, MAC_ALGORITHM_FIELD, MAC_FIELD, GRANT_TOKENS_FIELD, DRY_RUN_FIELD));
    private final SdkBytes message;
    private final String keyId;
    private final String macAlgorithm;
    private final SdkBytes mac;
    private final List<String> grantTokens;
    private final Boolean dryRun;

    private VerifyMacRequest(BuilderImpl builder) {
        super(builder);
        this.message = builder.message;
        this.keyId = builder.keyId;
        this.macAlgorithm = builder.macAlgorithm;
        this.mac = builder.mac;
        this.grantTokens = builder.grantTokens;
        this.dryRun = builder.dryRun;
    }

    public final SdkBytes message() {
        return this.message;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final MacAlgorithmSpec macAlgorithm() {
        return MacAlgorithmSpec.fromValue(this.macAlgorithm);
    }

    public final String macAlgorithmAsString() {
        return this.macAlgorithm;
    }

    public final SdkBytes mac() {
        return this.mac;
    }

    public final boolean hasGrantTokens() {
        return this.grantTokens != null && !(this.grantTokens instanceof SdkAutoConstructList);
    }

    public final List<String> grantTokens() {
        return this.grantTokens;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mac());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantTokens() ? this.grantTokens() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyMacRequest)) {
            return false;
        }
        VerifyMacRequest other = (VerifyMacRequest)((Object)obj);
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.macAlgorithmAsString(), other.macAlgorithmAsString()) && Objects.equals(this.mac(), other.mac()) && this.hasGrantTokens() == other.hasGrantTokens() && Objects.equals(this.grantTokens(), other.grantTokens()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyMacRequest").add("Message", (Object)(this.message() == null ? null : "*** Sensitive Data Redacted ***")).add("KeyId", (Object)this.keyId()).add("MacAlgorithm", (Object)this.macAlgorithmAsString()).add("Mac", (Object)this.mac()).add("GrantTokens", this.hasGrantTokens() ? this.grantTokens() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "MacAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.macAlgorithmAsString()));
            }
            case "Mac": {
                return Optional.ofNullable(clazz.cast(this.mac()));
            }
            case "GrantTokens": {
                return Optional.ofNullable(clazz.cast(this.grantTokens()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyMacRequest, T> g) {
        return obj -> g.apply((VerifyMacRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private SdkBytes message;
        private String keyId;
        private String macAlgorithm;
        private SdkBytes mac;
        private List<String> grantTokens = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyMacRequest model) {
            super(model);
            this.message(model.message);
            this.keyId(model.keyId);
            this.macAlgorithm(model.macAlgorithm);
            this.mac(model.mac);
            this.grantTokens(model.grantTokens);
            this.dryRun(model.dryRun);
        }

        public final ByteBuffer getMessage() {
            return this.message == null ? null : this.message.asByteBuffer();
        }

        public final void setMessage(ByteBuffer message) {
            this.message(message == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)message));
        }

        @Override
        public final Builder message(SdkBytes message) {
            this.message = message;
            return this;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getMacAlgorithm() {
            return this.macAlgorithm;
        }

        public final void setMacAlgorithm(String macAlgorithm) {
            this.macAlgorithm = macAlgorithm;
        }

        @Override
        public final Builder macAlgorithm(String macAlgorithm) {
            this.macAlgorithm = macAlgorithm;
            return this;
        }

        @Override
        public final Builder macAlgorithm(MacAlgorithmSpec macAlgorithm) {
            this.macAlgorithm(macAlgorithm == null ? null : macAlgorithm.toString());
            return this;
        }

        public final ByteBuffer getMac() {
            return this.mac == null ? null : this.mac.asByteBuffer();
        }

        public final void setMac(ByteBuffer mac) {
            this.mac(mac == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)mac));
        }

        @Override
        public final Builder mac(SdkBytes mac) {
            this.mac = mac;
            return this;
        }

        public final Collection<String> getGrantTokens() {
            if (this.grantTokens instanceof SdkAutoConstructList) {
                return null;
            }
            return this.grantTokens;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyMacRequest build() {
            return new VerifyMacRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyMacRequest> {
        public Builder message(SdkBytes var1);

        public Builder keyId(String var1);

        public Builder macAlgorithm(String var1);

        public Builder macAlgorithm(MacAlgorithmSpec var1);

        public Builder mac(SdkBytes var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

