/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.block.factory;

import org.eclipse.collections.api.block.SerializableComparator;
import org.eclipse.collections.api.block.comparator.FunctionComparator;
import org.eclipse.collections.api.block.function.Function;

public final class SerializableComparators {
    private static final SerializableComparator<?> NATURAL_ORDER_COMPARATOR = new NaturalOrderComparator();
    private static final SerializableComparator<?> REVERSE_NATURAL_ORDER_COMPARATOR = new ReverseComparator(NATURAL_ORDER_COMPARATOR);

    private SerializableComparators() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> SerializableComparator<T> naturalOrder() {
        return NATURAL_ORDER_COMPARATOR;
    }

    public static <T> SerializableComparator<T> reverseNaturalOrder() {
        return REVERSE_NATURAL_ORDER_COMPARATOR;
    }

    public static <T> SerializableComparator<T> reverse(SerializableComparator<T> comparator) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        return new ReverseComparator(comparator);
    }

    public static <T, V extends Comparable<? super V>> SerializableComparator<T> byFunction(Function<? super T, ? extends V> function) {
        return SerializableComparators.byFunction(function, SerializableComparators.naturalOrder());
    }

    public static <T, V> SerializableComparator<T> byFunction(Function<? super T, ? extends V> function, SerializableComparator<V> comparator) {
        return new FunctionComparator<T, V>(function, comparator);
    }

    private static final class ReverseComparator<T>
    implements SerializableComparator<T> {
        private static final long serialVersionUID = 1L;
        private final SerializableComparator<T> comparator;

        private ReverseComparator(SerializableComparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(T o1, T o2) {
            return this.comparator.compare(o2, o1);
        }
    }

    private static final class NaturalOrderComparator<T extends Comparable<T>>
    implements SerializableComparator<T> {
        private static final long serialVersionUID = 1L;

        private NaturalOrderComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == null || o2 == null) {
                throw new NullPointerException();
            }
            return o1.compareTo(o2);
        }
    }
}

