/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizer.common;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.amoro.api.OptimizingTask;
import org.apache.amoro.api.OptimizingTaskResult;
import org.apache.amoro.optimizer.common.AbstractOptimizerOperator;
import org.apache.amoro.optimizer.common.OptimizerConfig;
import org.apache.amoro.optimizing.OptimizingExecutor;
import org.apache.amoro.optimizing.OptimizingExecutorFactory;
import org.apache.amoro.optimizing.OptimizingInputProperties;
import org.apache.amoro.optimizing.TableOptimizing;
import org.apache.amoro.shade.thrift.org.apache.thrift.TException;
import org.apache.amoro.utils.ExceptionUtil;
import org.apache.amoro.utils.SerializationUtil;
import org.apache.iceberg.common.DynConstructors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerExecutor
extends AbstractOptimizerOperator {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizerExecutor.class);
    protected static final int ERROR_MESSAGE_MAX_LENGTH = 4000;
    private final int threadId;

    public OptimizerExecutor(OptimizerConfig config, int threadId) {
        super(config);
        this.threadId = threadId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        while (this.isStarted()) {
            OptimizingTask ackTask = null;
            OptimizingTaskResult result = null;
            try {
                OptimizingTask task = this.pollTask();
                if (task != null && this.ackTask(task)) {
                    ackTask = task;
                    result = this.executeTask(task);
                }
                if (result == null) continue;
                this.completeTask(result);
            }
            catch (Throwable t) {
                try {
                    if (ackTask != null) {
                        LOG.error("Optimizer executor[{}] handling task[{}] failed and got an unknown error", new Object[]{this.threadId, ackTask.getTaskId(), t});
                        String errorMessage = ExceptionUtil.getErrorMessage((Throwable)t, (int)4000);
                        result = new OptimizingTaskResult(ackTask.getTaskId(), this.threadId);
                        result.setErrorMessage(errorMessage);
                    } else {
                        LOG.error("Optimizer executor[{}] got an unexpected error", (Object)this.threadId, (Object)t);
                    }
                    if (result == null) continue;
                    this.completeTask(result);
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        this.completeTask(result);
                    }
                    throw throwable;
                }
            }
        }
    }

    public int getThreadId() {
        return this.threadId;
    }

    private OptimizingTask pollTask() {
        OptimizingTask task = null;
        while (this.isStarted()) {
            try {
                task = this.callAuthenticatedAms((client, token) -> client.pollTask(token, this.threadId));
            }
            catch (TException exception) {
                LOG.error("Optimizer executor[{}] polled task failed", (Object)this.threadId, (Object)exception);
            }
            if (task != null) {
                LOG.info("Optimizer executor[{}] polled task[{}] from ams", (Object)this.threadId, (Object)task.getTaskId());
                break;
            }
            this.waitAShortTime();
        }
        return task;
    }

    private boolean ackTask(OptimizingTask task) {
        try {
            this.callAuthenticatedAms((client, token) -> {
                client.ackTask(token, this.threadId, task.getTaskId());
                return null;
            });
            LOG.info("Optimizer executor[{}] acknowledged task[{}] to ams", (Object)this.threadId, (Object)task.getTaskId());
            return true;
        }
        catch (TException exception) {
            LOG.error("Optimizer executor[{}] acknowledged task[{}] failed", new Object[]{this.threadId, task.getTaskId(), exception});
            return false;
        }
    }

    protected OptimizingTaskResult executeTask(OptimizingTask task) {
        return OptimizerExecutor.executeTask(this.getConfig(), this.getThreadId(), task, LOG);
    }

    protected void completeTask(OptimizingTaskResult optimizingTaskResult) {
        try {
            this.callAuthenticatedAms((client, token) -> {
                client.completeTask(token, optimizingTaskResult);
                return null;
            });
            LOG.info("Optimizer executor[{}] completed task[{}](status: {}) to ams", new Object[]{this.threadId, optimizingTaskResult.getTaskId(), optimizingTaskResult.getErrorMessage() == null ? "SUCCESS" : "FAIL"});
        }
        catch (Exception exception) {
            LOG.error("Optimizer executor[{}] completed task[{}](status: {}) failed", new Object[]{this.threadId, optimizingTaskResult.getTaskId(), optimizingTaskResult.getErrorMessage() == null ? "SUCCESS" : "FAIL", exception});
        }
    }

    public static OptimizingTaskResult executeTask(OptimizerConfig config, int threadId, OptimizingTask task, Logger logger) {
        long startTime = System.currentTimeMillis();
        TableOptimizing.OptimizingInput input = null;
        try {
            OptimizingInputProperties properties = OptimizingInputProperties.parse((Map)task.getProperties());
            input = (TableOptimizing.OptimizingInput)SerializationUtil.simpleDeserialize((byte[])task.getTaskInput());
            String executorFactoryImpl = properties.getExecutorFactoryImpl();
            DynConstructors.Ctor ctor = DynConstructors.builder(OptimizingExecutorFactory.class).impl(executorFactoryImpl, new Class[0]).buildChecked();
            OptimizingExecutorFactory factory = (OptimizingExecutorFactory)ctor.newInstance(new Object[0]);
            if (config.isExtendDiskStorage()) {
                properties.enableSpillMap();
            }
            properties.setMaxSizeInMemory(config.getMemoryStorageSize() * 1024L * 1024L);
            properties.setSpillMapPath(config.getDiskStoragePath());
            factory.initialize(properties.getProperties());
            OptimizingExecutor executor = factory.createExecutor(input);
            TableOptimizing.OptimizingOutput output = executor.execute();
            ByteBuffer outputByteBuffer = SerializationUtil.simpleSerialize((Object)output);
            OptimizingTaskResult result = new OptimizingTaskResult(task.getTaskId(), threadId);
            result.setTaskOutput(outputByteBuffer);
            result.setSummary(output.summary());
            logger.info("Optimizer executor[{}] executed task[{}]({}) and cost {} ms", new Object[]{threadId, task.getTaskId(), input, System.currentTimeMillis() - startTime});
            return result;
        }
        catch (Throwable t) {
            logger.error("Optimizer executor[{}] executed task[{}] failed and cost {} ms", new Object[]{threadId, task.getTaskId(), System.currentTimeMillis() - startTime, t});
            OptimizingTaskResult errorResult = new OptimizingTaskResult(task.getTaskId(), threadId);
            errorResult.setErrorMessage(ExceptionUtil.getErrorMessage((Throwable)t, (int)4000));
            return errorResult;
        }
    }
}

