/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.common;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBeanMBean;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.arjuna.objectstore.ShadowNoFileLockStore;
import com.arjuna.common.internal.util.propertyservice.FullPropertyName;
import com.arjuna.common.internal.util.propertyservice.PropertyPrefix;
import java.io.File;
import java.lang.reflect.Method;
import javax.sql.DataSource;

@PropertyPrefix(prefix="com.arjuna.ats.arjuna.objectstore.")
public class ObjectStoreEnvironmentBean
implements ObjectStoreEnvironmentBeanMBean {
    private volatile String localOSRoot = "defaultStore";
    private volatile String objectStoreDir = System.getProperty("user.dir") + File.separator + "ObjectStore";
    private volatile boolean objectStoreSync = true;
    private volatile String objectStoreType = ShadowNoFileLockStore.class.getName();
    private volatile int hashedDirectories = 255;
    private volatile boolean transactionSync = true;
    private volatile boolean scanZeroLengthFiles = false;
    private volatile int share = 14;
    private volatile int hierarchyRetry = 100;
    private volatile int hierarchyTimeout = 100;
    private volatile boolean volatileStoreSupportAllObjUids;
    @FullPropertyName(name="com.arjuna.ats.internal.arjuna.objectstore.cacheStore.size")
    private volatile int cacheStoreSize = 10240;
    @FullPropertyName(name="com.arjuna.ats.internal.arjuna.objectstore.cacheStore.sync")
    private volatile boolean cacheStoreSync = false;
    @FullPropertyName(name="com.arjuna.ats.internal.arjuna.objectstore.cacheStore.removedItems")
    private volatile int cacheStoreRemovedItems = 256;
    @FullPropertyName(name="com.arjuna.ats.internal.arjuna.objectstore.cacheStore.scanPeriod")
    private volatile int cacheStoreScanPeriod = 120000;
    @FullPropertyName(name="com.arjuna.ats.internal.arjuna.objectstore.cacheStore.workItems")
    private volatile int cacheStoreWorkItems = 100;
    @FullPropertyName(name="com.arjuna.ats.internal.arjuna.objectstore.cacheStore.hash")
    private volatile int cacheStoreHash = 128;
    @FullPropertyName(name="com.arjuna.ats.arjuna.coordinator.transactionLog.synchronousRemoval")
    private volatile boolean synchronousRemoval = true;
    @FullPropertyName(name="com.arjuna.ats.arjuna.coordinator.transactionLog.size")
    private volatile long txLogSize = 0xA00000L;
    @FullPropertyName(name="com.arjuna.ats.arjuna.coordinator.transactionLog.purgeTime")
    private volatile long purgeTime = 100000L;
    private volatile boolean androidDirCheck = false;
    private volatile String jdbcAccess;
    private DataSource jdbcStoreDataSource;
    private volatile String tablePrefix;
    private volatile boolean dropTable;
    private volatile boolean createTable = true;
    private volatile boolean exposeAllLogRecordsAsMBeans = false;
    private volatile boolean ignoreMBeanHeuristics = true;
    private volatile String jmxToolingMBeanName = "jboss.jta:type=ObjectStore";

    @Override
    public int getCacheStoreSize() {
        if (this.cacheStoreSize < 0) {
            return 0;
        }
        return this.cacheStoreSize;
    }

    public void setCacheStoreSize(int cacheStoreSize) {
        this.cacheStoreSize = cacheStoreSize;
    }

    @Override
    public boolean isCacheStoreSync() {
        return this.cacheStoreSync;
    }

    public void setCacheStoreSync(boolean cacheStoreSync) {
        this.cacheStoreSync = cacheStoreSync;
    }

    @Override
    public int getCacheStoreRemovedItems() {
        if (this.cacheStoreRemovedItems < 0) {
            return 0;
        }
        return this.cacheStoreRemovedItems;
    }

    public void setCacheStoreRemovedItems(int cacheStoreRemovedItems) {
        this.cacheStoreRemovedItems = cacheStoreRemovedItems;
    }

    @Override
    public int getCacheStoreScanPeriod() {
        return this.cacheStoreScanPeriod;
    }

    public void setCacheStoreScanPeriod(int cacheStoreScanPeriod) {
        this.cacheStoreScanPeriod = cacheStoreScanPeriod;
    }

    @Override
    public int getCacheStoreWorkItems() {
        if (this.cacheStoreWorkItems < 0) {
            return 0;
        }
        return this.cacheStoreWorkItems;
    }

    public void setCacheStoreWorkItems(int cacheStoreWorkItems) {
        this.cacheStoreWorkItems = cacheStoreWorkItems;
    }

    @Override
    public int getCacheStoreHash() {
        if (this.cacheStoreHash <= 0) {
            return 128;
        }
        return this.cacheStoreHash;
    }

    public void setCacheStoreHash(int cacheStoreHash) {
        this.cacheStoreHash = cacheStoreHash;
    }

    @Override
    public String getLocalOSRoot() {
        return this.localOSRoot;
    }

    public void setLocalOSRoot(String localOSRoot) {
        this.localOSRoot = localOSRoot;
    }

    @Override
    public String getObjectStoreDir() {
        if (Utility.isAndroid() && !this.androidDirCheck) {
            try {
                Class<?> instance = Class.forName("android.os.Environment");
                Method[] mthds = instance.getDeclaredMethods();
                Method m = null;
                for (int i = 0; i < mthds.length && m == null; ++i) {
                    if (!"getExternalStorageDirectory".equals(mthds[i].getName())) continue;
                    m = mthds[i];
                }
                this.objectStoreDir = ((File)m.invoke(null, new Object[0])).toString() + File.separator + "ObjectStore";
                this.androidDirCheck = true;
            }
            catch (Throwable ex) {
                tsLogger.i18NLogger.warn_objectstore_directory_location(ex);
            }
        }
        return this.objectStoreDir;
    }

    public void setObjectStoreDir(String objectStoreDir) {
        this.objectStoreDir = objectStoreDir;
    }

    @Override
    public boolean isObjectStoreSync() {
        return this.objectStoreSync;
    }

    public void setObjectStoreSync(boolean objectStoreSync) {
        this.objectStoreSync = objectStoreSync;
    }

    @Override
    public String getObjectStoreType() {
        return this.objectStoreType;
    }

    public void setObjectStoreType(String objectStoreType) {
        this.objectStoreType = objectStoreType;
    }

    @Override
    public int getHashedDirectories() {
        if (this.hashedDirectories <= 0) {
            tsLogger.i18NLogger.warn_objectstore_HashedStore_2(Integer.toString(this.hashedDirectories));
            return 255;
        }
        return this.hashedDirectories;
    }

    public void setHashedDirectories(int hashedDirectories) {
        this.hashedDirectories = hashedDirectories;
    }

    @Override
    public boolean isTransactionSync() {
        return this.transactionSync;
    }

    public void setTransactionSync(boolean transactionSync) {
        this.transactionSync = transactionSync;
    }

    public boolean isScanZeroLengthFiles() {
        return this.scanZeroLengthFiles;
    }

    public void setScanZeroLengthFiles(boolean scanZeroLengthFiles) {
        this.scanZeroLengthFiles = scanZeroLengthFiles;
    }

    @Override
    public int getShare() {
        return this.share;
    }

    public void setShare(int share) {
        this.share = share;
    }

    @Override
    public int getHierarchyRetry() {
        if (this.hierarchyRetry < 0) {
            return 100;
        }
        return this.hierarchyRetry;
    }

    public void setHierarchyRetry(int hierarchyRetry) {
        this.hierarchyRetry = hierarchyRetry;
    }

    @Override
    public int getHierarchyTimeout() {
        if (this.hierarchyTimeout < 0) {
            return 100;
        }
        return this.hierarchyTimeout;
    }

    public void setHierarchyTimeout(int hierarchyTimeout) {
        this.hierarchyTimeout = hierarchyTimeout;
    }

    @Override
    public boolean isSynchronousRemoval() {
        return this.synchronousRemoval;
    }

    public void setSynchronousRemoval(boolean synchronousRemoval) {
        this.synchronousRemoval = synchronousRemoval;
    }

    @Override
    public long getTxLogSize() {
        return this.txLogSize;
    }

    public void setTxLogSize(long txLogSize) {
        this.txLogSize = txLogSize;
    }

    @Override
    public long getPurgeTime() {
        return this.purgeTime;
    }

    public void setPurgeTime(long purgeTime) {
        this.purgeTime = purgeTime;
    }

    @Override
    public String getJdbcAccess() {
        return this.jdbcAccess;
    }

    @Override
    public void setJdbcAccess(String connectionDetails) {
        this.jdbcAccess = connectionDetails;
    }

    public void setJdbcDataSource(DataSource jdbcStoreDataSource) {
        this.jdbcStoreDataSource = jdbcStoreDataSource;
    }

    public DataSource getJdbcDataSource() {
        return this.jdbcStoreDataSource;
    }

    @Override
    public String getTablePrefix() {
        return this.tablePrefix;
    }

    @Override
    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    @Override
    public boolean getDropTable() {
        return this.dropTable;
    }

    @Override
    public void setDropTable(boolean dropTable) {
        this.dropTable = dropTable;
    }

    public boolean getCreateTable() {
        return this.createTable;
    }

    public void setCreateTable(boolean createTable) {
        this.createTable = createTable;
    }

    public boolean getExposeAllLogRecordsAsMBeans() {
        return this.exposeAllLogRecordsAsMBeans;
    }

    public void setExposeAllLogRecordsAsMBeans(boolean exposeAllLogRecords) {
        this.exposeAllLogRecordsAsMBeans = exposeAllLogRecords;
    }

    public void setIgnoreMBeanHeuristics(boolean ignoreMBeanHeuristics) {
        this.ignoreMBeanHeuristics = ignoreMBeanHeuristics;
    }

    public boolean isIgnoreMBeanHeuristics() {
        return this.ignoreMBeanHeuristics;
    }

    public boolean isVolatileStoreSupportAllObjUids() {
        return this.volatileStoreSupportAllObjUids;
    }

    public void setVolatileStoreSupportAllObjUids(boolean volatileStoreSupportAllObjUids) {
        this.volatileStoreSupportAllObjUids = volatileStoreSupportAllObjUids;
    }

    public void setJmxToolingMBeanName(String jmxToolingMBeanName) {
        this.jmxToolingMBeanName = jmxToolingMBeanName;
    }

    public String getJmxToolingMBeanName() {
        return this.jmxToolingMBeanName;
    }
}

