/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.AsyncTaskType;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.PolarisObjectMapperUtil;

public class TaskEntity
extends PolarisEntity {
    public TaskEntity(PolarisBaseEntity sourceEntity) {
        super(sourceEntity);
    }

    public static TaskEntity of(PolarisBaseEntity polarisEntity) {
        if (polarisEntity != null) {
            return new TaskEntity(polarisEntity);
        }
        return null;
    }

    public <T> T readData(Class<T> klass) {
        PolarisCallContext polarisCallContext = CallContext.getCurrentContext().getPolarisCallContext();
        return PolarisObjectMapperUtil.deserialize(polarisCallContext, this.getPropertiesAsMap().get("data"), klass);
    }

    public AsyncTaskType getTaskType() {
        PolarisCallContext polarisCallContext = CallContext.getCurrentContext().getPolarisCallContext();
        return PolarisObjectMapperUtil.deserialize(polarisCallContext, this.getPropertiesAsMap().get("taskType"), AsyncTaskType.class);
    }

    public static class Builder
    extends PolarisEntity.BaseBuilder<TaskEntity, Builder> {
        public Builder() {
            this.setType(PolarisEntityType.TASK);
            this.setCatalogId(PolarisEntityConstants.getNullId());
            this.setParentId(PolarisEntityConstants.getRootEntityId());
        }

        public Builder(TaskEntity original) {
            super(original);
        }

        public Builder withTaskType(AsyncTaskType taskType) {
            PolarisCallContext polarisCallContext = CallContext.getCurrentContext().getPolarisCallContext();
            this.properties.put("taskType", PolarisObjectMapperUtil.serialize(polarisCallContext, (Object)taskType));
            return this;
        }

        public Builder withData(Object data) {
            PolarisCallContext polarisCallContext = CallContext.getCurrentContext().getPolarisCallContext();
            this.properties.put("data", PolarisObjectMapperUtil.serialize(polarisCallContext, data));
            return this;
        }

        public Builder withLastAttemptExecutorId(String executorId) {
            this.properties.put("lastAttemptExecutorId", executorId);
            return this;
        }

        public Builder withAttemptCount(int count) {
            this.properties.put("attemptCount", String.valueOf(count));
            return this;
        }

        public Builder withLastAttemptStartedTimestamp(long timestamp) {
            this.properties.put("lastAttemptStartTime", String.valueOf(timestamp));
            return this;
        }

        @Override
        public TaskEntity build() {
            return new TaskEntity(this.buildBase());
        }
    }
}

