/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.RequestRetryCondition;
import java.time.Duration;

public interface RetryStrategy {
    public static final int HTTP_STATUS_TOO_MANY_REQUESTS = 429;

    public int getMaxRetries();

    public Duration calculateRetryDelay(int var1);

    default public boolean shouldRetry(HttpResponse httpResponse) {
        int code = httpResponse.getStatusCode();
        return code == 408 || code == 429 || code >= 500 && code != 501 && code != 505;
    }

    default public boolean shouldRetryException(Throwable throwable) {
        return throwable instanceof Exception;
    }

    default public boolean shouldRetryCondition(RequestRetryCondition requestRetryCondition) {
        if (requestRetryCondition.getResponse() != null) {
            return this.shouldRetry(requestRetryCondition.getResponse());
        }
        return this.shouldRetryException(requestRetryCondition.getThrowable());
    }
}

