/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobAccessPolicy
implements XmlSerializable<BlobAccessPolicy> {
    private OffsetDateTime startsOn;
    private OffsetDateTime expiresOn;
    private String permissions;

    public OffsetDateTime getStartsOn() {
        return this.startsOn;
    }

    public BlobAccessPolicy setStartsOn(OffsetDateTime startsOn) {
        this.startsOn = startsOn;
        return this;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public BlobAccessPolicy setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public BlobAccessPolicy setPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "BlobAccessPolicy" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Start", this.startsOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startsOn));
        xmlWriter.writeStringElement("Expiry", this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        xmlWriter.writeStringElement("Permission", this.permissions);
        return xmlWriter.writeEndElement();
    }

    public static BlobAccessPolicy fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobAccessPolicy.fromXml(xmlReader, null);
    }

    public static BlobAccessPolicy fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "BlobAccessPolicy" : rootElementName;
        return (BlobAccessPolicy)xmlReader.readObject(finalRootElementName, reader -> {
            BlobAccessPolicy deserializedBlobAccessPolicy = new BlobAccessPolicy();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Start".equals(elementName.getLocalPart())) {
                    deserializedBlobAccessPolicy.startsOn = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("Expiry".equals(elementName.getLocalPart())) {
                    deserializedBlobAccessPolicy.expiresOn = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("Permission".equals(elementName.getLocalPart())) {
                    deserializedBlobAccessPolicy.permissions = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobAccessPolicy;
        });
    }
}

