/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.config;

import java.util.List;
import java.util.Optional;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.connection.ConnectionType;
import org.apache.polaris.core.context.CallContext;

public class FeatureConfiguration<T>
extends PolarisConfiguration<T> {
    public static final FeatureConfiguration<Boolean> ENFORCE_PRINCIPAL_CREDENTIAL_ROTATION_REQUIRED_CHECKING = PolarisConfiguration.builder().key("ENFORCE_PRINCIPAL_CREDENTIAL_ROTATION_REQUIRED_CHECKING").description("If set to true, require that principals must rotate their credentials before being used for anything else.").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> SKIP_CREDENTIAL_SUBSCOPING_INDIRECTION = PolarisConfiguration.builder().key("SKIP_CREDENTIAL_SUBSCOPING_INDIRECTION").description("If set to true, skip credential-subscoping indirection entirely whenever trying\n   to obtain storage credentials for instantiating a FileIO. If 'true', no attempt is made\n   to use StorageConfigs to generate table-specific storage credentials, but instead the default\n   fallthrough of table-level credential properties or else provider-specific APPLICATION_DEFAULT\n   credential-loading will be used for the FileIO.\n   Typically this setting is used in single-tenant server deployments that don't rely on\n   \"credential-vending\" and can use server-default environment variables or credential config\n   files for all storage access, or in test/dev scenarios.").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> ALLOW_TABLE_LOCATION_OVERLAP = PolarisConfiguration.builder().key("ALLOW_TABLE_LOCATION_OVERLAP").catalogConfig("polaris.config.allow.overlapping.table.location").catalogConfigUnsafe("allow.overlapping.table.location").description("If set to true, allow one table's location to reside within another table's location. This is only enforced within a given namespace.").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> ALLOW_NAMESPACE_LOCATION_OVERLAP = PolarisConfiguration.builder().key("ALLOW_NAMESPACE_LOCATION_OVERLAP").description("If set to true, allow one namespace's location to reside within another namespace's location. This is only enforced within a parent catalog or namespace.").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> ALLOW_EXTERNAL_METADATA_FILE_LOCATION = PolarisConfiguration.builder().key("ALLOW_EXTERNAL_METADATA_FILE_LOCATION").description("If set to true, allows metadata files to be located outside the default metadata directory.").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> ALLOW_OVERLAPPING_CATALOG_URLS = PolarisConfiguration.builder().key("ALLOW_OVERLAPPING_CATALOG_URLS").description("If set to true, allows catalog URLs to overlap.").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> ALLOW_UNSTRUCTURED_TABLE_LOCATION = PolarisConfiguration.builder().key("ALLOW_UNSTRUCTURED_TABLE_LOCATION").catalogConfig("polaris.config.allow.unstructured.table.location").catalogConfigUnsafe("allow.unstructured.table.location").description("If set to true, allows unstructured table locations.").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> ALLOW_EXTERNAL_TABLE_LOCATION = PolarisConfiguration.builder().key("ALLOW_EXTERNAL_TABLE_LOCATION").catalogConfig("polaris.config.allow.external.table.location").catalogConfigUnsafe("allow.external.table.location").description("If set to true, allows tables to have external locations outside the default structure.").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> ALLOW_EXTERNAL_CATALOG_CREDENTIAL_VENDING = PolarisConfiguration.builder().key("ALLOW_EXTERNAL_CATALOG_CREDENTIAL_VENDING").catalogConfig("polaris.config.enable.credential.vending").catalogConfigUnsafe("enable.credential.vending").description("If set to true, allow credential vending for external catalogs.").defaultValue(true).buildFeatureConfiguration();
    public static final FeatureConfiguration<List<String>> SUPPORTED_CATALOG_STORAGE_TYPES = PolarisConfiguration.builder().key("SUPPORTED_CATALOG_STORAGE_TYPES").catalogConfig("polaris.config.supported.storage.types").catalogConfigUnsafe("supported.storage.types").description("The list of supported storage types for a catalog").defaultValue(List.of(StorageConfigInfo.StorageTypeEnum.S3.name(), StorageConfigInfo.StorageTypeEnum.AZURE.name(), StorageConfigInfo.StorageTypeEnum.GCS.name())).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> CLEANUP_ON_NAMESPACE_DROP = PolarisConfiguration.builder().key("CLEANUP_ON_NAMESPACE_DROP").catalogConfig("polaris.config.cleanup.on.namespace.drop").catalogConfigUnsafe("cleanup.on.namespace.drop").description("If set to true, clean up data when a namespace is dropped").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> CLEANUP_ON_CATALOG_DROP = PolarisConfiguration.builder().key("CLEANUP_ON_CATALOG_DROP").catalogConfig("polaris.config.cleanup.on.catalog.drop").catalogConfigUnsafe("cleanup.on.catalog.drop").description("If set to true, clean up data when a catalog is dropped").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> DROP_WITH_PURGE_ENABLED = PolarisConfiguration.builder().key("DROP_WITH_PURGE_ENABLED").catalogConfig("polaris.config.drop-with-purge.enabled").catalogConfigUnsafe("drop-with-purge.enabled").description("If set to true, allows tables to be dropped with the purge parameter set to true.").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Integer> STORAGE_CREDENTIAL_DURATION_SECONDS = PolarisConfiguration.builder().key("STORAGE_CREDENTIAL_DURATION_SECONDS").description("The duration of time that vended storage credentials are valid for. Support for longer (or shorter) durations is dependent on the storage provider. GCS current does not respect this value.").defaultValue(3600).buildFeatureConfiguration();
    public static final FeatureConfiguration<Integer> STORAGE_CREDENTIAL_CACHE_DURATION_SECONDS = PolarisConfiguration.builder().key("STORAGE_CREDENTIAL_CACHE_DURATION_SECONDS").description("How long to store storage credentials in the local cache. This should be less than " + FeatureConfiguration.STORAGE_CREDENTIAL_DURATION_SECONDS.key).defaultValue(1800).buildFeatureConfiguration();
    public static final FeatureConfiguration<Integer> MAX_METADATA_REFRESH_RETRIES = PolarisConfiguration.builder().key("MAX_METADATA_REFRESH_RETRIES").description("How many times to retry refreshing metadata when the previous error was retryable").defaultValue(2).buildFeatureConfiguration();
    public static final PolarisConfiguration<Boolean> LIST_PAGINATION_ENABLED = PolarisConfiguration.builder().key("LIST_PAGINATION_ENABLED").description("If set to true, pagination for APIs like listTables is enabled.").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> ENABLE_GENERIC_TABLES = PolarisConfiguration.builder().key("ENABLE_GENERIC_TABLES").description("If true, the generic-tables endpoints are enabled").defaultValue(true).buildFeatureConfiguration();
    public static final FeatureConfiguration<Long> ENTITY_CACHE_WEIGHER_TARGET = PolarisConfiguration.builder().key("ENTITY_CACHE_WEIGHER_TARGET").description("The maximum weight for the entity cache. This is a heuristic value without any particular unit of measurement. It roughly correlates with the total heap size of cached values. Fine-tuning requires experimentation in the specific deployment environment").defaultValue(0x6400000L).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> ENABLE_CATALOG_FEDERATION = PolarisConfiguration.builder().key("ENABLE_CATALOG_FEDERATION").description("If true, allows creating and using ExternalCatalogs containing ConnectionConfigInfos to perform federation to remote catalogs.").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> ENABLE_POLICY_STORE = PolarisConfiguration.builder().key("ENABLE_POLICY_STORE").description("If true, the policy-store endpoints are enabled").defaultValue(true).buildFeatureConfiguration();
    public static final FeatureConfiguration<List<String>> SUPPORTED_CATALOG_CONNECTION_TYPES = PolarisConfiguration.builder().key("SUPPORTED_CATALOG_CONNECTION_TYPES").description("The list of supported catalog connection types for federation").defaultValue(List.of(ConnectionType.ICEBERG_REST.name())).buildFeatureConfiguration();
    public static final FeatureConfiguration<Integer> ICEBERG_COMMIT_MAX_RETRIES = PolarisConfiguration.builder().key("ICEBERG_COMMIT_MAX_RETRIES").catalogConfig("polaris.config.iceberg-commit-max-retries").description("The max number of times to try committing to an Iceberg table").defaultValue(4).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> ALLOW_SPECIFYING_FILE_IO_IMPL = PolarisConfiguration.builder().key("ALLOW_SPECIFYING_FILE_IO_IMPL").description("Config key for whether to allow setting the FILE_IO_IMPL using catalog properties. Must only be enabled in dev/test environments, should not be in production systems.").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> ALLOW_INSECURE_STORAGE_TYPES = PolarisConfiguration.builder().key("ALLOW_INSECURE_STORAGE_TYPES").description("Allow usage of FileIO implementations that are considered insecure. Enabling this setting may expose the service to possibly severe security risks!This should only be set to 'true' for tests!").defaultValue(false).buildFeatureConfiguration();
    public static final FeatureConfiguration<Boolean> ICEBERG_ROLLBACK_COMPACTION_ON_CONFLICTS = PolarisConfiguration.builder().key("ICEBERG_ROLLBACK_COMPACTION_ON_CONFLICTS").catalogConfig("polaris.config.rollback.compaction.on-conflicts.enabled").description("Rollback replace snapshots created by compaction which have polaris.internal.conflict-resolution.by-operation-type.replace property set to rollback in their snapshot summary").defaultValue(false).buildFeatureConfiguration();

    protected FeatureConfiguration(String key, String description, T defaultValue, Optional<String> catalogConfig, Optional<String> catalogConfigUnsafe) {
        super(key, description, defaultValue, catalogConfig, catalogConfigUnsafe);
    }

    public static void enforceFeatureEnabledOrThrow(CallContext callContext, FeatureConfiguration<Boolean> featureConfig) {
        boolean enabled = callContext.getPolarisCallContext().getConfigurationStore().getConfiguration(callContext.getRealmContext(), featureConfig);
        if (!enabled) {
            throw new UnsupportedOperationException("Feature not enabled: " + featureConfig.key);
        }
    }
}

