/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.polaris.core.PolarisDefaultDiagServiceImpl;
import org.apache.polaris.core.admin.model.AwsStorageConfigInfo;
import org.apache.polaris.core.admin.model.AzureStorageConfigInfo;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogProperties;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.ExternalCatalog;
import org.apache.polaris.core.admin.model.FileStorageConfigInfo;
import org.apache.polaris.core.admin.model.GcpStorageConfigInfo;
import org.apache.polaris.core.admin.model.PolarisCatalog;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import org.apache.polaris.core.config.BehaviorChangeConfiguration;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.secrets.UserSecretReference;
import org.apache.polaris.core.storage.FileStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.aws.AwsStorageConfigurationInfo;
import org.apache.polaris.core.storage.azure.AzureStorageConfigurationInfo;
import org.apache.polaris.core.storage.gcp.GcpStorageConfigurationInfo;

public class CatalogEntity
extends PolarisEntity {
    public static final String CATALOG_TYPE_PROPERTY = "catalogType";
    public static final String DEFAULT_BASE_LOCATION_KEY = "default-base-location";
    public static final String REPLACE_NEW_LOCATION_PREFIX_WITH_CATALOG_DEFAULT_KEY = "replace-new-location-prefix-with-catalog-default";

    public CatalogEntity(PolarisBaseEntity sourceEntity) {
        super(sourceEntity);
    }

    public static CatalogEntity of(PolarisBaseEntity sourceEntity) {
        if (sourceEntity != null) {
            return new CatalogEntity(sourceEntity);
        }
        return null;
    }

    public static CatalogEntity fromCatalog(Catalog catalog) {
        Builder builder = ((Builder)((Builder)new Builder().setName(catalog.getName())).setProperties(catalog.getProperties().toMap())).setCatalogType(catalog.getType().name());
        HashMap<String, String> internalProperties = new HashMap<String, String>();
        internalProperties.put(CATALOG_TYPE_PROPERTY, catalog.getType().name());
        builder.setInternalProperties(internalProperties);
        builder.setStorageConfigurationInfo(catalog.getStorageConfigInfo(), CatalogEntity.getDefaultBaseLocation(catalog));
        return builder.build();
    }

    public Catalog asCatalog() {
        Map<String, String> internalProperties = this.getInternalPropertiesAsMap();
        Catalog.TypeEnum catalogType = Optional.ofNullable(internalProperties.get(CATALOG_TYPE_PROPERTY)).map(Catalog.TypeEnum::valueOf).orElseGet(() -> this.getName().equalsIgnoreCase("ROOT") ? Catalog.TypeEnum.INTERNAL : null);
        Map<String, String> propertiesMap = this.getPropertiesAsMap();
        CatalogProperties catalogProps = CatalogProperties.builder((String)propertiesMap.get(DEFAULT_BASE_LOCATION_KEY)).putAll(propertiesMap).build();
        return catalogType == Catalog.TypeEnum.INTERNAL ? PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(this.getName()).setProperties(catalogProps).setCreateTimestamp(Long.valueOf(this.getCreateTimestamp())).setLastUpdateTimestamp(Long.valueOf(this.getLastUpdateTimestamp())).setEntityVersion(Integer.valueOf(this.getEntityVersion())).setStorageConfigInfo(this.getStorageInfo(internalProperties)).build() : ExternalCatalog.builder().setType(Catalog.TypeEnum.EXTERNAL).setName(this.getName()).setProperties(catalogProps).setCreateTimestamp(Long.valueOf(this.getCreateTimestamp())).setLastUpdateTimestamp(Long.valueOf(this.getLastUpdateTimestamp())).setEntityVersion(Integer.valueOf(this.getEntityVersion())).setStorageConfigInfo(this.getStorageInfo(internalProperties)).setConnectionConfigInfo(this.getConnectionInfo(internalProperties)).build();
    }

    private StorageConfigInfo getStorageInfo(Map<String, String> internalProperties) {
        if (internalProperties.containsKey(PolarisEntityConstants.getStorageConfigInfoPropertyName())) {
            PolarisStorageConfigurationInfo configInfo = this.getStorageConfigurationInfo();
            if (configInfo instanceof AwsStorageConfigurationInfo) {
                AwsStorageConfigurationInfo awsConfig = (AwsStorageConfigurationInfo)configInfo;
                return AwsStorageConfigInfo.builder().setRoleArn(awsConfig.getRoleARN()).setExternalId(awsConfig.getExternalId()).setUserArn(awsConfig.getUserARN()).setStorageType(StorageConfigInfo.StorageTypeEnum.S3).setAllowedLocations(awsConfig.getAllowedLocations()).setRegion(awsConfig.getRegion()).build();
            }
            if (configInfo instanceof AzureStorageConfigurationInfo) {
                AzureStorageConfigurationInfo azureConfig = (AzureStorageConfigurationInfo)configInfo;
                return AzureStorageConfigInfo.builder().setTenantId(azureConfig.getTenantId()).setMultiTenantAppName(azureConfig.getMultiTenantAppName()).setConsentUrl(azureConfig.getConsentUrl()).setStorageType(StorageConfigInfo.StorageTypeEnum.AZURE).setAllowedLocations(azureConfig.getAllowedLocations()).build();
            }
            if (configInfo instanceof GcpStorageConfigurationInfo) {
                GcpStorageConfigurationInfo gcpConfigModel = (GcpStorageConfigurationInfo)configInfo;
                return GcpStorageConfigInfo.builder().setGcsServiceAccount(gcpConfigModel.getGcpServiceAccount()).setStorageType(StorageConfigInfo.StorageTypeEnum.GCS).setAllowedLocations(gcpConfigModel.getAllowedLocations()).build();
            }
            if (configInfo instanceof FileStorageConfigurationInfo) {
                FileStorageConfigurationInfo fileConfigModel = (FileStorageConfigurationInfo)configInfo;
                return new FileStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.FILE, fileConfigModel.getAllowedLocations());
            }
            return null;
        }
        return null;
    }

    private ConnectionConfigInfo getConnectionInfo(Map<String, String> internalProperties) {
        if (internalProperties.containsKey(PolarisEntityConstants.getConnectionConfigInfoPropertyName())) {
            ConnectionConfigInfoDpo configInfo = this.getConnectionConfigInfoDpo();
            return configInfo.asConnectionConfigInfoModel();
        }
        return null;
    }

    public String getDefaultBaseLocation() {
        return this.getPropertiesAsMap().get(DEFAULT_BASE_LOCATION_KEY);
    }

    public String getReplaceNewLocationPrefixWithCatalogDefault() {
        return this.getPropertiesAsMap().get(REPLACE_NEW_LOCATION_PREFIX_WITH_CATALOG_DEFAULT_KEY);
    }

    @Nullable
    public PolarisStorageConfigurationInfo getStorageConfigurationInfo() {
        String configStr = this.getInternalPropertiesAsMap().get(PolarisEntityConstants.getStorageConfigInfoPropertyName());
        if (configStr != null) {
            return PolarisStorageConfigurationInfo.deserialize(new PolarisDefaultDiagServiceImpl(), configStr);
        }
        return null;
    }

    public Catalog.TypeEnum getCatalogType() {
        return Optional.ofNullable(this.getInternalPropertiesAsMap().get(CATALOG_TYPE_PROPERTY)).map(Catalog.TypeEnum::valueOf).orElse(null);
    }

    public boolean isPassthroughFacade() {
        return this.getInternalPropertiesAsMap().containsKey(PolarisEntityConstants.getConnectionConfigInfoPropertyName());
    }

    public ConnectionConfigInfoDpo getConnectionConfigInfoDpo() {
        String configStr = this.getInternalPropertiesAsMap().get(PolarisEntityConstants.getConnectionConfigInfoPropertyName());
        if (configStr != null) {
            return ConnectionConfigInfoDpo.deserialize(new PolarisDefaultDiagServiceImpl(), configStr);
        }
        return null;
    }

    @Nonnull
    protected static String getDefaultBaseLocation(Catalog catalog) {
        return catalog.getProperties().getDefaultBaseLocation();
    }

    public static class Builder
    extends PolarisEntity.BaseBuilder<CatalogEntity, Builder> {
        public Builder() {
            this.setType(PolarisEntityType.CATALOG);
            this.setCatalogId(PolarisEntityConstants.getNullId());
            this.setParentId(PolarisEntityConstants.getRootEntityId());
        }

        public Builder(CatalogEntity original) {
            super(original);
        }

        public Builder setCatalogType(String type) {
            this.internalProperties.put(CatalogEntity.CATALOG_TYPE_PROPERTY, type);
            return this;
        }

        public Builder setDefaultBaseLocation(String defaultBaseLocation) {
            this.properties.put(CatalogEntity.DEFAULT_BASE_LOCATION_KEY, defaultBaseLocation);
            return this;
        }

        public Builder setReplaceNewLocationPrefixWithCatalogDefault(String value) {
            this.properties.put(CatalogEntity.REPLACE_NEW_LOCATION_PREFIX_WITH_CATALOG_DEFAULT_KEY, value);
            return this;
        }

        public Builder setStorageConfigurationInfo(StorageConfigInfo storageConfigModel, String defaultBaseLocation) {
            if (storageConfigModel != null) {
                PolarisStorageConfigurationInfo config;
                HashSet<String> allowedLocations = new HashSet<String>(storageConfigModel.getAllowedLocations());
                if (defaultBaseLocation == null) {
                    throw new BadRequestException("Must specify default base location", new Object[0]);
                }
                allowedLocations.add(defaultBaseLocation);
                this.validateMaxAllowedLocations(allowedLocations);
                switch (storageConfigModel.getStorageType()) {
                    case S3: {
                        AwsStorageConfigInfo awsConfigModel = (AwsStorageConfigInfo)storageConfigModel;
                        AwsStorageConfigurationInfo awsConfig = new AwsStorageConfigurationInfo(PolarisStorageConfigurationInfo.StorageType.S3, new ArrayList<String>(allowedLocations), awsConfigModel.getRoleArn(), awsConfigModel.getExternalId(), awsConfigModel.getRegion());
                        AwsStorageConfigurationInfo.validateArn(awsConfigModel.getRoleArn());
                        config = awsConfig;
                        break;
                    }
                    case AZURE: {
                        AzureStorageConfigInfo azureConfigModel = (AzureStorageConfigInfo)storageConfigModel;
                        AzureStorageConfigurationInfo azureConfigInfo = new AzureStorageConfigurationInfo(new ArrayList<String>(allowedLocations), azureConfigModel.getTenantId());
                        azureConfigInfo.setMultiTenantAppName(azureConfigModel.getMultiTenantAppName());
                        azureConfigInfo.setConsentUrl(azureConfigModel.getConsentUrl());
                        config = azureConfigInfo;
                        break;
                    }
                    case GCS: {
                        GcpStorageConfigurationInfo gcpConfig = new GcpStorageConfigurationInfo(new ArrayList<String>(allowedLocations));
                        gcpConfig.setGcpServiceAccount(((GcpStorageConfigInfo)storageConfigModel).getGcsServiceAccount());
                        config = gcpConfig;
                        break;
                    }
                    case FILE: {
                        config = new FileStorageConfigurationInfo(new ArrayList<String>(allowedLocations));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported storage type: " + String.valueOf(storageConfigModel.getStorageType()));
                    }
                }
                this.internalProperties.put(PolarisEntityConstants.getStorageConfigInfoPropertyName(), config.serialize());
            }
            return this;
        }

        private void validateMaxAllowedLocations(Collection<String> allowedLocations) {
            int maxAllowedLocations = BehaviorChangeConfiguration.loadConfig(BehaviorChangeConfiguration.STORAGE_CONFIGURATION_MAX_LOCATIONS);
            if (maxAllowedLocations != -1 && allowedLocations.size() > maxAllowedLocations) {
                throw new IllegalArgumentException(String.format("Number of configured locations (%s) exceeds the limit of %s", allowedLocations.size(), maxAllowedLocations));
            }
        }

        public Builder setConnectionConfigInfoDpoWithSecrets(ConnectionConfigInfo connectionConfigurationModel, Map<String, UserSecretReference> secretReferences) {
            if (connectionConfigurationModel != null) {
                ConnectionConfigInfoDpo config = ConnectionConfigInfoDpo.fromConnectionConfigInfoModelWithSecrets(connectionConfigurationModel, secretReferences);
                this.internalProperties.put(PolarisEntityConstants.getConnectionConfigInfoPropertyName(), config.serialize());
            }
            return this;
        }

        @Override
        public CatalogEntity build() {
            return new CatalogEntity(this.buildBase());
        }
    }
}

