/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.util.Map;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.BasePersistence;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PolarisObjectMapperUtil;
import org.apache.polaris.core.persistence.dao.entity.GenerateEntityIdResult;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;

public abstract class BaseMetaStoreManager
implements PolarisMetaStoreManager {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static PolarisStorageConfigurationInfo extractStorageConfiguration(@Nonnull PolarisCallContext callCtx, PolarisBaseEntity reloadedEntity) {
        Map<String, String> propMap = PolarisObjectMapperUtil.deserializeProperties(callCtx, reloadedEntity.getInternalProperties());
        String storageConfigInfoStr = propMap.get(PolarisEntityConstants.getStorageConfigInfoPropertyName());
        callCtx.getDiagServices().check(storageConfigInfoStr != null, "missing_storage_configuration_info", "catalogId={}, entityId={}", reloadedEntity.getCatalogId(), reloadedEntity.getId());
        return PolarisStorageConfigurationInfo.deserialize(callCtx.getDiagServices(), storageConfigInfoStr);
    }

    public String serializeProperties(PolarisCallContext callCtx, Map<String, String> properties) {
        String jsonString = null;
        try {
            jsonString = MAPPER.writeValueAsString(properties);
        }
        catch (JsonProcessingException ex) {
            callCtx.getDiagServices().fail("got_json_processing_exception", "ex={}", new Object[]{ex});
        }
        return jsonString;
    }

    public Map<String, String> deserializeProperties(PolarisCallContext callCtx, String properties) {
        Map retProperties = null;
        try {
            retProperties = (Map)MAPPER.readValue(properties, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonMappingException ex) {
            callCtx.getDiagServices().fail("got_json_mapping_exception", "ex={}", new Object[]{ex});
        }
        catch (JsonProcessingException ex) {
            callCtx.getDiagServices().fail("got_json_processing_exception", "ex={}", new Object[]{ex});
        }
        return retProperties;
    }

    protected PolarisBaseEntity prepareToPersistNewEntity(@Nonnull PolarisCallContext callCtx, @Nonnull BasePersistence ms, @Nonnull PolarisBaseEntity entity) {
        callCtx.getDiagServices().checkNotNull(entity, "unexpected_null_entity");
        callCtx.getDiagServices().checkNotNull(entity.getName(), "unexpected_null_name", "entity={}", entity);
        PolarisEntityType type = PolarisEntityType.fromCode(entity.getTypeCode());
        callCtx.getDiagServices().checkNotNull(type, "unknown_type", "entity={}", entity);
        PolarisEntitySubType subType = PolarisEntitySubType.fromCode(entity.getSubTypeCode());
        callCtx.getDiagServices().checkNotNull(subType, "unexpected_null_subType", "entity={}", entity);
        callCtx.getDiagServices().check(subType.getParentType() == null || subType.getParentType() == type, "invalid_subtype", "type={} subType={}", new Object[]{type, subType});
        callCtx.getDiagServices().check(!type.isTopLevel() || entity.getParentId() == PolarisEntityConstants.getRootEntityId(), "top_level_parent_should_be_account", "entity={}", entity);
        callCtx.getDiagServices().check(entity.getId() != 0L || type == PolarisEntityType.ROOT, "id_not_set", "entity={}", entity);
        callCtx.getDiagServices().check(entity.getCreateTimestamp() != 0L, "null_create_timestamp");
        entity.setLastUpdateTimestamp(entity.getCreateTimestamp());
        entity.setDropTimestamp(0L);
        entity.setPurgeTimestamp(0L);
        entity.setToPurgeTimestamp(0L);
        return entity;
    }

    @Nonnull
    protected PolarisBaseEntity prepareToPersistEntityAfterChange(@Nonnull PolarisCallContext callCtx, @Nonnull BasePersistence ms, @Nonnull PolarisBaseEntity entity, boolean nameOrParentChanged, @Nonnull PolarisBaseEntity originalEntity) {
        callCtx.getDiagServices().checkNotNull(entity, "unexpected_null_entity");
        callCtx.getDiagServices().checkNotNull(entity.getName(), "unexpected_null_name", "entity={}", entity);
        PolarisEntityType type = entity.getType();
        callCtx.getDiagServices().checkNotNull(type, "unexpected_null_type", "entity={}", entity);
        PolarisEntitySubType subType = entity.getSubType();
        callCtx.getDiagServices().checkNotNull(subType, "unexpected_null_subType", "entity={}", entity);
        callCtx.getDiagServices().check(subType.getParentType() == null || subType.getParentType() == type, "invalid_subtype", "type={} subType={} entity={}", new Object[]{type, subType, entity});
        callCtx.getDiagServices().check(entity.getDropTimestamp() == 0L, "entity_dropped", "entity={}", entity);
        long createTimestamp = entity.getCreateTimestamp();
        callCtx.getDiagServices().check(createTimestamp != 0L, "null_create_timestamp", "entity={}", entity);
        long now = System.currentTimeMillis();
        if (now < entity.getCreateTimestamp()) {
            now = entity.getCreateTimestamp() + 1L;
        }
        entity.setLastUpdateTimestamp(now);
        entity.setEntityVersion(entity.getEntityVersion() + 1);
        return entity;
    }

    @Override
    @Nonnull
    public GenerateEntityIdResult generateNewEntityId(@Nonnull PolarisCallContext callCtx) {
        BasePersistence ms = callCtx.getMetaStore();
        return new GenerateEntityIdResult(ms.generateNewId(callCtx));
    }
}

