/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.transactional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.entity.AsyncTaskType;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisChangeTrackingVersions;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityId;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.entity.PolarisPrivilege;
import org.apache.polaris.core.persistence.BaseMetaStoreManager;
import org.apache.polaris.core.persistence.PolarisObjectMapperUtil;
import org.apache.polaris.core.persistence.PolicyMappingAlreadyExistsException;
import org.apache.polaris.core.persistence.RetryOnConcurrencyException;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.ChangeTrackingResult;
import org.apache.polaris.core.persistence.dao.entity.CreateCatalogResult;
import org.apache.polaris.core.persistence.dao.entity.CreatePrincipalResult;
import org.apache.polaris.core.persistence.dao.entity.DropEntityResult;
import org.apache.polaris.core.persistence.dao.entity.EntitiesResult;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.EntityWithPath;
import org.apache.polaris.core.persistence.dao.entity.ListEntitiesResult;
import org.apache.polaris.core.persistence.dao.entity.LoadGrantsResult;
import org.apache.polaris.core.persistence.dao.entity.LoadPolicyMappingsResult;
import org.apache.polaris.core.persistence.dao.entity.PolicyAttachmentResult;
import org.apache.polaris.core.persistence.dao.entity.PrincipalSecretsResult;
import org.apache.polaris.core.persistence.dao.entity.PrivilegeResult;
import org.apache.polaris.core.persistence.dao.entity.ResolvedEntityResult;
import org.apache.polaris.core.persistence.dao.entity.ScopedCredentialsResult;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.persistence.transactional.PolarisEntityResolver;
import org.apache.polaris.core.persistence.transactional.TransactionalPersistence;
import org.apache.polaris.core.policy.PolarisPolicyMappingRecord;
import org.apache.polaris.core.policy.PolicyEntity;
import org.apache.polaris.core.policy.PolicyMappingUtil;
import org.apache.polaris.core.policy.PolicyType;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;
import org.apache.polaris.core.storage.StorageAccessProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
public class TransactionalMetaStoreManagerImpl
extends BaseMetaStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalMetaStoreManagerImpl.class);

    protected void persistNewEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisBaseEntity entity) {
        entity = this.prepareToPersistNewEntity(callCtx, ms, entity);
        ms.writeEntityInCurrentTxn(callCtx, entity, true, null);
    }

    @Nonnull
    private PolarisBaseEntity persistEntityAfterChange(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisBaseEntity entity, boolean nameOrParentChanged, @Nonnull PolarisBaseEntity originalEntity) {
        entity = this.prepareToPersistEntityAfterChange(callCtx, ms, entity, nameOrParentChanged, originalEntity);
        ms.writeEntityInCurrentTxn(callCtx, entity, nameOrParentChanged, originalEntity);
        return entity;
    }

    private void dropEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisBaseEntity entity) {
        callCtx.getDiagServices().checkNotNull(entity, "unexpected_null_dpo");
        callCtx.getDiagServices().checkNotNull(entity.getName(), "unexpected_null_name");
        callCtx.getDiagServices().check(entity.getDropTimestamp() == 0L, "already_dropped");
        List<PolarisGrantRecord> grantsOnGrantee = entity.getType().isGrantee() ? ms.loadAllGrantRecordsOnGranteeInCurrentTxn(callCtx, entity.getCatalogId(), entity.getId()) : List.of();
        List<PolarisGrantRecord> grantsOnSecurable = ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entity.getCatalogId(), entity.getId());
        ms.deleteAllEntityGrantRecordsInCurrentTxn(callCtx, entity, grantsOnGrantee, grantsOnSecurable);
        HashSet entityIdsGrantChanged = new HashSet();
        grantsOnGrantee.forEach(gr -> entityIdsGrantChanged.add(new PolarisEntityId(gr.getSecurableCatalogId(), gr.getSecurableId())));
        grantsOnSecurable.forEach(gr -> entityIdsGrantChanged.add(new PolarisEntityId(gr.getGranteeCatalogId(), gr.getGranteeId())));
        List<PolarisBaseEntity> entities = ms.lookupEntitiesInCurrentTxn(callCtx, new ArrayList<PolarisEntityId>(entityIdsGrantChanged));
        for (PolarisBaseEntity entityGrantChanged : entities) {
            PolarisBaseEntity originalEntity = new PolarisBaseEntity(entityGrantChanged);
            entityGrantChanged.setGrantRecordsVersion(entityGrantChanged.getGrantRecordsVersion() + 1);
            ms.writeEntityInCurrentTxn(callCtx, entityGrantChanged, false, originalEntity);
        }
        if (entity.getType() == PolarisEntityType.POLICY || PolicyMappingUtil.isValidTargetEntityType(entity.getType(), entity.getSubType())) {
            try {
                List<PolarisPolicyMappingRecord> mappingOnPolicy = entity.getType() == PolarisEntityType.POLICY ? ms.loadAllTargetsOnPolicyInCurrentTxn(callCtx, entity.getCatalogId(), entity.getId(), PolicyEntity.of(entity).getPolicyTypeCode()) : List.of();
                List<PolarisPolicyMappingRecord> mappingOnTarget = entity.getType() == PolarisEntityType.POLICY ? List.of() : ms.loadAllPoliciesOnTargetInCurrentTxn(callCtx, entity.getCatalogId(), entity.getId());
                ms.deleteAllEntityPolicyMappingRecordsInCurrentTxn(callCtx, entity, mappingOnTarget, mappingOnPolicy);
            }
            catch (UnsupportedOperationException mappingOnPolicy) {
                // empty catch block
            }
        }
        ms.deleteEntityInCurrentTxn(callCtx, entity);
        if (entity.getType() == PolarisEntityType.PRINCIPAL) {
            Map<String, String> properties = this.deserializeProperties(callCtx, entity.getInternalProperties());
            String clientId = properties.get(PolarisEntityConstants.getClientIdPropertyName());
            ms.deletePrincipalSecretsInCurrentTxn(callCtx, clientId, entity.getId());
        }
    }

    @Nonnull
    private PolarisGrantRecord persistNewGrantRecord(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore securable, @Nonnull PolarisEntityCore grantee, @Nonnull PolarisPrivilege priv) {
        callCtx.getDiagServices().checkNotNull(securable, "unexpected_null_securable");
        callCtx.getDiagServices().checkNotNull(grantee, "unexpected_null_grantee");
        callCtx.getDiagServices().checkNotNull(priv, "unexpected_null_priv");
        callCtx.getDiagServices().check(grantee.getType().isGrantee(), "entity_must_be_grantee", "entity={}", grantee);
        PolarisGrantRecord grantRecord = new PolarisGrantRecord(securable.getCatalogId(), securable.getId(), grantee.getCatalogId(), grantee.getId(), priv.getCode());
        ms.writeToGrantRecordsInCurrentTxn(callCtx, grantRecord);
        PolarisBaseEntity granteeEntity = ms.lookupEntityInCurrentTxn(callCtx, grantee.getCatalogId(), grantee.getId(), grantee.getTypeCode());
        callCtx.getDiagServices().checkNotNull(granteeEntity, "grantee_not_found", "grantee={}", grantee);
        PolarisBaseEntity originalGranteeEntity = new PolarisBaseEntity(granteeEntity);
        granteeEntity.setGrantRecordsVersion(granteeEntity.getGrantRecordsVersion() + 1);
        ms.writeEntityInCurrentTxn(callCtx, granteeEntity, false, originalGranteeEntity);
        PolarisBaseEntity securableEntity = ms.lookupEntityInCurrentTxn(callCtx, securable.getCatalogId(), securable.getId(), securable.getTypeCode());
        callCtx.getDiagServices().checkNotNull(securableEntity, "securable_not_found", "securable={}", securable);
        PolarisBaseEntity originalSecurableEntity = new PolarisBaseEntity(securableEntity);
        securableEntity.setGrantRecordsVersion(securableEntity.getGrantRecordsVersion() + 1);
        ms.writeEntityInCurrentTxn(callCtx, securableEntity, false, originalSecurableEntity);
        return grantRecord;
    }

    private void revokeGrantRecord(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore securable, @Nonnull PolarisEntityCore grantee, @Nonnull PolarisGrantRecord grantRecord) {
        callCtx.getDiagServices().check(securable.getCatalogId() == grantRecord.getSecurableCatalogId() && securable.getId() == grantRecord.getSecurableId(), "securable_mismatch", "securable={} grantRec={}", securable, grantRecord);
        callCtx.getDiagServices().check(grantee.getCatalogId() == grantRecord.getGranteeCatalogId() && grantee.getId() == grantRecord.getGranteeId(), "grantee_mismatch", "grantee={} grantRec={}", grantee, grantRecord);
        callCtx.getDiagServices().check(grantee.getType().isGrantee(), "not_a_grantee", "grantee={}", grantee);
        ms.deleteFromGrantRecordsInCurrentTxn(callCtx, grantRecord);
        PolarisBaseEntity refreshGrantee = ms.lookupEntityInCurrentTxn(callCtx, grantee.getCatalogId(), grantee.getId(), grantee.getTypeCode());
        callCtx.getDiagServices().checkNotNull(refreshGrantee, "missing_grantee", "grantRecord={} grantee={}", grantRecord, grantee);
        PolarisBaseEntity originalRefreshGrantee = new PolarisBaseEntity(refreshGrantee);
        refreshGrantee.setGrantRecordsVersion(refreshGrantee.getGrantRecordsVersion() + 1);
        ms.writeEntityInCurrentTxn(callCtx, refreshGrantee, false, originalRefreshGrantee);
        PolarisBaseEntity refreshSecurable = ms.lookupEntityInCurrentTxn(callCtx, securable.getCatalogId(), securable.getId(), securable.getTypeCode());
        callCtx.getDiagServices().checkNotNull(refreshSecurable, "missing_securable", "grantRecord={} securable={}", grantRecord, securable);
        PolarisBaseEntity originalRefreshSecurable = new PolarisBaseEntity(refreshSecurable);
        refreshSecurable.setGrantRecordsVersion(refreshSecurable.getGrantRecordsVersion() + 1);
        ms.writeEntityInCurrentTxn(callCtx, refreshSecurable, false, originalRefreshSecurable);
    }

    @Nonnull
    private CreateCatalogResult createCatalog(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisBaseEntity catalog, @Nullable PolarisStorageIntegration<?> integration, @Nonnull List<PolarisEntityCore> principalRoles) {
        callCtx.getDiagServices().checkNotNull(catalog, "unexpected_null_catalog");
        PolarisBaseEntity refreshCatalog = ms.lookupEntityInCurrentTxn(callCtx, catalog.getCatalogId(), catalog.getId(), catalog.getTypeCode());
        if (refreshCatalog != null) {
            callCtx.getDiagServices().check(refreshCatalog.getTypeCode() == PolarisEntityType.CATALOG.getCode(), "not_a_catalog", "catalog={}", catalog);
            PolarisBaseEntity catalogAdminRole = ms.lookupEntityByNameInCurrentTxn(callCtx, refreshCatalog.getId(), refreshCatalog.getId(), PolarisEntityType.CATALOG_ROLE.getCode(), PolarisEntityConstants.getNameOfCatalogAdminRole());
            callCtx.getDiagServices().checkNotNull(catalogAdminRole, "catalog_admin_role_not_found", "catalog={}", refreshCatalog);
            return new CreateCatalogResult(refreshCatalog, catalogAdminRole);
        }
        if (ms.lookupEntityIdAndSubTypeByNameInCurrentTxn(callCtx, PolarisEntityConstants.getNullId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.CATALOG.getCode(), catalog.getName()) != null) {
            return new CreateCatalogResult(BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS, null);
        }
        ms.persistStorageIntegrationIfNeededInCurrentTxn(callCtx, catalog, integration);
        this.persistNewEntity(callCtx, ms, catalog);
        long adminRoleId = ms.generateNewIdInCurrentTxn(callCtx);
        PolarisBaseEntity adminRole = new PolarisBaseEntity(catalog.getId(), adminRoleId, PolarisEntityType.CATALOG_ROLE, PolarisEntitySubType.NULL_SUBTYPE, catalog.getId(), PolarisEntityConstants.getNameOfCatalogAdminRole());
        this.persistNewEntity(callCtx, ms, adminRole);
        this.persistNewGrantRecord(callCtx, ms, catalog, adminRole, PolarisPrivilege.CATALOG_MANAGE_ACCESS);
        this.persistNewGrantRecord(callCtx, ms, catalog, adminRole, PolarisPrivilege.CATALOG_MANAGE_METADATA);
        if (principalRoles.isEmpty()) {
            PolarisBaseEntity serviceAdminRole = ms.lookupEntityByNameInCurrentTxn(callCtx, PolarisEntityConstants.getNullId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.PRINCIPAL_ROLE.getCode(), PolarisEntityConstants.getNameOfPrincipalServiceAdminRole());
            callCtx.getDiagServices().checkNotNull(serviceAdminRole, "missing_service_admin_role");
            this.persistNewGrantRecord(callCtx, ms, adminRole, serviceAdminRole, PolarisPrivilege.CATALOG_ROLE_USAGE);
        } else {
            for (PolarisEntityCore principalRole : principalRoles) {
                callCtx.getDiagServices().checkNotNull(principalRole, "null principal role");
                callCtx.getDiagServices().check(principalRole.getTypeCode() == PolarisEntityType.PRINCIPAL_ROLE.getCode(), "not_principal_role", "type={}", new Object[]{principalRole.getType()});
                this.persistNewGrantRecord(callCtx, ms, adminRole, principalRole, PolarisPrivilege.CATALOG_ROLE_USAGE);
            }
        }
        return new CreateCatalogResult(catalog, adminRole);
    }

    private void bootstrapPolarisService(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms) {
        PolarisBaseEntity rootContainer = new PolarisBaseEntity(PolarisEntityConstants.getNullId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.ROOT, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootEntityId(), PolarisEntityConstants.getRootContainerName());
        this.persistNewEntity(callCtx, ms, rootContainer);
        long rootPrincipalId = ms.generateNewIdInCurrentTxn(callCtx);
        PolarisBaseEntity rootPrincipal = new PolarisBaseEntity(PolarisEntityConstants.getNullId(), rootPrincipalId, PolarisEntityType.PRINCIPAL, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootEntityId(), PolarisEntityConstants.getRootPrincipalName());
        this.createPrincipal(callCtx, ms, rootPrincipal);
        long serviceAdminPrincipalRoleId = ms.generateNewIdInCurrentTxn(callCtx);
        PolarisBaseEntity serviceAdminPrincipalRole = new PolarisBaseEntity(PolarisEntityConstants.getNullId(), serviceAdminPrincipalRoleId, PolarisEntityType.PRINCIPAL_ROLE, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootEntityId(), PolarisEntityConstants.getNameOfPrincipalServiceAdminRole());
        this.persistNewEntity(callCtx, ms, serviceAdminPrincipalRole);
        this.persistNewGrantRecord(callCtx, ms, serviceAdminPrincipalRole, rootPrincipal, PolarisPrivilege.PRINCIPAL_ROLE_USAGE);
        this.persistNewGrantRecord(callCtx, ms, rootContainer, serviceAdminPrincipalRole, PolarisPrivilege.SERVICE_MANAGE_ACCESS);
    }

    @Override
    @Nonnull
    public BaseResult bootstrapPolarisService(@Nonnull PolarisCallContext callCtx) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        ms.runActionInTransaction(callCtx, () -> this.bootstrapPolarisService(callCtx, ms));
        return new BaseResult(BaseResult.ReturnStatus.SUCCESS);
    }

    @Override
    @Nonnull
    public BaseResult purge(@Nonnull PolarisCallContext callCtx) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        LOGGER.warn("Deleting all metadata in the metastore...");
        ms.runActionInTransaction(callCtx, () -> ms.deleteAllInCurrentTxn(callCtx));
        LOGGER.warn("Finished deleting all metadata in the metastore");
        return new BaseResult(BaseResult.ReturnStatus.SUCCESS);
    }

    @Nonnull
    private EntityResult readEntityByName(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull String name) {
        PolarisEntityResolver resolver = new PolarisEntityResolver(callCtx, ms, catalogPath);
        if (resolver.isFailure()) {
            return new EntityResult(BaseResult.ReturnStatus.CATALOG_PATH_CANNOT_BE_RESOLVED, null);
        }
        PolarisBaseEntity entity = ms.lookupEntityByNameInCurrentTxn(callCtx, resolver.getCatalogIdOrNull(), resolver.getParentId(), entityType.getCode(), name);
        if (entity != null && entitySubType != PolarisEntitySubType.ANY_SUBTYPE && entity.getSubTypeCode() != entitySubType.getCode()) {
            entity = null;
        }
        return entity == null ? new EntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null) : new EntityResult(entity);
    }

    @Override
    @Nonnull
    public EntityResult readEntityByName(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull String name) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.readEntityByName(callCtx, ms, catalogPath, entityType, entitySubType, name));
    }

    @Nonnull
    private ListEntitiesResult listEntities(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull PageToken pageToken) {
        PolarisEntityResolver resolver = new PolarisEntityResolver(callCtx, ms, catalogPath);
        if (resolver.isFailure()) {
            return new ListEntitiesResult(BaseResult.ReturnStatus.CATALOG_PATH_CANNOT_BE_RESOLVED, null, Optional.empty());
        }
        Page<EntityNameLookupRecord> resultPage = ms.listEntitiesInCurrentTxn(callCtx, resolver.getCatalogIdOrNull(), resolver.getParentId(), entityType, pageToken);
        if (entitySubType != PolarisEntitySubType.ANY_SUBTYPE) {
            resultPage = pageToken.buildNextPage(resultPage.items.stream().filter(rec -> rec.getSubTypeCode() == entitySubType.getCode()).collect(Collectors.toList()));
        }
        return ListEntitiesResult.fromPage(resultPage);
    }

    @Override
    @Nonnull
    public ListEntitiesResult listEntities(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull PageToken pageToken) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.listEntities(callCtx, ms, catalogPath, entityType, entitySubType, pageToken));
    }

    @Nonnull
    private CreatePrincipalResult createPrincipal(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisBaseEntity principal) {
        callCtx.getDiagServices().checkNotNull(principal, "unexpected_null_principal");
        PolarisBaseEntity refreshPrincipal = ms.lookupEntityInCurrentTxn(callCtx, principal.getCatalogId(), principal.getId(), principal.getTypeCode());
        if (refreshPrincipal != null) {
            callCtx.getDiagServices().check(principal.getTypeCode() == PolarisEntityType.PRINCIPAL.getCode(), "not_a_principal", "principal={}", principal);
            Map<String, String> properties = this.deserializeProperties(callCtx, refreshPrincipal.getInternalProperties());
            String clientId = properties.get(PolarisEntityConstants.getClientIdPropertyName());
            callCtx.getDiagServices().checkNotNull(clientId, "null_client_id", "properties={}", refreshPrincipal.getInternalProperties());
            callCtx.getDiagServices().check(!clientId.isEmpty(), "empty_client_id", "properties={}", refreshPrincipal.getInternalProperties());
            PolarisPrincipalSecrets principalSecrets = ms.loadPrincipalSecretsInCurrentTxn(callCtx, clientId);
            callCtx.getDiagServices().checkNotNull(principalSecrets, "missing_principal_secrets", "clientId={} principal={}", clientId, refreshPrincipal);
            return new CreatePrincipalResult(refreshPrincipal, principalSecrets);
        }
        if (ms.lookupEntityIdAndSubTypeByNameInCurrentTxn(callCtx, PolarisEntityConstants.getNullId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.PRINCIPAL.getCode(), principal.getName()) != null) {
            return new CreatePrincipalResult(BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS, null);
        }
        PolarisPrincipalSecrets principalSecrets = ms.generateNewPrincipalSecretsInCurrentTxn(callCtx, principal.getName(), principal.getId());
        Map<String, String> internalProperties = this.getInternalPropertyMap(callCtx, principal);
        internalProperties.put(PolarisEntityConstants.getClientIdPropertyName(), principalSecrets.getPrincipalClientId());
        principal.setInternalProperties(this.serializeProperties(callCtx, internalProperties));
        this.persistNewEntity(callCtx, ms, principal);
        return new CreatePrincipalResult(principal, principalSecrets);
    }

    @Override
    @Nonnull
    public CreatePrincipalResult createPrincipal(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity principal) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.createPrincipal(callCtx, ms, principal));
    }

    @Nullable
    private PolarisPrincipalSecrets loadPrincipalSecrets(@Nonnull PolarisCallContext callCtx, TransactionalPersistence ms, @Nonnull String clientId) {
        return ms.loadPrincipalSecretsInCurrentTxn(callCtx, clientId);
    }

    @Override
    @Nonnull
    public PrincipalSecretsResult loadPrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        PolarisPrincipalSecrets secrets = ms.runInTransaction(callCtx, () -> this.loadPrincipalSecrets(callCtx, ms, clientId));
        return secrets == null ? new PrincipalSecretsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null) : new PrincipalSecretsResult(secrets);
    }

    @Nullable
    private PolarisPrincipalSecrets rotatePrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull String clientId, long principalId, boolean reset, @Nonnull String oldSecretHash) {
        EntityResult loadEntityResult = this.loadEntity(callCtx, ms, PolarisEntityConstants.getNullId(), principalId, PolarisEntityType.PRINCIPAL.getCode());
        if (loadEntityResult.getReturnStatus() != BaseResult.ReturnStatus.SUCCESS) {
            return null;
        }
        PolarisBaseEntity principal = loadEntityResult.getEntity();
        PolarisBaseEntity originalPrincipal = new PolarisBaseEntity(principal);
        Map<String, String> internalProps = PolarisObjectMapperUtil.deserializeProperties(callCtx, principal.getInternalProperties() == null ? "{}" : principal.getInternalProperties());
        boolean doReset = reset || internalProps.get("CREDENTIAL_ROTATION_REQUIRED") != null;
        PolarisPrincipalSecrets secrets = ms.rotatePrincipalSecretsInCurrentTxn(callCtx, clientId, principalId, doReset, oldSecretHash);
        if (reset && !internalProps.containsKey("CREDENTIAL_ROTATION_REQUIRED")) {
            internalProps.put("CREDENTIAL_ROTATION_REQUIRED", "true");
            principal.setInternalProperties(PolarisObjectMapperUtil.serializeProperties(callCtx, internalProps));
            principal.setEntityVersion(principal.getEntityVersion() + 1);
            ms.writeEntityInCurrentTxn(callCtx, principal, true, originalPrincipal);
        } else if (internalProps.containsKey("CREDENTIAL_ROTATION_REQUIRED")) {
            internalProps.remove("CREDENTIAL_ROTATION_REQUIRED");
            principal.setInternalProperties(PolarisObjectMapperUtil.serializeProperties(callCtx, internalProps));
            principal.setEntityVersion(principal.getEntityVersion() + 1);
            ms.writeEntityInCurrentTxn(callCtx, principal, true, originalPrincipal);
        }
        return secrets;
    }

    @Override
    @Nonnull
    public PrincipalSecretsResult rotatePrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId, boolean reset, @Nonnull String oldSecretHash) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        PolarisPrincipalSecrets secrets = ms.runInTransaction(callCtx, () -> this.rotatePrincipalSecrets(callCtx, ms, clientId, principalId, reset, oldSecretHash));
        return secrets == null ? new PrincipalSecretsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null) : new PrincipalSecretsResult(secrets);
    }

    @Override
    @Nonnull
    public CreateCatalogResult createCatalog(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity catalog, @Nonnull List<PolarisEntityCore> principalRoles) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        Map<String, String> internalProp = this.getInternalPropertyMap(callCtx, catalog);
        String integrationIdentifierOrId = internalProp.get(PolarisEntityConstants.getStorageIntegrationIdentifierPropertyName());
        String storageConfigInfoStr = internalProp.get(PolarisEntityConstants.getStorageConfigInfoPropertyName());
        PolarisStorageIntegration integration = storageConfigInfoStr != null && integrationIdentifierOrId == null ? ms.createStorageIntegrationInCurrentTxn(callCtx, catalog.getCatalogId(), catalog.getId(), PolarisStorageConfigurationInfo.deserialize(callCtx.getDiagServices(), storageConfigInfoStr)) : null;
        return ms.runInTransaction(callCtx, () -> this.createCatalog(callCtx, ms, catalog, integration, principalRoles));
    }

    @Nonnull
    private EntityResult createEntityIfNotExists(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entity) {
        callCtx.getDiagServices().checkNotNull(entity, "unexpected_null_entity");
        callCtx.getDiagServices().checkNotNull(entity.getName(), "unexpected_null_entity_name");
        PolarisBaseEntity entityFound = ms.lookupEntityInCurrentTxn(callCtx, entity.getCatalogId(), entity.getId(), entity.getTypeCode());
        if (entityFound != null) {
            return new EntityResult(entityFound);
        }
        PolarisEntityResolver resolver = new PolarisEntityResolver(callCtx, ms, catalogPath);
        if (resolver.isFailure()) {
            return new EntityResult(BaseResult.ReturnStatus.CATALOG_PATH_CANNOT_BE_RESOLVED, null);
        }
        EntityNameLookupRecord entityActiveRecord = ms.lookupEntityIdAndSubTypeByNameInCurrentTxn(callCtx, entity.getCatalogId(), entity.getParentId(), entity.getType().getCode(), entity.getName());
        if (entityActiveRecord != null) {
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS, entityActiveRecord.getSubTypeCode());
        }
        this.persistNewEntity(callCtx, ms, entity);
        return new EntityResult(entity);
    }

    @Override
    @Nonnull
    public EntityResult createEntityIfNotExists(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entity) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.createEntityIfNotExists(callCtx, ms, catalogPath, entity));
    }

    @Override
    @Nonnull
    public EntitiesResult createEntitiesIfNotExist(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull List<? extends PolarisBaseEntity> entities) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> {
            ArrayList<PolarisBaseEntity> createdEntities = new ArrayList<PolarisBaseEntity>(entities.size());
            for (PolarisBaseEntity entity : entities) {
                EntityResult entityCreateResult = this.createEntityIfNotExists(callCtx, ms, catalogPath, entity);
                if (entityCreateResult.getReturnStatus() != BaseResult.ReturnStatus.SUCCESS) {
                    ms.rollback();
                    return new EntitiesResult(entityCreateResult.getReturnStatus(), entityCreateResult.getExtraInformation());
                }
                createdEntities.add(entityCreateResult.getEntity());
            }
            return new EntitiesResult(createdEntities);
        });
    }

    @Nonnull
    private EntityResult updateEntityPropertiesIfNotChanged(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entity) {
        callCtx.getDiagServices().checkNotNull(entity, "unexpected_null_entity");
        PolarisEntityResolver resolver = new PolarisEntityResolver(callCtx, ms, catalogPath, entity);
        if (resolver.isFailure()) {
            return new EntityResult(BaseResult.ReturnStatus.CATALOG_PATH_CANNOT_BE_RESOLVED, null);
        }
        PolarisBaseEntity entityRefreshed = ms.lookupEntityInCurrentTxn(callCtx, entity.getCatalogId(), entity.getId(), entity.getTypeCode());
        callCtx.getDiagServices().checkNotNull(entityRefreshed, "unexpected_entity_not_found", "entity={}", entity);
        if (entityRefreshed.getEntityVersion() != entity.getEntityVersion()) {
            return new EntityResult(BaseResult.ReturnStatus.TARGET_ENTITY_CONCURRENTLY_MODIFIED, null);
        }
        PolarisBaseEntity originalEntity = new PolarisBaseEntity(entityRefreshed);
        entityRefreshed.setInternalProperties(entity.getInternalProperties());
        entityRefreshed.setProperties(entity.getProperties());
        PolarisBaseEntity persistedEntity = this.persistEntityAfterChange(callCtx, ms, entityRefreshed, false, originalEntity);
        return new EntityResult(persistedEntity);
    }

    @Override
    @Nonnull
    public EntityResult updateEntityPropertiesIfNotChanged(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entity) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.updateEntityPropertiesIfNotChanged(callCtx, ms, catalogPath, entity));
    }

    @Nonnull
    private EntitiesResult updateEntitiesPropertiesIfNotChanged(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull List<EntityWithPath> entities) {
        callCtx.getDiagServices().checkNotNull(entities, "unexpected_null_entities");
        ArrayList<PolarisBaseEntity> updatedEntities = new ArrayList<PolarisBaseEntity>(entities.size());
        for (EntityWithPath entityWithPath : entities) {
            EntityResult updatedEntityResult = this.updateEntityPropertiesIfNotChanged(callCtx, ms, entityWithPath.getCatalogPath(), entityWithPath.getEntity());
            if (updatedEntityResult.getReturnStatus() != BaseResult.ReturnStatus.SUCCESS) {
                ms.rollback();
                return new EntitiesResult(updatedEntityResult.getReturnStatus(), updatedEntityResult.getExtraInformation());
            }
            updatedEntities.add(updatedEntityResult.getEntity());
        }
        return new EntitiesResult(updatedEntities);
    }

    @Override
    @Nonnull
    public EntitiesResult updateEntitiesPropertiesIfNotChanged(@Nonnull PolarisCallContext callCtx, @Nonnull List<EntityWithPath> entities) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.updateEntitiesPropertiesIfNotChanged(callCtx, ms, entities));
    }

    @Nonnull
    private EntityResult renameEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore entityToRename, @Nullable List<PolarisEntityCore> newCatalogPath, @Nonnull PolarisBaseEntity renamedEntity) {
        PolarisEntityResolver resolver;
        callCtx.getDiagServices().checkNotNull(entityToRename, "unexpected_null_entityToRename");
        callCtx.getDiagServices().checkNotNull(renamedEntity, "unexpected_null_renamedEntity");
        callCtx.getDiagServices().check(newCatalogPath == null || catalogPath != null, "newCatalogPath_specified_without_catalogPath");
        if (newCatalogPath == null) {
            newCatalogPath = catalogPath;
        }
        if ((resolver = new PolarisEntityResolver(callCtx, ms, catalogPath, entityToRename)).isFailure()) {
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        PolarisBaseEntity refreshEntityToRename = ms.lookupEntityInCurrentTxn(callCtx, entityToRename.getCatalogId(), entityToRename.getId(), entityToRename.getTypeCode());
        if (refreshEntityToRename == null) {
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (refreshEntityToRename.getEntityVersion() != renamedEntity.getEntityVersion()) {
            return new EntityResult(BaseResult.ReturnStatus.TARGET_ENTITY_CONCURRENTLY_MODIFIED, null);
        }
        if (refreshEntityToRename.cannotBeDroppedOrRenamed()) {
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RENAMED, null);
        }
        if (newCatalogPath != null && (resolver = new PolarisEntityResolver(callCtx, ms, newCatalogPath)).isFailure()) {
            return new EntityResult(BaseResult.ReturnStatus.CATALOG_PATH_CANNOT_BE_RESOLVED, null);
        }
        EntityNameLookupRecord entityActiveRecord = ms.lookupEntityIdAndSubTypeByNameInCurrentTxn(callCtx, resolver.getCatalogIdOrNull(), resolver.getParentId(), refreshEntityToRename.getTypeCode(), renamedEntity.getName());
        if (entityActiveRecord != null) {
            return new EntityResult(BaseResult.ReturnStatus.ENTITY_ALREADY_EXISTS, entityActiveRecord.getSubTypeCode());
        }
        PolarisBaseEntity originalEntity = new PolarisBaseEntity(refreshEntityToRename);
        refreshEntityToRename.setName(renamedEntity.getName());
        refreshEntityToRename.setProperties(renamedEntity.getProperties());
        refreshEntityToRename.setInternalProperties(renamedEntity.getInternalProperties());
        if (newCatalogPath != null) {
            refreshEntityToRename.setParentId(resolver.getParentId());
        }
        PolarisBaseEntity renamedEntityToReturn = this.persistEntityAfterChange(callCtx, ms, refreshEntityToRename, true, originalEntity);
        return new EntityResult(renamedEntityToReturn);
    }

    @Override
    @Nonnull
    public EntityResult renameEntity(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entityToRename, @Nullable List<PolarisEntityCore> newCatalogPath, @Nonnull PolarisEntity renamedEntity) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.renameEntity(callCtx, ms, catalogPath, entityToRename, newCatalogPath, renamedEntity));
    }

    @Nonnull
    private DropEntityResult dropEntityIfExists(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entityToDrop, @Nullable Map<String, String> cleanupProperties, boolean cleanup) {
        callCtx.getDiagServices().checkNotNull(entityToDrop, "unexpected_null_entity");
        PolarisEntityResolver resolver = new PolarisEntityResolver(callCtx, ms, catalogPath, entityToDrop);
        if (resolver.isFailure()) {
            return new DropEntityResult(BaseResult.ReturnStatus.CATALOG_PATH_CANNOT_BE_RESOLVED, null);
        }
        PolarisBaseEntity refreshEntityToDrop = ms.lookupEntityInCurrentTxn(callCtx, entityToDrop.getCatalogId(), entityToDrop.getId(), entityToDrop.getTypeCode());
        if (refreshEntityToDrop == null) {
            return new DropEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (refreshEntityToDrop.cannotBeDroppedOrRenamed()) {
            return new DropEntityResult(BaseResult.ReturnStatus.ENTITY_UNDROPPABLE, null);
        }
        if (refreshEntityToDrop.getType() == PolarisEntityType.CATALOG) {
            long catalogId = refreshEntityToDrop.getId();
            if (ms.hasChildrenInCurrentTxn(callCtx, PolarisEntityType.NAMESPACE, catalogId, catalogId)) {
                return new DropEntityResult(BaseResult.ReturnStatus.NAMESPACE_NOT_EMPTY, null);
            }
            List catalogRoles = ms.listEntitiesInCurrentTxn((PolarisCallContext)callCtx, (long)catalogId, (long)catalogId, (PolarisEntityType)PolarisEntityType.CATALOG_ROLE, (Predicate<PolarisBaseEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$dropEntityIfExists$16(org.apache.polaris.core.entity.PolarisBaseEntity ), (Lorg/apache/polaris/core/entity/PolarisBaseEntity;)Z)(), Function.identity(), (PageToken)PageToken.fromLimit((Integer)Integer.valueOf((int)2))).items;
            if (catalogRoles.size() > 1) {
                return new DropEntityResult(BaseResult.ReturnStatus.CATALOG_NOT_EMPTY, null);
            }
            if (!catalogRoles.isEmpty()) {
                this.dropEntity(callCtx, ms, (PolarisBaseEntity)catalogRoles.get(0));
            }
        } else if (refreshEntityToDrop.getType() == PolarisEntityType.NAMESPACE) {
            if (ms.hasChildrenInCurrentTxn(callCtx, null, refreshEntityToDrop.getCatalogId(), refreshEntityToDrop.getId())) {
                return new DropEntityResult(BaseResult.ReturnStatus.NAMESPACE_NOT_EMPTY, null);
            }
        } else if (refreshEntityToDrop.getType() == PolarisEntityType.POLICY && !cleanup) {
            try {
                List<PolarisPolicyMappingRecord> records = ms.loadAllTargetsOnPolicyInCurrentTxn(callCtx, refreshEntityToDrop.getCatalogId(), refreshEntityToDrop.getId(), PolicyEntity.of(refreshEntityToDrop).getPolicyTypeCode());
                if (!records.isEmpty()) {
                    return new DropEntityResult(BaseResult.ReturnStatus.POLICY_HAS_MAPPINGS, null);
                }
            }
            catch (UnsupportedOperationException records) {
                // empty catch block
            }
        }
        this.dropEntity(callCtx, ms, refreshEntityToDrop);
        if (cleanup && refreshEntityToDrop.getType() != PolarisEntityType.POLICY) {
            PolarisEntity taskEntity = ((PolarisEntity.Builder)((PolarisEntity.Builder)((PolarisEntity.Builder)((PolarisEntity.Builder)((PolarisEntity.Builder)((PolarisEntity.Builder)new PolarisEntity.Builder().setId(ms.generateNewIdInCurrentTxn(callCtx))).setCatalogId(0L)).setName("entityCleanup_" + entityToDrop.getId())).setType(PolarisEntityType.TASK)).setSubType(PolarisEntitySubType.NULL_SUBTYPE)).setCreateTimestamp(callCtx.getClock().millis())).build();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("taskType", String.valueOf(AsyncTaskType.ENTITY_CLEANUP_SCHEDULER.typeCode()));
            properties.put("data", PolarisObjectMapperUtil.serialize(callCtx, refreshEntityToDrop));
            taskEntity.setProperties(PolarisObjectMapperUtil.serializeProperties(callCtx, properties));
            if (cleanupProperties != null) {
                taskEntity.setInternalProperties(PolarisObjectMapperUtil.serializeProperties(callCtx, cleanupProperties));
            }
            this.createEntityIfNotExists(callCtx, ms, null, taskEntity);
            return new DropEntityResult(taskEntity.getId());
        }
        return new DropEntityResult();
    }

    @Override
    @Nonnull
    public DropEntityResult dropEntityIfExists(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entityToDrop, @Nullable Map<String, String> cleanupProperties, boolean cleanup) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.dropEntityIfExists(callCtx, ms, catalogPath, entityToDrop, cleanupProperties, cleanup));
    }

    @Nonnull
    private PolarisEntityResolver resolveRoleToGranteeUsageGrant(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        callCtx.getDiagServices().checkNotNull(grantee, "unexpected_null_grantee");
        callCtx.getDiagServices().check(grantee.getType().isGrantee(), "not_a_grantee", "grantee={}", grantee);
        callCtx.getDiagServices().checkNotNull(role, "unexpected_null_role");
        boolean isCatalogRole = role.getTypeCode() == PolarisEntityType.CATALOG_ROLE.getCode();
        boolean isPrincipalRole = role.getTypeCode() == PolarisEntityType.PRINCIPAL_ROLE.getCode();
        callCtx.getDiagServices().check(isCatalogRole || isPrincipalRole, "not_a_role");
        callCtx.getDiagServices().check(catalog == null && isPrincipalRole || catalog != null && isCatalogRole, "catalog_mismatch", "catalog={} role={}", catalog, role);
        ArrayList<PolarisEntityCore> otherTopLevelEntities = new ArrayList<PolarisEntityCore>(2);
        otherTopLevelEntities.add(role);
        otherTopLevelEntities.add(grantee);
        return new PolarisEntityResolver(callCtx, ms, catalog != null ? List.of(catalog) : null, null, otherTopLevelEntities);
    }

    private PolarisEntityResolver resolveSecurableToRoleGrant(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable) {
        callCtx.getDiagServices().checkNotNull(grantee, "unexpected_null_grantee");
        callCtx.getDiagServices().check(grantee.getType().isGrantee(), "not_grantee_type", "grantee={}", grantee);
        callCtx.getDiagServices().checkNotNull(securable, "unexpected_null_securable");
        if (securable.getCatalogId() > 0L) {
            callCtx.getDiagServices().checkNotNull(catalogPath, "unexpected_null_catalogPath");
        }
        return new PolarisEntityResolver(callCtx, ms, catalogPath, securable, List.of(grantee));
    }

    @Nonnull
    private PrivilegeResult grantUsageOnRoleToGrantee(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        PolarisEntityResolver resolver = this.resolveRoleToGranteeUsageGrant(callCtx, ms, catalog, role, grantee);
        if (resolver.isFailure()) {
            return new PrivilegeResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        PolarisPrivilege usagePriv = grantee.getType() == PolarisEntityType.PRINCIPAL_ROLE ? PolarisPrivilege.CATALOG_ROLE_USAGE : PolarisPrivilege.PRINCIPAL_ROLE_USAGE;
        callCtx.getDiagServices().check(grantee.getType().isGrantee(), "not_a_grantee", "grantee={}", grantee);
        PolarisGrantRecord grantRecord = this.persistNewGrantRecord(callCtx, ms, role, grantee, usagePriv);
        return new PrivilegeResult(grantRecord);
    }

    @Override
    @Nonnull
    public PrivilegeResult grantUsageOnRoleToGrantee(@Nonnull PolarisCallContext callCtx, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.grantUsageOnRoleToGrantee(callCtx, ms, catalog, role, grantee));
    }

    @Nonnull
    private PrivilegeResult revokeUsageOnRoleFromGrantee(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        PolarisEntityResolver resolver = this.resolveRoleToGranteeUsageGrant(callCtx, ms, catalog, role, grantee);
        if (resolver.isFailure()) {
            return new PrivilegeResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        PolarisPrivilege usagePriv = grantee.getType() == PolarisEntityType.PRINCIPAL_ROLE ? PolarisPrivilege.CATALOG_ROLE_USAGE : PolarisPrivilege.PRINCIPAL_ROLE_USAGE;
        PolarisGrantRecord grantRecord = ms.lookupGrantRecordInCurrentTxn(callCtx, role.getCatalogId(), role.getId(), grantee.getCatalogId(), grantee.getId(), usagePriv.getCode());
        if (grantRecord == null) {
            return new PrivilegeResult(BaseResult.ReturnStatus.GRANT_NOT_FOUND, null);
        }
        this.revokeGrantRecord(callCtx, ms, role, grantee, grantRecord);
        return new PrivilegeResult(grantRecord);
    }

    @Override
    @Nonnull
    public PrivilegeResult revokeUsageOnRoleFromGrantee(@Nonnull PolarisCallContext callCtx, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.revokeUsageOnRoleFromGrantee(callCtx, ms, catalog, role, grantee));
    }

    @Nonnull
    private PrivilegeResult grantPrivilegeOnSecurableToRole(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable, @Nonnull PolarisPrivilege priv) {
        PolarisEntityResolver resolver = this.resolveSecurableToRoleGrant(callCtx, ms, grantee, catalogPath, securable);
        if (resolver.isFailure()) {
            return new PrivilegeResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        PolarisGrantRecord grantRecord = this.persistNewGrantRecord(callCtx, ms, securable, grantee, priv);
        return new PrivilegeResult(grantRecord);
    }

    @Override
    @Nonnull
    public PrivilegeResult grantPrivilegeOnSecurableToRole(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable, @Nonnull PolarisPrivilege privilege) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.grantPrivilegeOnSecurableToRole(callCtx, ms, grantee, catalogPath, securable, privilege));
    }

    @Nonnull
    private PrivilegeResult revokePrivilegeOnSecurableFromRole(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable, @Nonnull PolarisPrivilege priv) {
        PolarisEntityResolver resolver = this.resolveSecurableToRoleGrant(callCtx, ms, grantee, catalogPath, securable);
        if (resolver.isFailure()) {
            return new PrivilegeResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        PolarisGrantRecord grantRecord = ms.lookupGrantRecordInCurrentTxn(callCtx, securable.getCatalogId(), securable.getId(), grantee.getCatalogId(), grantee.getId(), priv.getCode());
        if (grantRecord == null) {
            return new PrivilegeResult(BaseResult.ReturnStatus.GRANT_NOT_FOUND, null);
        }
        this.revokeGrantRecord(callCtx, ms, securable, grantee, grantRecord);
        return new PrivilegeResult(grantRecord);
    }

    @Override
    @Nonnull
    public PrivilegeResult revokePrivilegeOnSecurableFromRole(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable, @Nonnull PolarisPrivilege privilege) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.revokePrivilegeOnSecurableFromRole(callCtx, ms, grantee, catalogPath, securable, privilege));
    }

    @Nonnull
    private LoadGrantsResult loadGrantsOnSecurable(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, long securableCatalogId, long securableId) {
        int grantsVersion = ms.lookupEntityGrantRecordsVersionInCurrentTxn(callCtx, securableCatalogId, securableId);
        if (grantsVersion == 0) {
            return new LoadGrantsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        List<PolarisGrantRecord> returnGrantRecords = ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, securableCatalogId, securableId);
        List<PolarisEntityId> entityIds = returnGrantRecords.stream().map(grantRecord -> new PolarisEntityId(grantRecord.getGranteeCatalogId(), grantRecord.getGranteeId())).distinct().collect(Collectors.toList());
        List<PolarisBaseEntity> entities = ms.lookupEntitiesInCurrentTxn(callCtx, entityIds);
        return new LoadGrantsResult(grantsVersion, returnGrantRecords, entities.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public LoadGrantsResult loadGrantsOnSecurable(@Nonnull PolarisCallContext callCtx, PolarisEntityCore securable) {
        return this.loadGrantsOnSecurable(callCtx, securable.getCatalogId(), securable.getId());
    }

    @Nonnull
    public LoadGrantsResult loadGrantsOnSecurable(@Nonnull PolarisCallContext callCtx, long securableCatalogId, long securableId) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.loadGrantsOnSecurable(callCtx, ms, securableCatalogId, securableId));
    }

    @Nonnull
    public LoadGrantsResult loadGrantsToGrantee(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, long granteeCatalogId, long granteeId) {
        int grantsVersion = ms.lookupEntityGrantRecordsVersionInCurrentTxn(callCtx, granteeCatalogId, granteeId);
        if (grantsVersion == 0) {
            return new LoadGrantsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        List<PolarisGrantRecord> returnGrantRecords = ms.loadAllGrantRecordsOnGranteeInCurrentTxn(callCtx, granteeCatalogId, granteeId);
        List<PolarisEntityId> entityIds = returnGrantRecords.stream().map(grantRecord -> new PolarisEntityId(grantRecord.getSecurableCatalogId(), grantRecord.getSecurableId())).distinct().collect(Collectors.toList());
        List<PolarisBaseEntity> entities = ms.lookupEntitiesInCurrentTxn(callCtx, entityIds);
        return new LoadGrantsResult(grantsVersion, returnGrantRecords, entities.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public LoadGrantsResult loadGrantsToGrantee(@Nonnull PolarisCallContext callCtx, PolarisEntityCore grantee) {
        return this.loadGrantsToGrantee(callCtx, grantee.getCatalogId(), grantee.getId());
    }

    @Nonnull
    public LoadGrantsResult loadGrantsToGrantee(@Nonnull PolarisCallContext callCtx, long granteeCatalogId, long granteeId) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.loadGrantsToGrantee(callCtx, ms, granteeCatalogId, granteeId));
    }

    @Nonnull
    private ChangeTrackingResult loadEntitiesChangeTracking(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull List<PolarisEntityId> entityIds) {
        List<PolarisChangeTrackingVersions> changeTracking = ms.lookupEntityVersionsInCurrentTxn(callCtx, entityIds);
        return new ChangeTrackingResult(changeTracking);
    }

    @Override
    @Nonnull
    public ChangeTrackingResult loadEntitiesChangeTracking(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntityId> entityIds) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.loadEntitiesChangeTracking(callCtx, ms, entityIds));
    }

    @Nonnull
    private EntityResult loadEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, long entityCatalogId, long entityId, int entityTypeCode) {
        PolarisBaseEntity entity = ms.lookupEntityInCurrentTxn(callCtx, entityCatalogId, entityId, entityTypeCode);
        return entity != null ? new EntityResult(entity) : new EntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
    }

    @Override
    @Nonnull
    public EntityResult loadEntity(@Nonnull PolarisCallContext callCtx, long entityCatalogId, long entityId, @Nonnull PolarisEntityType entityType) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.loadEntity(callCtx, ms, entityCatalogId, entityId, entityType.getCode()));
    }

    @Nonnull
    private EntitiesResult loadTasks(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, String executorId, PageToken pageToken) {
        Page availableTasks = ms.listEntitiesInCurrentTxn(callCtx, PolarisEntityConstants.getRootEntityId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.TASK, entity -> {
            PolarisObjectMapperUtil.TaskExecutionState taskState = PolarisObjectMapperUtil.parseTaskState(entity);
            long taskAgeTimeout = callCtx.getConfigurationStore().getConfiguration(callCtx.getRealmContext(), "POLARIS_TASK_TIMEOUT_MILLIS", 300000L);
            return taskState == null || taskState.executor == null || callCtx.getClock().millis() - taskState.lastAttemptStartTime > taskAgeTimeout;
        }, Function.identity(), pageToken);
        ArrayList loadedTasks = new ArrayList();
        availableTasks.items.forEach(task -> {
            PolarisBaseEntity updatedTask = new PolarisBaseEntity((PolarisBaseEntity)task);
            Map<String, String> properties = PolarisObjectMapperUtil.deserializeProperties(callCtx, task.getProperties());
            properties.put("lastAttemptExecutorId", executorId);
            properties.put("lastAttemptStartTime", String.valueOf(callCtx.getClock().millis()));
            properties.put("attemptCount", String.valueOf(Integer.parseInt(properties.getOrDefault("attemptCount", "0")) + 1));
            updatedTask.setProperties(PolarisObjectMapperUtil.serializeProperties(callCtx, properties));
            EntityResult result = this.updateEntityPropertiesIfNotChanged(callCtx, ms, null, updatedTask);
            if (result.getReturnStatus() != BaseResult.ReturnStatus.SUCCESS) {
                ms.rollback();
                throw new RetryOnConcurrencyException("Failed to lease available task with status %s, info: %s", new Object[]{result.getReturnStatus(), result.getExtraInformation()});
            }
            loadedTasks.add(result.getEntity());
        });
        return EntitiesResult.fromPage(Page.fromItems(loadedTasks));
    }

    @Override
    @Nonnull
    public EntitiesResult loadTasks(@Nonnull PolarisCallContext callCtx, String executorId, PageToken pageToken) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.loadTasks(callCtx, ms, executorId, pageToken));
    }

    @Override
    @Nonnull
    public ScopedCredentialsResult getSubscopedCredsForEntity(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId, PolarisEntityType entityType, boolean allowListOperation, @Nonnull Set<String> allowedReadLocations, @Nonnull Set<String> allowedWriteLocations) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        callCtx.getDiagServices().check(!allowedReadLocations.isEmpty() || !allowedWriteLocations.isEmpty(), "allowed_locations_to_subscope_is_required");
        EntityResult reloadedEntity = this.loadEntity(callCtx, catalogId, entityId, entityType);
        if (reloadedEntity.getReturnStatus() != BaseResult.ReturnStatus.SUCCESS) {
            return new ScopedCredentialsResult(reloadedEntity.getReturnStatus(), reloadedEntity.getExtraInformation());
        }
        PolarisStorageIntegration<PolarisStorageConfigurationInfo> storageIntegration = ms.loadPolarisStorageIntegrationInCurrentTxn(callCtx, reloadedEntity.getEntity());
        callCtx.getDiagServices().checkNotNull(storageIntegration, "storage_integration_not_exists", "catalogId={}, entityId={}", catalogId, entityId);
        PolarisStorageConfigurationInfo storageConfigurationInfo = BaseMetaStoreManager.extractStorageConfiguration(callCtx, reloadedEntity.getEntity());
        try {
            EnumMap<StorageAccessProperty, String> creds = storageIntegration.getSubscopedCreds(callCtx.getDiagServices(), storageConfigurationInfo, allowListOperation, allowedReadLocations, allowedWriteLocations);
            return new ScopedCredentialsResult(creds);
        }
        catch (Exception ex) {
            return new ScopedCredentialsResult(BaseResult.ReturnStatus.SUBSCOPE_CREDS_ERROR, ex.getMessage());
        }
    }

    public Map<String, String> getInternalPropertyMap(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity) {
        String internalPropStr = entity.getInternalProperties();
        HashMap<String, String> res = new HashMap<String, String>();
        if (internalPropStr == null) {
            return res;
        }
        return this.deserializeProperties(callCtx, internalPropStr);
    }

    @Nonnull
    private ResolvedEntityResult loadResolvedEntityById(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, long entityCatalogId, long entityId, int typeCode) {
        List<PolarisGrantRecord> grantRecords;
        PolarisBaseEntity entity = ms.lookupEntityInCurrentTxn(callCtx, entityCatalogId, entityId, typeCode);
        if (entity == null) {
            return new ResolvedEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (entity.getType().isGrantee()) {
            grantRecords = new ArrayList<PolarisGrantRecord>(ms.loadAllGrantRecordsOnGranteeInCurrentTxn(callCtx, entityCatalogId, entityId));
            grantRecords.addAll(ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entityCatalogId, entityId));
        } else {
            grantRecords = ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entityCatalogId, entityId);
        }
        return new ResolvedEntityResult(entity, entity.getGrantRecordsVersion(), grantRecords);
    }

    @Override
    @Nonnull
    public ResolvedEntityResult loadResolvedEntityById(@Nonnull PolarisCallContext callCtx, long entityCatalogId, long entityId, PolarisEntityType entityType) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.loadResolvedEntityById(callCtx, ms, entityCatalogId, entityId, entityType.getCode()));
    }

    @Nonnull
    private ResolvedEntityResult loadResolvedEntityByName(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, long entityCatalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull String entityName) {
        List<PolarisGrantRecord> grantRecords;
        PolarisBaseEntity entity = ms.lookupEntityByNameInCurrentTxn(callCtx, entityCatalogId, parentId, entityType.getCode(), entityName);
        if (entity == null) {
            return new ResolvedEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (entity.getType().isGrantee()) {
            grantRecords = new ArrayList<PolarisGrantRecord>(ms.loadAllGrantRecordsOnGranteeInCurrentTxn(callCtx, entityCatalogId, entity.getId()));
            grantRecords.addAll(ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entityCatalogId, entity.getId()));
        } else {
            grantRecords = ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entityCatalogId, entity.getId());
        }
        return new ResolvedEntityResult(entity, entity.getGrantRecordsVersion(), grantRecords);
    }

    @Override
    @Nonnull
    public ResolvedEntityResult loadResolvedEntityByName(@Nonnull PolarisCallContext callCtx, long entityCatalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull String entityName) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        ResolvedEntityResult result = ms.runInReadTransaction(callCtx, () -> this.loadResolvedEntityByName(callCtx, ms, entityCatalogId, parentId, entityType, entityName));
        if (PolarisEntityConstants.getRootContainerName().equals(entityName) && entityType == PolarisEntityType.ROOT && !result.isSuccess()) {
            ms.runActionInTransaction(callCtx, () -> {
                PolarisBaseEntity serviceAdminRole;
                PolarisBaseEntity rootContainer = new PolarisBaseEntity(PolarisEntityConstants.getNullId(), PolarisEntityConstants.getRootEntityId(), PolarisEntityType.ROOT, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootEntityId(), PolarisEntityConstants.getRootContainerName());
                EntityResult backfillResult = this.createEntityIfNotExists(callCtx, ms, null, rootContainer);
                if (backfillResult.isSuccess() && (serviceAdminRole = ms.lookupEntityByNameInCurrentTxn(callCtx, 0L, 0L, PolarisEntityType.PRINCIPAL_ROLE.getCode(), PolarisEntityConstants.getNameOfPrincipalServiceAdminRole())) != null) {
                    this.persistNewGrantRecord(callCtx, ms, rootContainer, serviceAdminRole, PolarisPrivilege.SERVICE_MANAGE_ACCESS);
                }
            });
            result = ms.runInReadTransaction(callCtx, () -> this.loadResolvedEntityByName(callCtx, ms, entityCatalogId, parentId, entityType, entityName));
        }
        return result;
    }

    @Nonnull
    private ResolvedEntityResult refreshResolvedEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, int entityVersion, int entityGrantRecordsVersion, @Nonnull PolarisEntityType entityType, long entityCatalogId, long entityId) {
        List<PolarisGrantRecord> grantRecords;
        PolarisBaseEntity entity;
        PolarisChangeTrackingVersions entityVersions = ms.lookupEntityVersionsInCurrentTxn(callCtx, List.of(new PolarisEntityId(entityCatalogId, entityId))).get(0);
        if (entityVersions == null) {
            return new ResolvedEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        if (entityVersion != entityVersions.getEntityVersion()) {
            entity = ms.lookupEntityInCurrentTxn(callCtx, entityCatalogId, entityId, entityType.getCode());
            if (entity == null) {
                return new ResolvedEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
            }
        } else {
            entity = null;
        }
        if (entityVersions.getGrantRecordsVersion() != entityGrantRecordsVersion) {
            if (entityType.isGrantee()) {
                grantRecords = new ArrayList<PolarisGrantRecord>(ms.loadAllGrantRecordsOnGranteeInCurrentTxn(callCtx, entityCatalogId, entityId));
                grantRecords.addAll(ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entityCatalogId, entityId));
            } else {
                grantRecords = ms.loadAllGrantRecordsOnSecurableInCurrentTxn(callCtx, entityCatalogId, entityId);
            }
        } else {
            grantRecords = null;
        }
        return new ResolvedEntityResult(entity, entityVersions.getGrantRecordsVersion(), grantRecords);
    }

    @Override
    @Nonnull
    public ResolvedEntityResult refreshResolvedEntity(@Nonnull PolarisCallContext callCtx, int entityVersion, int entityGrantRecordsVersion, @Nonnull PolarisEntityType entityType, long entityCatalogId, long entityId) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.refreshResolvedEntity(callCtx, ms, entityVersion, entityGrantRecordsVersion, entityType, entityCatalogId, entityId));
    }

    @Override
    @Nonnull
    public PolicyAttachmentResult attachPolicyToEntity(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntityCore> targetCatalogPath, @Nonnull PolarisEntityCore target, @Nonnull List<PolarisEntityCore> policyCatalogPath, @Nonnull PolicyEntity policy, Map<String, String> parameters) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.doAttachPolicyToEntity(callCtx, ms, targetCatalogPath, target, policyCatalogPath, policy, parameters));
    }

    @Nonnull
    private PolicyAttachmentResult doAttachPolicyToEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull List<PolarisEntityCore> targetCatalogPath, @Nonnull PolarisEntityCore target, @Nonnull List<PolarisEntityCore> policyCatalogPath, @Nonnull PolicyEntity policy, Map<String, String> parameters) {
        PolarisEntityResolver targetResolver = new PolarisEntityResolver(callCtx, ms, targetCatalogPath, target);
        PolarisEntityResolver policyResolver = new PolarisEntityResolver(callCtx, ms, policyCatalogPath, policy);
        if (targetResolver.isFailure() || policyResolver.isFailure()) {
            return new PolicyAttachmentResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        return this.persistNewPolicyMappingRecord(callCtx, ms, target, policy, parameters);
    }

    @Override
    @Nonnull
    public PolicyAttachmentResult detachPolicyFromEntity(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntityCore> targetCatalogPath, @Nonnull PolarisEntityCore target, @Nonnull List<PolarisEntityCore> policyCatalogPath, @Nonnull PolicyEntity policy) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInTransaction(callCtx, () -> this.doDetachPolicyFromEntity(callCtx, ms, targetCatalogPath, target, policyCatalogPath, policy));
    }

    private PolicyAttachmentResult doDetachPolicyFromEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull List<PolarisEntityCore> targetCatalogPath, @Nonnull PolarisEntityCore target, @Nonnull List<PolarisEntityCore> policyCatalogPath, @Nonnull PolicyEntity policy) {
        PolarisEntityResolver targetResolver = new PolarisEntityResolver(callCtx, ms, targetCatalogPath, target);
        PolarisEntityResolver policyResolver = new PolarisEntityResolver(callCtx, ms, policyCatalogPath, policy);
        if (targetResolver.isFailure() || policyResolver.isFailure()) {
            return new PolicyAttachmentResult(BaseResult.ReturnStatus.ENTITY_CANNOT_BE_RESOLVED, null);
        }
        PolarisPolicyMappingRecord mappingRecord = ms.lookupPolicyMappingRecordInCurrentTxn(callCtx, target.getCatalogId(), target.getId(), policy.getPolicyTypeCode(), policy.getCatalogId(), policy.getId());
        if (mappingRecord == null) {
            return new PolicyAttachmentResult(BaseResult.ReturnStatus.POLICY_MAPPING_NOT_FOUND, null);
        }
        ms.deleteFromPolicyMappingRecordsInCurrentTxn(callCtx, mappingRecord);
        return new PolicyAttachmentResult(mappingRecord);
    }

    @Override
    @Nonnull
    public LoadPolicyMappingsResult loadPoliciesOnEntity(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore target) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.doLoadPoliciesOnEntity(callCtx, ms, target));
    }

    private LoadPolicyMappingsResult doLoadPoliciesOnEntity(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore target) {
        PolarisBaseEntity entity = ms.lookupEntityInCurrentTxn(callCtx, target.getCatalogId(), target.getId(), target.getTypeCode());
        if (entity == null) {
            return new LoadPolicyMappingsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        List<PolarisPolicyMappingRecord> policyMappingRecords = ms.loadAllPoliciesOnTargetInCurrentTxn(callCtx, target.getCatalogId(), target.getId());
        List<PolarisBaseEntity> policyEntities = this.loadPoliciesFromMappingRecords(callCtx, ms, policyMappingRecords);
        return new LoadPolicyMappingsResult(policyMappingRecords, policyEntities);
    }

    @Override
    @Nonnull
    public LoadPolicyMappingsResult loadPoliciesOnEntityByType(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore target, @Nonnull PolicyType policyType) {
        TransactionalPersistence ms = (TransactionalPersistence)callCtx.getMetaStore();
        return ms.runInReadTransaction(callCtx, () -> this.doLoadPoliciesOnEntityByType(callCtx, ms, target, policyType));
    }

    private LoadPolicyMappingsResult doLoadPoliciesOnEntityByType(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore target, @Nonnull PolicyType policyType) {
        PolarisBaseEntity entity = ms.lookupEntityInCurrentTxn(callCtx, target.getCatalogId(), target.getId(), target.getTypeCode());
        if (entity == null) {
            return new LoadPolicyMappingsResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        List<PolarisPolicyMappingRecord> policyMappingRecords = ms.loadPoliciesOnTargetByTypeInCurrentTxn(callCtx, target.getCatalogId(), target.getId(), policyType.getCode());
        List<PolarisBaseEntity> policyEntities = this.loadPoliciesFromMappingRecords(callCtx, ms, policyMappingRecords);
        return new LoadPolicyMappingsResult(policyMappingRecords, policyEntities);
    }

    @Nonnull
    private PolicyAttachmentResult persistNewPolicyMappingRecord(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull PolarisEntityCore target, @Nonnull PolicyEntity policy, Map<String, String> parameters) {
        callCtx.getDiagServices().checkNotNull(target, "unexpected_null_target");
        callCtx.getDiagServices().checkNotNull(policy, "unexpected_null_policy");
        PolarisPolicyMappingRecord mappingRecord = new PolarisPolicyMappingRecord(target.getCatalogId(), target.getId(), policy.getCatalogId(), policy.getId(), policy.getPolicyTypeCode(), parameters);
        try {
            ms.checkConditionsForWriteToPolicyMappingRecordsInCurrentTxn(callCtx, mappingRecord);
            ms.writeToPolicyMappingRecordsInCurrentTxn(callCtx, mappingRecord);
        }
        catch (IllegalArgumentException e) {
            return new PolicyAttachmentResult(BaseResult.ReturnStatus.UNEXPECTED_ERROR_SIGNALED, "Unknown policy type");
        }
        catch (PolicyMappingAlreadyExistsException e) {
            return new PolicyAttachmentResult(BaseResult.ReturnStatus.POLICY_MAPPING_OF_SAME_TYPE_ALREADY_EXISTS, e.getExistingRecord().getPolicyTypeCode());
        }
        return new PolicyAttachmentResult(mappingRecord);
    }

    private List<PolarisBaseEntity> loadPoliciesFromMappingRecords(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nonnull List<PolarisPolicyMappingRecord> policyMappingRecords) {
        List<PolarisEntityId> policyEntityIds = policyMappingRecords.stream().map(policyMappingRecord -> new PolarisEntityId(policyMappingRecord.getPolicyCatalogId(), policyMappingRecord.getPolicyId())).distinct().collect(Collectors.toList());
        return ms.lookupEntitiesInCurrentTxn(callCtx, policyEntityIds);
    }

    private static /* synthetic */ boolean lambda$dropEntityIfExists$16(PolarisBaseEntity entity) {
        return true;
    }
}

