/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.rest;

import com.google.common.base.Joiner;
import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTUtil;

public class PolarisResourcePaths {
    private static final Joiner SLASH = Joiner.on((String)"/").skipNulls();
    public static final String PREFIX = "prefix";
    public static final String V1_GENERIC_TABLES = "polaris/v1/{prefix}/namespaces/{namespace}/generic-tables";
    public static final String V1_GENERIC_TABLE = "polaris/v1/{prefix}/namespaces/{namespace}/generic-tables/{generic-table}";
    public static final String V1_POLICIES = "/polaris/v1/{prefix}/namespaces/{namespace}/policies";
    public static final String V1_POLICY = "/polaris/v1/{prefix}/namespaces/{namespace}/policies/{policy-name}";
    public static final String V1_POLICY_MAPPINGS = "/polaris/v1/{prefix}/namespaces/{namespace}/policies/{policy-name}/mappings";
    public static final String V1_APPLICABLE_POLICIES = "/polaris/v1/{prefix}/applicable-policies";
    private final String prefix;

    public PolarisResourcePaths(String prefix) {
        this.prefix = prefix;
    }

    public static PolarisResourcePaths forCatalogProperties(Map<String, String> properties) {
        return new PolarisResourcePaths(properties.get(PREFIX));
    }

    public String genericTables(Namespace ns) {
        return SLASH.join((Object)"polaris", (Object)"v1", new Object[]{this.prefix, "namespaces", RESTUtil.encodeNamespace((Namespace)ns), "generic-tables"});
    }

    public String genericTable(TableIdentifier ident) {
        return SLASH.join((Object)"polaris", (Object)"v1", new Object[]{this.prefix, "namespaces", RESTUtil.encodeNamespace((Namespace)ident.namespace()), "generic-tables", RESTUtil.encodeString((String)ident.name())});
    }
}

