/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.BoundTransform;
import org.apache.iceberg.expressions.NamedReference;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Types;

public class UnboundTransform<S, T>
implements UnboundTerm<T>,
Term {
    private final NamedReference<S> ref;
    private final Transform<S, T> transform;

    UnboundTransform(NamedReference<S> ref, Transform<S, T> transform) {
        this.ref = ref;
        this.transform = transform;
    }

    @Override
    public NamedReference<S> ref() {
        return this.ref;
    }

    public Transform<S, T> transform() {
        return this.transform;
    }

    @Override
    public BoundTransform<S, T> bind(Types.StructType struct, boolean caseSensitive) {
        Object boundRef = this.ref.bind(struct, caseSensitive);
        try {
            ValidationException.check(this.transform.canTransform(((BoundReference)boundRef).type()), "Cannot bind: %s cannot transform %s values from '%s'", this.transform, ((BoundReference)boundRef).type(), this.ref.name());
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Cannot bind: %s cannot transform %s values from '%s'", this.transform, ((BoundReference)boundRef).type(), this.ref.name());
        }
        return new BoundTransform<S, T>(boundRef, this.transform);
    }

    public String toString() {
        return this.transform + "(" + this.ref + ")";
    }
}

