/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.ViewPrivilege;

public class ViewGrant
extends GrantResource {
    @NotNull
    private final List<String> namespace;
    @NotNull
    @Size(min=1, max=256)
    private final @NotNull @Size(min=1, max=256) String viewName;
    @NotNull
    @Valid
    private final ViewPrivilege privilege;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="namespace", required=true)
    public List<String> getNamespace() {
        return this.namespace;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="viewName", required=true)
    public String getViewName() {
        return this.viewName;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="privilege", required=true)
    public ViewPrivilege getPrivilege() {
        return this.privilege;
    }

    @JsonCreator
    public ViewGrant(@JsonProperty(value="namespace", required=true) List<String> namespace, @JsonProperty(value="viewName", required=true) String viewName, @JsonProperty(value="privilege", required=true) ViewPrivilege privilege, @JsonProperty(value="type", required=true) GrantResource.TypeEnum type) {
        super(type);
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList());
        this.viewName = viewName;
        this.privilege = privilege;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(List<String> namespace, String viewName, ViewPrivilege privilege, GrantResource.TypeEnum type) {
        return new Builder(namespace, viewName, privilege, type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewGrant viewGrant = (ViewGrant)o;
        return super.equals(o) && Objects.equals(this.namespace, viewGrant.namespace) && Objects.equals(this.viewName, viewGrant.viewName) && Objects.equals((Object)this.privilege, (Object)viewGrant.privilege);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.namespace, super.hashCode(), this.viewName, super.hashCode(), this.privilege});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ViewGrant {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    viewName: ").append(this.toIndentedString(this.viewName)).append("\n");
        sb.append("    privilege: ").append(this.toIndentedString((Object)this.privilege)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private List<String> namespace;
        private String viewName;
        private ViewPrivilege privilege;
        private GrantResource.TypeEnum type;

        private Builder() {
        }

        private Builder(List<String> namespace, String viewName, ViewPrivilege privilege, GrantResource.TypeEnum type) {
            this.namespace = Objects.requireNonNullElse(namespace, new ArrayList());
            this.viewName = viewName;
            this.privilege = privilege;
            this.type = type;
        }

        public Builder setNamespace(List<String> namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setViewName(String viewName) {
            this.viewName = viewName;
            return this;
        }

        public Builder setPrivilege(ViewPrivilege privilege) {
            this.privilege = privilege;
            return this;
        }

        public Builder setType(GrantResource.TypeEnum type) {
            this.type = type;
            return this;
        }

        public ViewGrant build() {
            ViewGrant inst = new ViewGrant(this.namespace, this.viewName, this.privilege, this.type);
            return inst;
        }
    }
}

