/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.grpc.Attributes;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.vertx.core.MultiMap;
import io.vertx.core.net.SocketAddress;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.impl.BridgeMessageDecoder;
import io.vertx.grpc.common.impl.BridgeMessageEncoder;
import io.vertx.grpc.common.impl.ReadStreamAdapter;
import io.vertx.grpc.common.impl.Utils;
import io.vertx.grpc.common.impl.WriteStreamAdapter;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.GrpcServerRequest;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.server.GrpcServiceBridge;
import io.vertx.grpcio.server.GrpcIoServer;
import io.vertx.grpcio.server.GrpcIoServiceBridge;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class GrpcServiceBridgeImpl
implements GrpcServiceBridge,
GrpcIoServiceBridge {
    private final ServerServiceDefinition serviceDef;

    public GrpcServiceBridgeImpl(ServerServiceDefinition serviceDef) {
        this.serviceDef = serviceDef;
    }

    @Override
    public void unbind(GrpcServer server) {
        this.serviceDef.getMethods().forEach(m -> this.unbind(server, (ServerMethodDefinition)m));
    }

    @Override
    public void unbind(GrpcIoServer server) {
        this.serviceDef.getMethods().forEach(m -> this.unbind(server, (ServerMethodDefinition)m));
    }

    private <Req, Resp> void unbind(GrpcServer server, ServerMethodDefinition<Req, Resp> methodDef) {
        server.callHandler(methodDef.getMethodDescriptor(), null);
    }

    @Override
    public void bind(GrpcServer server) {
        this.serviceDef.getMethods().forEach(m -> this.bind(server, (ServerMethodDefinition)m));
    }

    @Override
    public void bind(GrpcIoServer server) {
        this.serviceDef.getMethods().forEach(m -> this.bind(server, (ServerMethodDefinition)m));
    }

    private <Req, Resp> void bind(GrpcServer server, ServerMethodDefinition<Req, Resp> methodDef) {
        server.callHandler(methodDef.getMethodDescriptor(), req -> {
            ServerCallHandler callHandler = methodDef.getServerCallHandler();
            ServerCallImpl call = new ServerCallImpl(req, methodDef);
            ServerCall.Listener listener = callHandler.startCall(call, Utils.readMetadata((MultiMap)req.headers()));
            call.init(listener);
        });
    }

    private static class ServerCallImpl<Req, Resp>
    extends ServerCall<Req, Resp> {
        private final GrpcServerRequest<Req, Resp> req;
        private final ServerMethodDefinition<Req, Resp> methodDef;
        private final ReadStreamAdapter<Req> readAdapter;
        private final WriteStreamAdapter<Resp> writeAdapter;
        private ServerCall.Listener<Req> listener;
        private final Decompressor decompressor;
        private Compressor compressor;
        private boolean halfClosed;
        private boolean closed;
        private int messagesSent;
        private final Attributes attributes;

        public ServerCallImpl(GrpcServerRequest<Req, Resp> req, ServerMethodDefinition<Req, Resp> methodDef) {
            String encoding = req.encoding();
            this.decompressor = DecompressorRegistry.getDefaultInstance().lookupDecompressor(encoding);
            this.req = req;
            this.methodDef = methodDef;
            this.readAdapter = new ReadStreamAdapter<Req>(){

                protected void handleClose() {
                    halfClosed = true;
                    listener.onHalfClose();
                }

                protected void handleMessage(Req msg) {
                    listener.onMessage(msg);
                }
            };
            this.writeAdapter = new WriteStreamAdapter<Resp>(){

                protected void handleReady() {
                    listener.onReady();
                }
            };
            this.attributes = this.createAttributes();
        }

        void init(ServerCall.Listener<Req> listener) {
            this.listener = listener;
            this.req.errorHandler(error -> {
                if (error == GrpcError.CANCELLED && !this.closed) {
                    listener.onCancel();
                }
            });
            this.readAdapter.init(this.req, new BridgeMessageDecoder(this.methodDef.getMethodDescriptor().getRequestMarshaller(), this.decompressor));
            this.writeAdapter.init(this.req.response(), (GrpcMessageEncoder)new BridgeMessageEncoder(this.methodDef.getMethodDescriptor().getResponseMarshaller(), this.compressor));
        }

        private Attributes createAttributes() {
            SocketAddress localAddr;
            Attributes.Builder builder = Attributes.newBuilder();
            SocketAddress remoteAddr = this.req.connection().remoteAddress();
            if (remoteAddr != null && remoteAddr.isInetSocket()) {
                try {
                    InetAddress address = InetAddress.getByName(remoteAddr.hostAddress());
                    builder.set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)new InetSocketAddress(address, remoteAddr.port()));
                }
                catch (UnknownHostException address) {
                    // empty catch block
                }
            }
            if ((localAddr = this.req.connection().localAddress()) != null && localAddr.isInetSocket()) {
                try {
                    InetAddress address = InetAddress.getByName(localAddr.hostAddress());
                    builder.set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)new InetSocketAddress(address, localAddr.port()));
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (this.req.connection().isSsl()) {
                builder.set(Grpc.TRANSPORT_ATTR_SSL_SESSION, (Object)this.req.connection().sslSession());
            }
            return builder.build();
        }

        public boolean isReady() {
            return this.writeAdapter.isReady();
        }

        public void request(int numMessages) {
            this.readAdapter.request(numMessages);
        }

        public void sendHeaders(Metadata headers) {
            Utils.writeMetadata((Metadata)headers, (MultiMap)this.req.response().headers());
        }

        public void sendMessage(Resp message) {
            ++this.messagesSent;
            this.writeAdapter.write(message);
        }

        public void close(Status status, Metadata trailers) {
            if (this.closed) {
                throw new IllegalStateException("Already closed");
            }
            this.closed = true;
            GrpcServerResponse<Req, Resp> response = this.req.response();
            if (status == Status.OK && this.methodDef.getMethodDescriptor().getType().serverSendsOneMessage() && this.messagesSent == 0) {
                response.status(GrpcStatus.UNAVAILABLE).end();
            } else {
                Utils.writeMetadata((Metadata)trailers, (MultiMap)response.trailers());
                response.status(GrpcStatus.valueOf((int)status.getCode().value()));
                response.statusMessage(status.getDescription());
                response.end();
            }
            this.listener.onComplete();
        }

        public boolean isCancelled() {
            return false;
        }

        public MethodDescriptor<Req, Resp> getMethodDescriptor() {
            return this.methodDef.getMethodDescriptor();
        }

        public void setCompression(String encoding) {
            this.compressor = CompressorRegistry.getDefaultInstance().lookupCompressor(encoding);
            this.req.response().encoding(encoding);
        }

        public void setMessageCompression(boolean enabled) {
            super.setMessageCompression(enabled);
        }

        public Attributes getAttributes() {
            return this.attributes;
        }
    }
}

