/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.core;

import java.util.function.Supplier;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class LazyUnmanagedBeanFactory<T>
implements BeanFactory<T> {
    private final Supplier<T> instanceSupplier;
    private volatile T instance = null;

    public LazyUnmanagedBeanFactory(Supplier<T> instanceSupplier) {
        this.instanceSupplier = instanceSupplier;
    }

    public String toString() {
        return "UnmanagedBeanFactory[" + String.valueOf(this.instanceSupplier) + "]";
    }

    @Override
    public BeanFactory.BeanInstance<T> createInstance() {
        return new BeanFactory.BeanInstance<T>(){

            @Override
            public T getInstance() {
                if (LazyUnmanagedBeanFactory.this.instance == null) {
                    LazyUnmanagedBeanFactory.this.instance = LazyUnmanagedBeanFactory.this.instanceSupplier.get();
                }
                return LazyUnmanagedBeanFactory.this.instance;
            }

            @Override
            public void close() {
            }
        };
    }
}

