/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.logging;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.ext.Provider;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.quarkus.logging.QuarkusLoggingConfiguration;
import org.slf4j.MDC;

@PreMatching
@ApplicationScoped
@Priority(value=901)
@Provider
public class QuarkusLoggingMDCFilter
implements ContainerRequestFilter {
    public static final String REALM_ID_KEY = "realmId";
    public static final String REQUEST_ID_KEY = "requestId";
    @Inject
    QuarkusLoggingConfiguration loggingConfiguration;

    public void filter(ContainerRequestContext rc) {
        this.loggingConfiguration.mdc().forEach(MDC::put);
        this.loggingConfiguration.mdc().forEach((arg_0, arg_1) -> ((ContainerRequestContext)rc).setProperty(arg_0, arg_1));
        String requestId = rc.getHeaderString(this.loggingConfiguration.requestIdHeaderName());
        if (requestId != null) {
            MDC.put((String)REQUEST_ID_KEY, (String)requestId);
            rc.setProperty(REQUEST_ID_KEY, (Object)requestId);
        }
        RealmContext realmContext = (RealmContext)rc.getProperty("realmContext");
        MDC.put((String)REALM_ID_KEY, (String)realmContext.getRealmIdentifier());
    }
}

