/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.common;

import jakarta.ws.rs.core.SecurityContext;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.polaris.core.auth.AuthenticatedPolarisPrincipal;

public interface CatalogAdapter {
    default public Namespace decodeNamespace(String namespace) {
        return RESTUtil.decodeNamespace((String)URLEncoder.encode(namespace, Charset.defaultCharset()));
    }

    default public void validatePrincipal(SecurityContext securityContext) {
        AuthenticatedPolarisPrincipal authenticatedPrincipal = (AuthenticatedPolarisPrincipal)securityContext.getUserPrincipal();
        if (authenticatedPrincipal == null) {
            throw new NotAuthorizedException("Failed to find authenticatedPrincipal in SecurityContext", new Object[0]);
        }
    }
}

