/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.exception;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.lang.runtime.SwitchBootstraps;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public final class IcebergJsonProcessingExceptionMapper
implements ExceptionMapper<JsonProcessingException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergJsonProcessingExceptionMapper.class);

    public Response toResponse(JsonProcessingException exception) {
        if (exception instanceof JsonGenerationException || exception instanceof InvalidDefinitionException) {
            long id = ThreadLocalRandom.current().nextLong();
            LOGGER.error(String.format(Locale.ROOT, "Error handling a request: %016x", id), (Throwable)exception);
            String message = String.format(Locale.ROOT, "There was an error processing your request. It has been logged (ID %016x).", id);
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(500, message, null)).build();
        }
        LOGGER.info("Unable to process JSON: {}", (Object)exception.getMessage());
        LOGGER.debug("Full JsonProcessingException", (Throwable)exception);
        JsonProcessingException jsonProcessingException = exception;
        Objects.requireNonNull(jsonProcessingException);
        JsonProcessingException jsonProcessingException2 = jsonProcessingException;
        int message = 0;
        String messagePrefix = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonParseException.class, ValueInstantiationException.class}, (Object)((Object)jsonProcessingException2), message)) {
            case 0 -> {
                JsonParseException e = (JsonParseException)jsonProcessingException2;
                yield "Invalid JSON: ";
            }
            case 1 -> {
                ValueInstantiationException ve = (ValueInstantiationException)jsonProcessingException2;
                yield "Invalid value: ";
            }
            default -> "";
        };
        String message2 = messagePrefix + exception.getOriginalMessage();
        ErrorResponse icebergErrorResponse = ErrorResponse.builder().responseCode(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode())).withType(((Object)((Object)exception)).getClass().getSimpleName()).withMessage(message2).build();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)icebergErrorResponse).build();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ErrorMessage(@JsonProperty(value="code") int code, @JsonProperty(value="message") @Nullable String message, @JsonProperty(value="details") @Nullable String details) {
    }
}

