/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.api;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.catalog.api.IcebergRestOAuth2ApiService;
import org.apache.polaris.service.types.TokenType;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/catalog/v1/oauth/tokens")
public class IcebergRestOAuth2Api {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergRestOAuth2Api.class);
    private final IcebergRestOAuth2ApiService service;

    @Inject
    public IcebergRestOAuth2Api(IcebergRestOAuth2ApiService service) {
        this.service = service;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Timed(value="polaris.OAuth2Api.getToken")
    @Timeout
    public Response getToken(@HeaderParam(value="Authorization") String authorization, @FormParam(value="grant_type") String grantType, @FormParam(value="scope") String scope, @FormParam(value="client_id") String clientId, @FormParam(value="client_secret") String clientSecret, @FormParam(value="requested_token_type") TokenType requestedTokenType, @FormParam(value="subject_token") String subjectToken, @FormParam(value="subject_token_type") TokenType subjectTokenType, @FormParam(value="actor_token") String actorToken, @FormParam(value="actor_token_type") TokenType actorTokenType, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking OAuth2Api with params").addKeyValue("operation", (Object)"getToken").log();
        Response ret = this.service.getToken(authorization, grantType, scope, clientId, clientSecret, requestedTokenType, subjectToken, subjectTokenType, actorToken, actorTokenType, realmContext, securityContext);
        LOGGER.debug("Completed execution of getToken API with status code {}", (Object)ret.getStatus());
        return ret;
    }
}

