/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.file.session;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.loader.Scope;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.server.session.AbstractSessionManager;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.Reloadable;
import org.apache.seata.server.session.SessionCondition;
import org.apache.seata.server.session.SessionManager;
import org.apache.seata.server.storage.file.ReloadableStore;
import org.apache.seata.server.storage.file.TransactionWriteStore;
import org.apache.seata.server.storage.file.session.FileSessionManager;
import org.apache.seata.server.storage.file.store.FileTransactionStoreManager;
import org.apache.seata.server.store.SessionStorable;
import org.apache.seata.server.store.TransactionStoreManager;

@LoadLevel(name="file", scope=Scope.PROTOTYPE)
public class FileSessionManager
extends AbstractSessionManager
implements Reloadable {
    private static final int READ_SIZE = ConfigurationFactory.getInstance().getInt("store.file.sessionReloadReadSize", 100);
    protected Map<String, GlobalSession> sessionMap = new ConcurrentHashMap(64);

    public FileSessionManager(String name) {
        super(name);
        this.transactionStoreManager = new /* Unavailable Anonymous Inner Class!! */;
    }

    public FileSessionManager(String name, String sessionStoreFilePath) throws IOException {
        super(name);
        this.transactionStoreManager = StringUtils.isNotBlank((String)sessionStoreFilePath) ? new FileTransactionStoreManager(sessionStoreFilePath + File.separator + name, (SessionManager)this) : new /* Unavailable Anonymous Inner Class!! */;
    }

    public void reload() {
        this.restoreSessions();
    }

    public void addGlobalSession(GlobalSession session) throws TransactionException {
        CollectionUtils.computeIfAbsent((Map)this.sessionMap, (Object)session.getXid(), k -> {
            try {
                super.addGlobalSession(session);
            }
            catch (TransactionException e) {
                LOGGER.error("addGlobalSession fail, msg: {}", (Object)e.getMessage());
            }
            return session;
        });
    }

    public GlobalSession findGlobalSession(String xid) {
        return (GlobalSession)this.sessionMap.get(xid);
    }

    public GlobalSession findGlobalSession(String xid, boolean withBranchSessions) {
        return (GlobalSession)this.sessionMap.get(xid);
    }

    public void removeGlobalSession(GlobalSession session) throws TransactionException {
        if (this.sessionMap.remove(session.getXid()) != null) {
            super.removeGlobalSession(session);
        }
    }

    public Collection<GlobalSession> allSessions() {
        return this.sessionMap.values();
    }

    public List<GlobalSession> findGlobalSessions(SessionCondition condition) {
        List<GlobalStatus> globalStatuses = null;
        if (null != condition.getStatuses() && condition.getStatuses().length > 0) {
            globalStatuses = Arrays.asList(condition.getStatuses());
        }
        Collection list = this.sessionMap.values();
        List<GlobalStatus> finalGlobalStatuses = globalStatuses;
        return list.parallelStream().filter(globalSession -> {
            if (null != condition.getOverTimeAliveMills() && condition.getOverTimeAliveMills() > 0L && System.currentTimeMillis() - globalSession.getBeginTime() <= condition.getOverTimeAliveMills()) {
                return false;
            }
            if (!StringUtils.isEmpty((CharSequence)condition.getXid())) {
                return Objects.equals(condition.getXid(), globalSession.getXid());
            }
            if (null != condition.getTransactionId() && condition.getTransactionId() > 0L) {
                return Objects.equals(condition.getTransactionId(), globalSession.getTransactionId());
            }
            if (null != finalGlobalStatuses) {
                return finalGlobalStatuses.contains(globalSession.getStatus());
            }
            return true;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T lockAndExecute(GlobalSession globalSession, GlobalSession.LockCallable<T> lockCallable) throws TransactionException {
        globalSession.lock();
        try {
            Object object = lockCallable.call();
            return (T)object;
        }
        finally {
            globalSession.unlock();
        }
    }

    private void restoreSessions() {
        HashSet removedGlobalBuffer = new HashSet();
        HashMap unhandledBranchBuffer = new HashMap();
        this.restoreSessions(true, removedGlobalBuffer, unhandledBranchBuffer);
        this.restoreSessions(false, removedGlobalBuffer, unhandledBranchBuffer);
        if (!unhandledBranchBuffer.isEmpty()) {
            unhandledBranchBuffer.values().forEach(unhandledBranchSessions -> unhandledBranchSessions.values().forEach(branchSession -> {
                String xid = branchSession.getXid();
                if (removedGlobalBuffer.contains(xid)) {
                    return;
                }
                long bid = branchSession.getBranchId();
                GlobalSession found = (GlobalSession)this.sessionMap.get(xid);
                if (found == null) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("GlobalSession Does Not Exists For BranchSession [" + bid + "/" + xid + "]");
                    }
                } else {
                    BranchSession existingBranch = found.getBranch(branchSession.getBranchId());
                    if (existingBranch == null) {
                        found.add(branchSession);
                    } else {
                        existingBranch.setStatus(branchSession.getStatus());
                    }
                }
            }));
        }
    }

    private boolean checkSessionStatus(GlobalSession globalSession) {
        GlobalStatus globalStatus = globalSession.getStatus();
        switch (3.$SwitchMap$org$apache$seata$core$model$GlobalStatus[globalStatus.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    private void restoreSessions(boolean isHistory, Set<String> removedGlobalBuffer, Map<String, Map<Long, BranchSession>> unhandledBranchBuffer) {
        if (!(this.transactionStoreManager instanceof ReloadableStore)) {
            return;
        }
        while (((ReloadableStore)this.transactionStoreManager).hasRemaining(isHistory)) {
            List stores = ((ReloadableStore)this.transactionStoreManager).readWriteStore(READ_SIZE, isHistory);
            this.restore(stores, removedGlobalBuffer, unhandledBranchBuffer);
        }
    }

    private void restore(List<TransactionWriteStore> stores, Set<String> removedGlobalBuffer, Map<String, Map<Long, BranchSession>> unhandledBranchBuffer) {
        block6: for (TransactionWriteStore store : stores) {
            TransactionStoreManager.LogOperation logOperation = store.getOperate();
            SessionStorable sessionStorable = store.getSessionRequest();
            switch (3.$SwitchMap$org$apache$seata$server$store$TransactionStoreManager$LogOperation[logOperation.ordinal()]) {
                case 1: 
                case 2: {
                    GlobalSession globalSession = (GlobalSession)sessionStorable;
                    if (globalSession.getTransactionId() == 0L) {
                        LOGGER.error("Restore globalSession from file failed, the transactionId is zero , xid:" + globalSession.getXid());
                        break;
                    }
                    if (removedGlobalBuffer.contains(globalSession.getXid())) break;
                    GlobalSession foundGlobalSession = (GlobalSession)this.sessionMap.get(globalSession.getXid());
                    if (foundGlobalSession == null) {
                        if (this.checkSessionStatus(globalSession)) {
                            this.sessionMap.put(globalSession.getXid(), globalSession);
                            break;
                        }
                        removedGlobalBuffer.add(globalSession.getXid());
                        unhandledBranchBuffer.remove(globalSession.getXid());
                        break;
                    }
                    if (this.checkSessionStatus(globalSession)) {
                        foundGlobalSession.setStatus(globalSession.getStatus());
                        break;
                    }
                    this.sessionMap.remove(globalSession.getXid());
                    removedGlobalBuffer.add(globalSession.getXid());
                    unhandledBranchBuffer.remove(globalSession.getXid());
                    break;
                }
                case 3: {
                    GlobalSession globalSession = (GlobalSession)sessionStorable;
                    if (globalSession.getTransactionId() == 0L) {
                        LOGGER.error("Restore globalSession from file failed, the transactionId is zero , xid:" + globalSession.getXid());
                        break;
                    }
                    if (removedGlobalBuffer.contains(globalSession.getXid())) break;
                    if (this.sessionMap.remove(globalSession.getXid()) == null && LOGGER.isInfoEnabled()) {
                        LOGGER.info("GlobalSession To Be Removed Does Not Exists [" + globalSession.getXid() + "]");
                    }
                    removedGlobalBuffer.add(globalSession.getXid());
                    unhandledBranchBuffer.remove(globalSession.getXid());
                    break;
                }
                case 4: 
                case 5: {
                    BranchSession branchSession = (BranchSession)sessionStorable;
                    if (branchSession.getTransactionId() == 0L) {
                        LOGGER.error("Restore branchSession from file failed, the transactionId is zero , xid:" + branchSession.getXid());
                        break;
                    }
                    if (removedGlobalBuffer.contains(branchSession.getXid())) break;
                    GlobalSession foundGlobalSession = (GlobalSession)this.sessionMap.get(branchSession.getXid());
                    if (foundGlobalSession == null) {
                        unhandledBranchBuffer.computeIfAbsent(branchSession.getXid(), key -> new HashMap()).put(branchSession.getBranchId(), branchSession);
                        break;
                    }
                    BranchSession existingBranch = foundGlobalSession.getBranch(branchSession.getBranchId());
                    if (existingBranch == null) {
                        foundGlobalSession.add(branchSession);
                        break;
                    }
                    existingBranch.setStatus(branchSession.getStatus());
                    break;
                }
                case 6: {
                    BranchSession branchSession = (BranchSession)sessionStorable;
                    String xid = branchSession.getXid();
                    if (removedGlobalBuffer.contains(xid)) break;
                    long bid = branchSession.getBranchId();
                    if (branchSession.getTransactionId() == 0L) {
                        LOGGER.error("Restore branchSession from file failed, the transactionId is zero , xid:" + branchSession.getXid());
                        break;
                    }
                    GlobalSession found = (GlobalSession)this.sessionMap.get(xid);
                    if (found == null) {
                        if (!LOGGER.isInfoEnabled()) continue block6;
                        LOGGER.info("GlobalSession To Be Updated (Remove Branch) Does Not Exists [" + bid + "/" + xid + "]");
                        break;
                    }
                    BranchSession theBranch = found.getBranch(bid);
                    if (theBranch == null) {
                        if (!LOGGER.isInfoEnabled()) continue block6;
                        LOGGER.info("BranchSession To Be Updated Does Not Exists [" + bid + "/" + xid + "]");
                        break;
                    }
                    found.remove(theBranch);
                    break;
                }
                default: {
                    throw new ShouldNeverHappenException("Unknown Operation: " + logOperation);
                }
            }
        }
    }

    public Map<String, GlobalSession> getSessionMap() {
        return this.sessionMap;
    }

    public void setSessionMap(Map<String, GlobalSession> sessionMap) {
        this.sessionMap = sessionMap;
    }

    public void destroy() {
        this.transactionStoreManager.shutdown();
    }
}

