/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spi;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.PropertiesCompatibleConfigFile;
import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.internals.ConfigRepository;
import com.ctrip.framework.apollo.internals.DefaultConfig;
import com.ctrip.framework.apollo.internals.JsonConfigFile;
import com.ctrip.framework.apollo.internals.LocalFileConfigRepository;
import com.ctrip.framework.apollo.internals.PropertiesCompatibleFileConfigRepository;
import com.ctrip.framework.apollo.internals.PropertiesConfigFile;
import com.ctrip.framework.apollo.internals.RemoteConfigRepository;
import com.ctrip.framework.apollo.internals.TxtConfigFile;
import com.ctrip.framework.apollo.internals.XmlConfigFile;
import com.ctrip.framework.apollo.internals.YamlConfigFile;
import com.ctrip.framework.apollo.internals.YmlConfigFile;
import com.ctrip.framework.apollo.spi.ConfigFactory;
import com.ctrip.framework.apollo.util.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigFactory
implements ConfigFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConfigFactory.class);
    private final ConfigUtil m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);

    @Override
    public Config create(String namespace) {
        ConfigFileFormat format = this.determineFileFormat(namespace);
        ConfigRepository configRepository = null;
        configRepository = ConfigFileFormat.isPropertiesCompatible((ConfigFileFormat)format) && format != ConfigFileFormat.Properties ? this.createPropertiesCompatibleFileConfigRepository(namespace, format) : this.createConfigRepository(namespace);
        logger.debug("Created a configuration repository of type [{}] for namespace [{}]", (Object)configRepository.getClass().getName(), (Object)namespace);
        return this.createRepositoryConfig(namespace, configRepository);
    }

    protected Config createRepositoryConfig(String namespace, ConfigRepository configRepository) {
        return new DefaultConfig(namespace, configRepository);
    }

    @Override
    public ConfigFile createConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        ConfigRepository configRepository = this.createConfigRepository(namespace);
        switch (configFileFormat) {
            case Properties: {
                return new PropertiesConfigFile(namespace, configRepository);
            }
            case XML: {
                return new XmlConfigFile(namespace, configRepository);
            }
            case JSON: {
                return new JsonConfigFile(namespace, configRepository);
            }
            case YAML: {
                return new YamlConfigFile(namespace, configRepository);
            }
            case YML: {
                return new YmlConfigFile(namespace, configRepository);
            }
            case TXT: {
                return new TxtConfigFile(namespace, configRepository);
            }
        }
        return null;
    }

    ConfigRepository createConfigRepository(String namespace) {
        if (this.m_configUtil.isPropertyFileCacheEnabled()) {
            return this.createLocalConfigRepository(namespace);
        }
        return this.createRemoteConfigRepository(namespace);
    }

    LocalFileConfigRepository createLocalConfigRepository(String namespace) {
        if (this.m_configUtil.isInLocalMode()) {
            logger.warn("==== Apollo is in local mode! Won't pull configs from remote server for namespace {} ! ====", (Object)namespace);
            return new LocalFileConfigRepository(namespace);
        }
        return new LocalFileConfigRepository(namespace, this.createRemoteConfigRepository(namespace));
    }

    RemoteConfigRepository createRemoteConfigRepository(String namespace) {
        return new RemoteConfigRepository(namespace);
    }

    PropertiesCompatibleFileConfigRepository createPropertiesCompatibleFileConfigRepository(String namespace, ConfigFileFormat format) {
        String actualNamespaceName = this.trimNamespaceFormat(namespace, format);
        PropertiesCompatibleConfigFile configFile = (PropertiesCompatibleConfigFile)ConfigService.getConfigFile(actualNamespaceName, format);
        return new PropertiesCompatibleFileConfigRepository(configFile);
    }

    ConfigFileFormat determineFileFormat(String namespaceName) {
        String lowerCase = namespaceName.toLowerCase();
        for (ConfigFileFormat format : ConfigFileFormat.values()) {
            if (!lowerCase.endsWith("." + format.getValue())) continue;
            return format;
        }
        return ConfigFileFormat.Properties;
    }

    String trimNamespaceFormat(String namespaceName, ConfigFileFormat format) {
        String extension = "." + format.getValue();
        if (!namespaceName.toLowerCase().endsWith(extension)) {
            return namespaceName;
        }
        return namespaceName.substring(0, namespaceName.length() - extension.length());
    }
}

