/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.bootstrap.template;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.apache.skywalking.apm.agent.core.plugin.bootstrap.IBootstrapLog;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.BootstrapInterRuntimeAssist;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.Origin;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.SuperCall;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.This;

public class InstanceMethodInterTemplate {
    private static String TARGET_INTERCEPTOR;
    private static InstanceMethodsAroundInterceptor INTERCEPTOR;
    private static IBootstrapLog LOGGER;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RuntimeType
    public static Object intercept(@This Object obj, @AllArguments Object[] allArguments, @SuperCall Callable<?> zuper, @Origin Method method) throws Throwable {
        MethodInterceptResult result;
        EnhancedInstance targetObject;
        block13: {
            targetObject = (EnhancedInstance)obj;
            InstanceMethodInterTemplate.prepare();
            result = new MethodInterceptResult();
            try {
                if (INTERCEPTOR != null) {
                    INTERCEPTOR.beforeMethod(targetObject, method, allArguments, method.getParameterTypes(), result);
                }
            }
            catch (Throwable t) {
                if (LOGGER == null) break block13;
                LOGGER.error(t, "class[{}] before method[{}] intercept failure", obj.getClass(), method.getName());
            }
        }
        Object ret = null;
        try {
            ret = !result.isContinue() ? result._ret() : zuper.call();
        }
        catch (Throwable t) {
            try {
                try {
                    if (INTERCEPTOR == null) throw t;
                    INTERCEPTOR.handleMethodException(targetObject, method, allArguments, method.getParameterTypes(), t);
                    throw t;
                }
                catch (Throwable t2) {
                    if (LOGGER == null) throw t;
                    LOGGER.error(t2, "class[{}] handle method[{}] exception failure", obj.getClass(), method.getName());
                }
                throw t;
            }
            catch (Throwable throwable) {
                try {
                    if (INTERCEPTOR == null) throw throwable;
                    ret = INTERCEPTOR.afterMethod(targetObject, method, allArguments, method.getParameterTypes(), ret);
                    throw throwable;
                }
                catch (Throwable t2) {
                    if (LOGGER == null) throw throwable;
                    LOGGER.error(t2, "class[{}] after method[{}] intercept failure", obj.getClass(), method.getName());
                }
                throw throwable;
            }
        }
        try {
            if (INTERCEPTOR == null) return ret;
            return INTERCEPTOR.afterMethod(targetObject, method, allArguments, method.getParameterTypes(), ret);
        }
        catch (Throwable t) {
            if (LOGGER == null) return ret;
            LOGGER.error(t, "class[{}] after method[{}] intercept failure", obj.getClass(), method.getName());
            return ret;
        }
    }

    private static void prepare() {
        if (INTERCEPTOR == null) {
            ClassLoader loader = BootstrapInterRuntimeAssist.getAgentClassLoader();
            if (loader != null) {
                IBootstrapLog logger = BootstrapInterRuntimeAssist.getLogger(loader, TARGET_INTERCEPTOR);
                if (logger != null) {
                    LOGGER = logger;
                    INTERCEPTOR = (InstanceMethodsAroundInterceptor)BootstrapInterRuntimeAssist.createInterceptor(loader, TARGET_INTERCEPTOR, LOGGER);
                }
            } else {
                LOGGER.error("Runtime ClassLoader not found when create {}." + TARGET_INTERCEPTOR);
            }
        }
    }
}

