/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditConfig {
    private static final Logger logger = LoggerFactory.getLogger(AuditConfig.class);
    private static String FILE_PATH = "./inLong-audit/";
    private static final int FILE_SIZE = 0x6400000;
    private static final int MAX_CACHE_ROWS = 1000000;
    private static final int MIN_CACHE_ROWS = 100;
    private String filePath;
    private int maxCacheRow;
    private int maxFileSize = 0x6400000;
    private String disasterFileName = "disaster.data";
    private int socketTimeout = 30000;
    private int retryTimes = 2;

    public AuditConfig(String filePath, int maxCacheRow) {
        this.filePath = filePath == null || filePath.length() == 0 ? FILE_PATH : filePath;
        this.maxCacheRow = maxCacheRow < 100 ? 1000000 : maxCacheRow;
    }

    public AuditConfig() {
        this.filePath = FILE_PATH;
        this.maxCacheRow = 1000000;
    }

    public String getDisasterFile() {
        return this.filePath + "/" + this.disasterFileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getMaxCacheRow() {
        return this.maxCacheRow;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public String getDisasterFileName() {
        return this.disasterFileName;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setMaxCacheRow(int maxCacheRow) {
        this.maxCacheRow = maxCacheRow;
    }

    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setDisasterFileName(String disasterFileName) {
        this.disasterFileName = disasterFileName;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditConfig)) {
            return false;
        }
        AuditConfig other = (AuditConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxCacheRow() != other.getMaxCacheRow()) {
            return false;
        }
        if (this.getMaxFileSize() != other.getMaxFileSize()) {
            return false;
        }
        if (this.getSocketTimeout() != other.getSocketTimeout()) {
            return false;
        }
        if (this.getRetryTimes() != other.getRetryTimes()) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        String this$disasterFileName = this.getDisasterFileName();
        String other$disasterFileName = other.getDisasterFileName();
        return !(this$disasterFileName == null ? other$disasterFileName != null : !this$disasterFileName.equals(other$disasterFileName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuditConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxCacheRow();
        result = result * 59 + this.getMaxFileSize();
        result = result * 59 + this.getSocketTimeout();
        result = result * 59 + this.getRetryTimes();
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        String $disasterFileName = this.getDisasterFileName();
        result = result * 59 + ($disasterFileName == null ? 43 : $disasterFileName.hashCode());
        return result;
    }

    public String toString() {
        return "AuditConfig(filePath=" + this.getFilePath() + ", maxCacheRow=" + this.getMaxCacheRow() + ", maxFileSize=" + this.getMaxFileSize() + ", disasterFileName=" + this.getDisasterFileName() + ", socketTimeout=" + this.getSocketTimeout() + ", retryTimes=" + this.getRetryTimes() + ")";
    }
}

