/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.api;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.api.AbstractRpcClient;
import org.apache.flume.api.HostInfo;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientConfigurationConstants;
import org.apache.flume.api.RpcClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverRpcClient
extends AbstractRpcClient
implements RpcClient {
    private volatile RpcClient client = null;
    private List<HostInfo> hosts;
    private Integer maxTries;
    private int lastCheckedhost = -1;
    private boolean isActive;
    private Properties configurationProperties;
    private static final Logger logger = LoggerFactory.getLogger(FailoverRpcClient.class);

    protected FailoverRpcClient() {
    }

    private synchronized void configureHosts(Properties properties) throws FlumeException {
        if (this.isActive) {
            logger.error("This client was already configured, cannot reconfigure.");
            throw new FlumeException("This client was already configured, cannot reconfigure.");
        }
        this.hosts = HostInfo.getHostInfoList(properties);
        String tries = properties.getProperty("max-attempts");
        if (tries == null || tries.isEmpty()) {
            this.maxTries = this.hosts.size();
        } else {
            try {
                this.maxTries = Integer.parseInt(tries);
            }
            catch (NumberFormatException e) {
                this.maxTries = this.hosts.size();
            }
        }
        this.batchSize = FailoverRpcClient.parseBatchSize(properties);
        this.isActive = true;
    }

    protected Integer getMaxTries() {
        return this.maxTries;
    }

    private synchronized RpcClient getClient() {
        if (this.client == null || !this.client.isActive()) {
            this.client = this.getNextClient();
            return this.client;
        }
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(Event event) throws EventDeliveryException {
        RpcClient localClient = null;
        FailoverRpcClient failoverRpcClient = this;
        synchronized (failoverRpcClient) {
            if (!this.isActive) {
                logger.error("Attempting to append to an already closed client.");
                throw new EventDeliveryException("Attempting to append to an already closed client.");
            }
        }
        int tries = 0;
        while (tries < this.maxTries) {
            try {
                ++tries;
                localClient = this.getClient();
                localClient.append(event);
                return;
            }
            catch (EventDeliveryException e) {
                logger.warn("Client failed. Exception follows: ", (Throwable)e);
                localClient.close();
                localClient = null;
            }
            catch (Exception e2) {
                logger.error("Failed to send event: ", (Throwable)e2);
                throw new EventDeliveryException("Failed to send event. Exception follows: ", e2);
            }
        }
        logger.error("Tried many times, could not send event.");
        throw new EventDeliveryException("Failed to send the event!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendBatch(List<Event> events) throws EventDeliveryException {
        RpcClient localClient = null;
        FailoverRpcClient failoverRpcClient = this;
        synchronized (failoverRpcClient) {
            if (!this.isActive) {
                logger.error("Attempting to append to an already closed client.");
                throw new EventDeliveryException("Attempting to append to an already closed client!");
            }
        }
        int tries = 0;
        while (tries < this.maxTries) {
            try {
                ++tries;
                localClient = this.getClient();
                localClient.appendBatch(events);
                return;
            }
            catch (EventDeliveryException e) {
                logger.warn("Client failed. Exception follows: ", (Throwable)e);
                localClient.close();
                localClient = null;
            }
            catch (Exception e1) {
                logger.error("No clients active: ", (Throwable)e1);
                throw new EventDeliveryException("No clients currently active. Exception follows: ", e1);
            }
        }
        logger.error("Tried many times, could not send event.");
        throw new EventDeliveryException("Failed to send the event!");
    }

    @Override
    public synchronized boolean isActive() {
        return this.isActive;
    }

    @Override
    public synchronized void close() throws FlumeException {
        if (this.client != null) {
            this.client.close();
            this.isActive = false;
        }
    }

    protected InetSocketAddress getLastConnectedServerAddress() {
        HostInfo hostInfo = this.hosts.get(this.lastCheckedhost);
        return new InetSocketAddress(hostInfo.getHostName(), hostInfo.getPortNumber());
    }

    private RpcClient getNextClient() throws FlumeException {
        HostInfo hostInfo;
        int count;
        this.lastCheckedhost = this.lastCheckedhost == this.hosts.size() - 1 ? -1 : this.lastCheckedhost;
        RpcClient localClient = null;
        int limit = this.hosts.size();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.configurationProperties);
        props.put("client.type", RpcClientConfigurationConstants.DEFAULT_CLIENT_TYPE);
        for (count = this.lastCheckedhost + 1; count < limit; ++count) {
            hostInfo = this.hosts.get(count);
            try {
                this.setDefaultProperties(hostInfo, props);
                localClient = RpcClientFactory.getInstance(props);
                this.lastCheckedhost = count;
                return localClient;
            }
            catch (FlumeException e) {
                logger.info("Could not connect to " + hostInfo, (Throwable)e);
                continue;
            }
        }
        for (count = 0; count <= this.lastCheckedhost; ++count) {
            hostInfo = this.hosts.get(count);
            try {
                this.setDefaultProperties(hostInfo, props);
                localClient = RpcClientFactory.getInstance(props);
                this.lastCheckedhost = count;
                return localClient;
            }
            catch (FlumeException e) {
                logger.info("Could not connect to " + hostInfo, (Throwable)e);
                continue;
            }
        }
        if (localClient == null) {
            this.lastCheckedhost = -1;
            logger.error("No active client found.");
            throw new FlumeException("No active client.");
        }
        return localClient;
    }

    private void setDefaultProperties(HostInfo hostInfo, Properties props) {
        props.put("client.type", RpcClientFactory.ClientType.DEFAULT.name());
        props.put("hosts", hostInfo.getReferenceName());
    }

    @Override
    public void configure(Properties properties) throws FlumeException {
        this.configurationProperties = new Properties();
        this.configurationProperties.putAll((Map<?, ?>)properties);
        this.configureHosts(this.configurationProperties);
    }
}

