/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.conf;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.AbstractConfiguration;
import org.apache.inlong.common.pojo.dataproxy.DataProxyTopicInfo;
import org.apache.inlong.common.pojo.dataproxy.MQClusterInfo;

public class JobProfile
extends AbstractConfiguration {
    private static final Gson GSON = new Gson();

    public static JobProfile parseJsonStr(String jsonStr) {
        JobProfile conf = new JobProfile();
        conf.loadJsonStrResource(jsonStr);
        return conf;
    }

    public static JobProfile parsePropertiesFile(String fileName) {
        JobProfile conf = new JobProfile();
        conf.loadPropertiesResource(fileName);
        return conf;
    }

    public static JobProfile parseJsonFile(String fileName) {
        JobProfile conf = new JobProfile();
        conf.loadJsonResource(fileName);
        return conf;
    }

    @Override
    public boolean allRequiredKeyExist() {
        return this.hasKey("job.id") && this.hasKey("job.source") && this.hasKey("job.sink") && this.hasKey("job.channel") && this.hasKey("job.groupId") && this.hasKey("job.streamId");
    }

    public String toJsonStr() {
        return GSON.toJson(this.getConfigStorage());
    }

    public String getInstanceId() {
        return this.get("job.instance.id");
    }

    public List<MQClusterInfo> getMqClusters() {
        List result = null;
        String mqClusterStr = this.get("job.mqClusters");
        if (StringUtils.isNotBlank((CharSequence)mqClusterStr)) {
            result = (List)GSON.fromJson(mqClusterStr, new TypeToken<List<MQClusterInfo>>(){}.getType());
        }
        return result;
    }

    public DataProxyTopicInfo getMqTopic() {
        DataProxyTopicInfo result = null;
        String topicStr = this.get("job.topicInfo");
        if (StringUtils.isNotBlank((CharSequence)topicStr)) {
            result = (DataProxyTopicInfo)GSON.fromJson(topicStr, DataProxyTopicInfo.class);
        }
        return result;
    }
}

