/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.util;

public class SnowFlake {
    private static final long START_STMP = 1480166465631L;
    private static final long SEQUENCE_BIT = 9L;
    private static final long MACHINE_BIT = 13L;
    public static final long MAX_MACHINE_NUM = 8191L;
    private static final long MAX_SEQUENCE = 511L;
    private static final long MACHINE_LEFT = 9L;
    private static final long TIMESTMP_LEFT = 22L;
    private long machineId;
    private long sequence = 0L;
    private long lastStmp = -1L;

    public SnowFlake(long machineId) {
        if (machineId > 8191L || machineId < 0L) {
            throw new IllegalArgumentException(machineId + "machineId can't be greater than MAX_MACHINE_NUM or less than 0 MAX_MACHINE_NUM" + 8191L);
        }
        this.machineId = machineId;
    }

    public synchronized long nextId() {
        long currStmp = this.getNewstmp();
        if (currStmp < this.lastStmp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStmp == this.lastStmp) {
            this.sequence = this.sequence + 1L & 0x1FFL;
            if (this.sequence == 0L) {
                currStmp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStmp = currStmp;
        return currStmp - 1480166465631L << 22 | this.machineId << 9 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewstmp();
        while (mill <= this.lastStmp) {
            mill = this.getNewstmp();
        }
        return mill;
    }

    private long getNewstmp() {
        return System.currentTimeMillis();
    }
}

