/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.monitor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterGroupExt {
    private String name;
    private HashMap<String, AtomicLong> counters = new HashMap();
    private int maxCnt = 100000;
    private static final Logger logger = LoggerFactory.getLogger(CounterGroupExt.class);

    public CounterGroupExt() {
    }

    public CounterGroupExt(int maxCnt) {
        this.maxCnt = maxCnt;
    }

    public synchronized Long get(String name) {
        return this.getCounter(name).get();
    }

    public synchronized Long incrementAndGet(String name) {
        return this.getCounter(name).incrementAndGet();
    }

    public synchronized Long addAndGet(String name, Long delta) {
        return this.counters.size() < this.maxCnt ? this.getCounter(name).addAndGet(delta) : 0L;
    }

    public synchronized void setValue(String name, Long newValue) {
        if (this.counters.size() < this.maxCnt) {
            this.getCounter(name).set(newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(CounterGroupExt counterGroup) {
        CounterGroupExt counterGroupExt = counterGroup;
        synchronized (counterGroupExt) {
            for (Map.Entry<String, AtomicLong> entry : counterGroup.getCounters().entrySet()) {
                this.addAndGet(entry.getKey(), entry.getValue().get());
            }
        }
    }

    public synchronized void set(String name, Long value) {
        this.getCounter(name).set(value);
    }

    public synchronized AtomicLong getCounter(String name) {
        return this.counters.computeIfAbsent(name, k -> new AtomicLong());
    }

    public synchronized void del(String name) {
        this.counters.remove(name);
    }

    public synchronized void clear() {
        this.counters.clear();
    }

    public synchronized String toString() {
        return "{ name:" + this.name + " counters:" + this.counters + " }";
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized HashMap<String, AtomicLong> getCounters() {
        return this.counters;
    }

    public synchronized void setCounters(HashMap<String, AtomicLong> counters) {
        this.counters = counters;
    }
}

