/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.pojo.sort.dataflow.field.format;

import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.BasicFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.DateTypeInfo;

public class DateFormatInfo
implements BasicFormatInfo<java.sql.Date> {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_FORMAT = "format";
    @JsonProperty(value="format")
    @Nonnull
    private final String format;

    @JsonCreator
    public DateFormatInfo(@JsonProperty(value="format") @Nonnull String format) {
        this.format = format;
        if (!(format.equals("SECONDS") || format.equals("MILLIS") || format.equals("MICROS") || "SQL".equals(format) || "ISO_8601".equals(format))) {
            FastDateFormat.getInstance((String)format);
        }
    }

    public DateFormatInfo() {
        this("yyyy-MM-dd");
    }

    @Nonnull
    public String getFormat() {
        return this.format;
    }

    @Override
    public DateTypeInfo getTypeInfo() {
        return DateTypeInfo.INSTANCE;
    }

    @Override
    public String serialize(java.sql.Date date) {
        switch (this.format) {
            case "MICROS": {
                long millis = date.getTime();
                long micros = TimeUnit.MILLISECONDS.toMicros(millis);
                return Long.toString(micros);
            }
            case "MILLIS": {
                long millis = date.getTime();
                return Long.toString(millis);
            }
            case "SECONDS": {
                long millis = date.getTime();
                long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
                return Long.toString(seconds);
            }
        }
        return FastDateFormat.getInstance((String)this.format).format(date.getTime());
    }

    @Override
    public java.sql.Date deserialize(String text) throws ParseException {
        switch (this.format) {
            case "MICROS": {
                long micros = Long.parseLong(text.trim());
                long millis = TimeUnit.MICROSECONDS.toMillis(micros);
                return new java.sql.Date(millis);
            }
            case "MILLIS": {
                long millis = Long.parseLong(text.trim());
                return new java.sql.Date(millis);
            }
            case "SECONDS": {
                long seconds = Long.parseLong(text.trim());
                long millis = TimeUnit.SECONDS.toMillis(seconds);
                return new java.sql.Date(millis);
            }
        }
        Date date = FastDateFormat.getInstance((String)this.format).parse(text.trim());
        return new java.sql.Date(date.getTime());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateFormatInfo that = (DateFormatInfo)o;
        return this.format.equals(that.format);
    }

    public int hashCode() {
        return Objects.hash(this.format);
    }

    public String toString() {
        return "DateFormatInfo{format='" + this.format + '\'' + '}';
    }
}

