/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

public enum StreamStatus {
    NEW(100, "new"),
    CONFIG_ING(110, "in configure"),
    CONFIG_FAILED(120, "configuration failed"),
    CONFIG_SUCCESSFUL(130, "configuration successful"),
    CONFIG_OFFLINE_ING(141, "configuration is going offline"),
    CONFIG_OFFLINE_SUCCESSFUL(140, "configuration offline successful"),
    CONFIG_ONLINE_ING(151, "configuration is going online"),
    DELETING(41, "deleting"),
    DELETED(40, "deleted");

    private final Integer code;
    private final String description;

    private StreamStatus(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public static boolean notAllowedUpdate(StreamStatus status) {
        return status == CONFIG_ING || status == CONFIG_OFFLINE_ING || status == CONFIG_ONLINE_ING || status == DELETING;
    }

    public static boolean notAllowedDelete(StreamStatus status) {
        return status == CONFIG_ING || status == CONFIG_ONLINE_ING || status == CONFIG_OFFLINE_ING;
    }

    public static StreamStatus forCode(int code) {
        for (StreamStatus status : StreamStatus.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        throw new IllegalStateException(String.format("Illegal code=%s for StreamStatus", code));
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

