/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.tool.excel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.tool.excel.ExcelCellDataTransfer;
import org.apache.inlong.manager.common.tool.excel.annotation.ExcelEntity;
import org.apache.inlong.manager.common.tool.excel.annotation.ExcelField;
import org.apache.inlong.manager.common.tool.excel.annotation.Font;
import org.apache.inlong.manager.common.tool.excel.annotation.Style;
import org.apache.inlong.manager.common.tool.excel.validator.ExcelCellValidator;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelTool {
    private static final int CONSTRAINT_MAX_LENGTH = 255;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelTool.class);
    private static final String DEFAULT_SHEET_NAME = "Sheet 1";
    private static final int DEFAULT_ROW_COUNT = 30;

    private ExcelTool() {
    }

    public static List<String> extractHeader(List<Pair<Field, ExcelField>> fieldMetas) {
        return fieldMetas.stream().map(fieldMeta -> ((ExcelField)fieldMeta.getRight()).name()).collect(Collectors.toList());
    }

    public static <T> void write(List<T> contents, OutputStream out) throws IOException {
        Preconditions.expectNotEmpty(contents, "Content can not be empty!");
        Class<?> clazz = contents.get(0).getClass();
        List<Map<String, String>> maps = ExcelTool.write2List(contents);
        ExcelTool.doWrite(maps, clazz, out);
    }

    public static <T> void doWrite(List<Map<String, String>> maps, Class<T> clazz, OutputStream out) throws IOException {
        Field[] fields = clazz.getDeclaredFields();
        List<Pair<Field, ExcelField>> fieldMetas = ExcelTool.extractFieldMetas(fields);
        if (fieldMetas.isEmpty()) {
            throw new IllegalArgumentException("At least one field must be marked as Excel Field by annotation @ExcelField in class " + clazz);
        }
        List<String> headNames = ExcelTool.extractHeader(fieldMetas);
        try (XSSFWorkbook hwb = new XSSFWorkbook();){
            ExcelEntity excelEntity = clazz.getAnnotation(ExcelEntity.class);
            String sheetName = excelEntity.name();
            if (StringUtils.isBlank((CharSequence)sheetName)) {
                sheetName = DEFAULT_SHEET_NAME;
            }
            XSSFSheet sheet = hwb.createSheet(sheetName);
            for (int index = 0; index < fieldMetas.size(); ++index) {
                Pair<Field, ExcelField> fieldMeta = fieldMetas.get(index);
                sheet.setColumnWidth(index, ((ExcelField)fieldMeta.getRight()).style().width());
            }
            List<XSSFCellStyle> headerStyles = ExcelTool.createContentCellStyle(hwb, fieldMetas, ExcelField::headerStyle, ExcelField::headerFont);
            ExcelTool.fillSheetHeader(sheet.createRow(0), headNames, headerStyles);
            ExcelTool.fillSheetValidation(sheet, fieldMetas, clazz.getCanonicalName());
            List<XSSFCellStyle> contentStyles = ExcelTool.createContentCellStyle(hwb, fieldMetas, ExcelField::style, ExcelField::font);
            if (CollectionUtils.isNotEmpty(maps)) {
                ExcelTool.fillSheetContent(sheet, headNames, maps, contentStyles);
            } else {
                ExcelTool.fillEmptySheetContent(sheet, headNames.size(), contentStyles);
            }
            hwb.write(out);
        }
        out.close();
        LOGGER.info("Database export succeeded");
    }

    private static List<Pair<Field, ExcelField>> extractFieldMetas(Field[] fields) {
        return Arrays.stream(fields).peek(field -> field.setAccessible(true)).map(field -> Pair.of((Object)field, (Object)field.getAnnotation(ExcelField.class))).filter(fieldMeta -> fieldMeta.getRight() != null).collect(Collectors.toList());
    }

    public static <T> void write(Class<T> clazz, OutputStream out) throws IOException {
        Preconditions.expectNotNull(clazz, "Class can not be empty!");
        ExcelTool.doWrite(null, clazz, out);
    }

    private static List<XSSFCellStyle> createContentCellStyle(XSSFWorkbook workbook, List<Pair<Field, ExcelField>> fieldMetas, Function<ExcelField, Style> styleGenerator, Function<ExcelField, Font> fontGenerator) {
        return fieldMetas.stream().map(fieldMeta -> {
            XSSFCellStyle style = workbook.createCellStyle();
            ExcelField excelField = (ExcelField)fieldMeta.getRight();
            Style excelStyle = (Style)styleGenerator.apply(excelField);
            Font excelFont = (Font)fontGenerator.apply(excelField);
            style.setFillForegroundColor(excelStyle.bgColor().getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            XSSFFont font = workbook.createFont();
            font.setFontName(excelFont.name());
            font.setColor(excelFont.color().getIndex());
            font.setFontHeightInPoints(excelFont.size());
            font.setBold(excelFont.bold());
            font.setItalic(excelFont.italic());
            style.setFont((org.apache.poi.ss.usermodel.Font)font);
            BorderStyle borderBottom = excelStyle.bottomBorderStyle();
            BorderStyle borderTop = excelStyle.topBorderStyle();
            BorderStyle borderLeft = excelStyle.leftBorderStyle();
            BorderStyle borderRight = excelStyle.rightBorderStyle();
            BorderStyle borderAll = excelStyle.allBorderStyle();
            if (borderAll != BorderStyle.NONE) {
                borderLeft = borderRight = borderAll;
                borderTop = borderRight;
                borderBottom = borderRight;
            }
            style.setBorderBottom(borderBottom);
            style.setBorderTop(borderTop);
            style.setBorderLeft(borderLeft);
            style.setBorderRight(borderRight);
            IndexedColors bottomBorderColor = excelStyle.bottomBorderColor();
            IndexedColors topBorderColor = excelStyle.topBorderColor();
            IndexedColors leftBorderColor = excelStyle.leftBorderColor();
            IndexedColors rightBorderColor = excelStyle.rightBorderColor();
            IndexedColors allBorderColor = excelStyle.allBorderColor();
            if (allBorderColor != IndexedColors.BLACK) {
                leftBorderColor = rightBorderColor = allBorderColor;
                topBorderColor = rightBorderColor;
                bottomBorderColor = rightBorderColor;
            }
            style.setBottomBorderColor(bottomBorderColor.getIndex());
            style.setTopBorderColor(topBorderColor.getIndex());
            style.setLeftBorderColor(leftBorderColor.getIndex());
            style.setRightBorderColor(rightBorderColor.getIndex());
            return style;
        }).collect(Collectors.toList());
    }

    private static void fillEmptySheetContent(XSSFSheet sheet, int colCount, List<XSSFCellStyle> contentCellStyles) {
        for (int index = 1; index < 30; ++index) {
            XSSFRow row = sheet.createRow(index);
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                XSSFCell cell = row.createCell(colIndex);
                cell.setCellStyle((CellStyle)contentCellStyles.get(colIndex));
            }
        }
    }

    private static void fillSheetContent(XSSFSheet sheet, List<String> heads, List<Map<String, String>> contents, List<XSSFCellStyle> contentStyles) {
        if (CollectionUtils.isEmpty(contents)) {
            return;
        }
        int rowSize = contents.size();
        for (int lineId = 0; lineId < rowSize; ++lineId) {
            Map<String, String> line = contents.get(lineId);
            XSSFRow row = sheet.createRow(lineId + 1);
            int headSize = heads.size();
            for (int colId = 0; colId < headSize; ++colId) {
                String title = heads.get(colId);
                String originValue = line.get(title);
                String value = StringUtils.isNotBlank((CharSequence)originValue) ? originValue : "";
                Cell cell = row.createCell(colId);
                cell.setCellValue(value);
                cell.setCellStyle((CellStyle)contentStyles.get(colId));
            }
        }
    }

    private static void fillSheetHeader(XSSFRow row, List<String> heads, List<XSSFCellStyle> headerStyles) {
        int headSize = heads.size();
        for (int index = 0; index < headSize; ++index) {
            XSSFCell cell = row.createCell(index);
            cell.setCellValue((RichTextString)new XSSFRichTextString(heads.get(index)));
            cell.setCellStyle((CellStyle)headerStyles.get(index));
        }
    }

    private static void fillSheetValidation(XSSFSheet sheet, List<Pair<Field, ExcelField>> fieldMetas, String className) {
        int bound = fieldMetas.size();
        for (int index = 0; index < bound; ++index) {
            Pair<Field, ExcelField> excelFieldPair = fieldMetas.get(index);
            Class<? extends ExcelCellValidator> validator = ((ExcelField)excelFieldPair.getRight()).validator();
            Optional<List> optionalList = Optional.ofNullable(validator).filter(v -> v != ExcelCellValidator.class).map(v -> {
                try {
                    return (ExcelCellValidator)v.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.error("Can not properly create ExcelCellValidator", (Throwable)e);
                    return null;
                }
            }).map(ExcelCellValidator::constraint);
            List valueOfCol = optionalList.orElseGet(Collections::emptyList);
            if (valueOfCol.isEmpty()) continue;
            if (String.join((CharSequence)"\n", valueOfCol).length() > 255) {
                throw new IllegalArgumentException("field '" + ((Field)excelFieldPair.getLeft()).getName() + "' in class '" + className + "' valid message length must be less than 255 characters");
            }
            CellRangeAddressList regions = new CellRangeAddressList(1, 255, index, index);
            XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(sheet);
            XSSFDataValidationConstraint explicitListConstraint = (XSSFDataValidationConstraint)dvHelper.createExplicitListConstraint(valueOfCol.toArray(new String[0]));
            XSSFDataValidation dataValidation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)explicitListConstraint, regions);
            sheet.addValidationData((DataValidation)dataValidation);
        }
    }

    public static <E> List<Map<String, String>> write2List(List<E> objects) {
        E firstInstance = objects.get(0);
        Class<?> firstClass = firstInstance.getClass();
        Field[] fields = firstClass.getDeclaredFields();
        Preconditions.expectTrue(fields.length > 0, "No method was found in the class '" + firstClass.getSimpleName() + "'");
        List fieldMeta = Arrays.stream(fields).map(field -> {
            field.setAccessible(true);
            return Pair.of((Object)field, (Object)field.getAnnotation(ExcelField.class));
        }).filter(p -> p.getRight() != null).map(p -> Triple.of((Object)p.getLeft(), (Object)((ExcelField)p.getRight()).name(), (Object)((Object)((ExcelField)p.getRight()).x2oTransfer()))).collect(Collectors.toList());
        return objects.stream().map(obj -> fieldMeta.stream().map(fm -> {
            Object fieldValue;
            try {
                fieldValue = ((Field)fm.getLeft()).get(obj);
            }
            catch (IllegalAccessException e) {
                return null;
            }
            String value = ((ExcelCellDataTransfer)((Object)((Object)((Object)fm.getRight())))).parse2Text(fieldValue);
            String name = (String)fm.getMiddle();
            return Pair.of((Object)name, (Object)value);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getKey, Pair::getValue))).collect(Collectors.toList());
    }

    public static <E> List<E> read(InputStream is, Class<E> clazz) throws IOException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        ClassMeta<E> classMeta = ClassMeta.of(clazz);
        int fieldCount = classMeta.fieldCount();
        Preconditions.expectTrue(fieldCount > 0, "The class contains at least one field with a @ExcelField annotation");
        XSSFWorkbook hssfWorkbook = new XSSFWorkbook(is);
        LinkedList result = new LinkedList();
        for (int sheetIndex = 0; sheetIndex < hssfWorkbook.getNumberOfSheets(); ++sheetIndex) {
            XSSFSheet sheet = hssfWorkbook.getSheetAt(sheetIndex);
            if (sheet == null) continue;
            XSSFRow headerRow = sheet.getRow(0);
            for (int colIndex2 = 0; colIndex2 < fieldCount + 10 && !classMeta.matchedAll(); ++colIndex2) {
                XSSFCell cell = headerRow.getCell(colIndex2, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                if (cell == null) continue;
                classMeta.setFieldLocation(cell.getStringCellValue(), colIndex2);
            }
            Preconditions.expectTrue(classMeta.matchedAll(), "The first line field must be the same number of @ExcelMeta annotated fields in the class");
            int lastRowNum = sheet.getLastRowNum();
            ArrayList<Object> currentResult = new ArrayList<Object>(lastRowNum);
            ArrayList<String> validateResult = new ArrayList<String>(lastRowNum);
            for (int rowNum = 1; rowNum <= lastRowNum; ++rowNum) {
                Map positionFieldMetaMap;
                boolean rowNotNull;
                XSSFRow row = sheet.getRow(rowNum);
                if (row == null || !(rowNotNull = (positionFieldMetaMap = ((ClassMeta)classMeta).positionFieldMetaMap).keySet().stream().map(colIndex -> row.getCell(colIndex.intValue(), Row.MissingCellPolicy.RETURN_BLANK_AS_NULL) != null).reduce(false, (left, right) -> left != false || right != false).booleanValue())) continue;
                Object instance = null;
                StringBuilder colValidateResult = new StringBuilder();
                boolean hasValueInRow = false;
                for (Map.Entry entry : positionFieldMetaMap.entrySet()) {
                    Integer colIndex3 = (Integer)entry.getKey();
                    FieldMeta fieldMeta = (FieldMeta)entry.getValue();
                    XSSFCell cell = row.getCell(colIndex3.intValue(), Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                    hasValueInRow = true;
                    ExcelCellDataTransfer cellDataTransfer = fieldMeta.getCellDataTransfer();
                    Object value = ExcelTool.parseCellValue(cellDataTransfer, cell);
                    if (instance == null) {
                        instance = clazz.newInstance();
                    }
                    ExcelTool.validateCellValue(fieldMeta, value).ifPresent(info -> colValidateResult.append("Column ").append(colIndex3 + 1).append(":").append((String)info).append(";"));
                    fieldMeta.getField().setAccessible(true);
                    fieldMeta.getField().set(instance, value);
                }
                if (hasValueInRow) {
                    currentResult.add(instance);
                }
                if (colValidateResult.length() <= 0) continue;
                String lineValidateResult = String.format("Error in Row: %d, %s", rowNum + 1, colValidateResult);
                validateResult.add(lineValidateResult);
            }
            Preconditions.expectEmpty(validateResult, ErrorCodeEnum.INVALID_PARAMETER, String.join((CharSequence)"\n", validateResult));
            result.addAll(currentResult);
        }
        return result;
    }

    private static Object parseCellValue(ExcelCellDataTransfer cellDataTransfer, XSSFCell cell) {
        Object o = null;
        if (cellDataTransfer == ExcelCellDataTransfer.DATE) {
            CellType cellTypeEnum = cell.getCellType();
            if (cellTypeEnum == CellType.STRING) {
                String cellValue = cell.getStringCellValue();
                o = cellDataTransfer.parseFromText(cellValue);
            } else if (cellTypeEnum == CellType.NUMERIC) {
                o = cell.getDateCellValue();
            }
        } else {
            String value = ExcelTool.parseCellValue((Cell)cell);
            o = value;
            if (cellDataTransfer != ExcelCellDataTransfer.NONE) {
                o = cellDataTransfer.parseFromText(value);
            }
        }
        return o;
    }

    private static String parseCellValue(Cell cell) {
        String cellValue;
        if (cell != null) {
            cell.setCellType(CellType.STRING);
            cellValue = cell.getStringCellValue();
            if (!StringUtils.isEmpty((CharSequence)cellValue)) {
                cellValue = cellValue.trim();
                cellValue = cellValue.replace("\n", "");
                cellValue = cellValue.replace("\r", "");
                cellValue = cellValue.replace("\\", "/");
            }
        } else {
            cellValue = "";
        }
        return cellValue;
    }

    private static Optional<String> validateCellValue(FieldMeta fieldMeta, Object value) {
        ExcelCellValidator<?> cellValidator = fieldMeta.getCellValidator();
        if (cellValidator != null && !cellValidator.validate(value)) {
            return Optional.of(cellValidator.getInvalidTip());
        }
        return Optional.empty();
    }

    static class ClassMeta<T> {
        private String name;
        private Class<T> tClass;
        private List<FieldMeta> classFieldMetas;
        private Map<String, FieldMeta> fieldNameMetaMap;
        private Map<String, FieldMeta> excelNameMetaMap;
        private boolean isSorted = false;
        private Map<Integer, FieldMeta> positionFieldMetaMap = new HashMap<Integer, FieldMeta>();

        private ClassMeta() {
        }

        public static <T> ClassMeta<T> of(Class<T> clazz) throws InstantiationException, IllegalAccessException, NoSuchMethodException {
            Field[] fields;
            ClassMeta<T> meta = new ClassMeta<T>();
            meta.setTClass(clazz);
            ExcelEntity excelEntity = clazz.getAnnotation(ExcelEntity.class);
            if (excelEntity != null) {
                meta.name = excelEntity.name();
            }
            for (Field field : fields = clazz.getDeclaredFields()) {
                ExcelField excelField = field.getAnnotation(ExcelField.class);
                if (excelField == null) continue;
                Class<? extends ExcelCellValidator> validatorClass = excelField.validator();
                ExcelCellDataTransfer excelCellDataTransfer = excelField.x2oTransfer();
                ExcelCellValidator excelCellValidator = null;
                if (validatorClass != ExcelCellValidator.class) {
                    excelCellValidator = validatorClass.newInstance();
                }
                super.addField(field.getName(), excelField.name(), field, field.getType(), excelCellDataTransfer, excelCellValidator);
            }
            return meta;
        }

        private void addField(String fieldName, String excelName, Field field, Class<?> fieldType, ExcelCellDataTransfer cellDataTransfer, ExcelCellValidator cellValidator) {
            if (this.classFieldMetas == null) {
                this.classFieldMetas = new ArrayList<FieldMeta>();
            }
            if (this.excelNameMetaMap == null) {
                this.excelNameMetaMap = new HashMap<String, FieldMeta>();
            }
            if (this.fieldNameMetaMap == null) {
                this.fieldNameMetaMap = new HashMap<String, FieldMeta>();
            }
            FieldMeta fieldMeta = new FieldMeta();
            fieldMeta.setName(fieldName);
            fieldMeta.setExcelName(excelName);
            fieldMeta.setFieldType(fieldType);
            fieldMeta.setCellDataTransfer(cellDataTransfer);
            fieldMeta.setCellValidator(cellValidator);
            fieldMeta.setField(field);
            this.fieldNameMetaMap.put(fieldName, fieldMeta);
            this.excelNameMetaMap.put(excelName, fieldMeta);
            this.classFieldMetas.add(fieldMeta);
        }

        public FieldMeta field(int position) {
            return this.positionFieldMetaMap.get(position);
        }

        public int fieldCount() {
            return this.classFieldMetas == null ? 0 : this.classFieldMetas.size();
        }

        public boolean matchedAll() {
            return this.positionFieldMetaMap.size() == this.excelNameMetaMap.size();
        }

        public void setFieldLocation(String excelName, int colIndex) {
            if (this.excelNameMetaMap.containsKey(excelName)) {
                this.positionFieldMetaMap.put(colIndex, this.excelNameMetaMap.get(excelName));
            }
        }

        public String getName() {
            return this.name;
        }

        public Class<T> getTClass() {
            return this.tClass;
        }

        public List<FieldMeta> getClassFieldMetas() {
            return this.classFieldMetas;
        }

        public Map<String, FieldMeta> getFieldNameMetaMap() {
            return this.fieldNameMetaMap;
        }

        public Map<String, FieldMeta> getExcelNameMetaMap() {
            return this.excelNameMetaMap;
        }

        public boolean isSorted() {
            return this.isSorted;
        }

        public Map<Integer, FieldMeta> getPositionFieldMetaMap() {
            return this.positionFieldMetaMap;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTClass(Class<T> tClass) {
            this.tClass = tClass;
        }

        public void setClassFieldMetas(List<FieldMeta> classFieldMetas) {
            this.classFieldMetas = classFieldMetas;
        }

        public void setFieldNameMetaMap(Map<String, FieldMeta> fieldNameMetaMap) {
            this.fieldNameMetaMap = fieldNameMetaMap;
        }

        public void setExcelNameMetaMap(Map<String, FieldMeta> excelNameMetaMap) {
            this.excelNameMetaMap = excelNameMetaMap;
        }

        public void setSorted(boolean isSorted) {
            this.isSorted = isSorted;
        }

        public void setPositionFieldMetaMap(Map<Integer, FieldMeta> positionFieldMetaMap) {
            this.positionFieldMetaMap = positionFieldMetaMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassMeta)) {
                return false;
            }
            ClassMeta other = (ClassMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSorted() != other.isSorted()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Class<T> this$tClass = this.getTClass();
            Class<T> other$tClass = other.getTClass();
            if (this$tClass == null ? other$tClass != null : !this$tClass.equals(other$tClass)) {
                return false;
            }
            List<FieldMeta> this$classFieldMetas = this.getClassFieldMetas();
            List<FieldMeta> other$classFieldMetas = other.getClassFieldMetas();
            if (this$classFieldMetas == null ? other$classFieldMetas != null : !((Object)this$classFieldMetas).equals(other$classFieldMetas)) {
                return false;
            }
            Map<String, FieldMeta> this$fieldNameMetaMap = this.getFieldNameMetaMap();
            Map<String, FieldMeta> other$fieldNameMetaMap = other.getFieldNameMetaMap();
            if (this$fieldNameMetaMap == null ? other$fieldNameMetaMap != null : !((Object)this$fieldNameMetaMap).equals(other$fieldNameMetaMap)) {
                return false;
            }
            Map<String, FieldMeta> this$excelNameMetaMap = this.getExcelNameMetaMap();
            Map<String, FieldMeta> other$excelNameMetaMap = other.getExcelNameMetaMap();
            if (this$excelNameMetaMap == null ? other$excelNameMetaMap != null : !((Object)this$excelNameMetaMap).equals(other$excelNameMetaMap)) {
                return false;
            }
            Map<Integer, FieldMeta> this$positionFieldMetaMap = this.getPositionFieldMetaMap();
            Map<Integer, FieldMeta> other$positionFieldMetaMap = other.getPositionFieldMetaMap();
            return !(this$positionFieldMetaMap == null ? other$positionFieldMetaMap != null : !((Object)this$positionFieldMetaMap).equals(other$positionFieldMetaMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClassMeta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSorted() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Class<T> $tClass = this.getTClass();
            result = result * 59 + ($tClass == null ? 43 : $tClass.hashCode());
            List<FieldMeta> $classFieldMetas = this.getClassFieldMetas();
            result = result * 59 + ($classFieldMetas == null ? 43 : ((Object)$classFieldMetas).hashCode());
            Map<String, FieldMeta> $fieldNameMetaMap = this.getFieldNameMetaMap();
            result = result * 59 + ($fieldNameMetaMap == null ? 43 : ((Object)$fieldNameMetaMap).hashCode());
            Map<String, FieldMeta> $excelNameMetaMap = this.getExcelNameMetaMap();
            result = result * 59 + ($excelNameMetaMap == null ? 43 : ((Object)$excelNameMetaMap).hashCode());
            Map<Integer, FieldMeta> $positionFieldMetaMap = this.getPositionFieldMetaMap();
            result = result * 59 + ($positionFieldMetaMap == null ? 43 : ((Object)$positionFieldMetaMap).hashCode());
            return result;
        }

        public String toString() {
            return "ExcelTool.ClassMeta(name=" + this.getName() + ", tClass=" + this.getTClass() + ", classFieldMetas=" + this.getClassFieldMetas() + ", fieldNameMetaMap=" + this.getFieldNameMetaMap() + ", excelNameMetaMap=" + this.getExcelNameMetaMap() + ", isSorted=" + this.isSorted() + ", positionFieldMetaMap=" + this.getPositionFieldMetaMap() + ")";
        }
    }

    static class FieldMeta
    implements Serializable {
        private String name;
        private String excelName;
        private Class<?> fieldType;
        private ExcelCellDataTransfer cellDataTransfer;
        private ExcelCellValidator<?> cellValidator;
        private transient Field field;

        public String getName() {
            return this.name;
        }

        public String getExcelName() {
            return this.excelName;
        }

        public Class<?> getFieldType() {
            return this.fieldType;
        }

        public ExcelCellDataTransfer getCellDataTransfer() {
            return this.cellDataTransfer;
        }

        public ExcelCellValidator<?> getCellValidator() {
            return this.cellValidator;
        }

        public Field getField() {
            return this.field;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setExcelName(String excelName) {
            this.excelName = excelName;
        }

        public void setFieldType(Class<?> fieldType) {
            this.fieldType = fieldType;
        }

        public void setCellDataTransfer(ExcelCellDataTransfer cellDataTransfer) {
            this.cellDataTransfer = cellDataTransfer;
        }

        public void setCellValidator(ExcelCellValidator<?> cellValidator) {
            this.cellValidator = cellValidator;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldMeta)) {
                return false;
            }
            FieldMeta other = (FieldMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$excelName = this.getExcelName();
            String other$excelName = other.getExcelName();
            if (this$excelName == null ? other$excelName != null : !this$excelName.equals(other$excelName)) {
                return false;
            }
            Class<?> this$fieldType = this.getFieldType();
            Class<?> other$fieldType = other.getFieldType();
            if (this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType)) {
                return false;
            }
            ExcelCellDataTransfer this$cellDataTransfer = this.getCellDataTransfer();
            ExcelCellDataTransfer other$cellDataTransfer = other.getCellDataTransfer();
            if (this$cellDataTransfer == null ? other$cellDataTransfer != null : !((Object)((Object)this$cellDataTransfer)).equals((Object)other$cellDataTransfer)) {
                return false;
            }
            ExcelCellValidator<?> this$cellValidator = this.getCellValidator();
            ExcelCellValidator<?> other$cellValidator = other.getCellValidator();
            return !(this$cellValidator == null ? other$cellValidator != null : !this$cellValidator.equals(other$cellValidator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldMeta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $excelName = this.getExcelName();
            result = result * 59 + ($excelName == null ? 43 : $excelName.hashCode());
            Class<?> $fieldType = this.getFieldType();
            result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
            ExcelCellDataTransfer $cellDataTransfer = this.getCellDataTransfer();
            result = result * 59 + ($cellDataTransfer == null ? 43 : ((Object)((Object)$cellDataTransfer)).hashCode());
            ExcelCellValidator<?> $cellValidator = this.getCellValidator();
            result = result * 59 + ($cellValidator == null ? 43 : $cellValidator.hashCode());
            return result;
        }

        public String toString() {
            return "ExcelTool.FieldMeta(name=" + this.getName() + ", excelName=" + this.getExcelName() + ", fieldType=" + this.getFieldType() + ", cellDataTransfer=" + (Object)((Object)this.getCellDataTransfer()) + ", cellValidator=" + this.getCellValidator() + ", field=" + this.getField() + ")";
        }
    }
}

