/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.tool.excel.tuple;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.inlong.manager.common.tool.excel.tuple.ImmutableQuartet;

public abstract class Quartet<L, M, R, S>
implements Comparable<Quartet<L, M, R, S>>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final QuarterAdapter<?, ?, ?, ?>[] EMPTY_ARRAY = new QuarterAdapter[0];

    public static <L, M, R, S> Quartet<L, M, R, S>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static <L, M, R, S> Quartet<L, M, R, S> of(L f1, M f2, R f3, S f4) {
        return new ImmutableQuartet<L, M, R, S>(f1, f2, f3, f4);
    }

    @Override
    public int compareTo(Quartet<L, M, R, S> other) {
        return new CompareToBuilder().append(this.getF1(), other.getF1()).append(this.getF2(), other.getF2()).append(this.getF3(), other.getF3()).append(this.getF4(), other.getF4()).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quartet) {
            Quartet other = (Quartet)obj;
            return Objects.equals(this.getF1(), other.getF1()) && Objects.equals(this.getF2(), other.getF2()) && Objects.equals(this.getF3(), other.getF3()) && Objects.equals(this.getF4(), other.getF4());
        }
        return false;
    }

    public abstract L getF1();

    public abstract M getF2();

    public abstract R getF3();

    public abstract S getF4();

    public int hashCode() {
        return Objects.hashCode(this.getF1()) ^ Objects.hashCode(this.getF2()) ^ Objects.hashCode(this.getF3()) ^ Objects.hashCode(this.getF4());
    }

    public String toString() {
        return "(" + this.getF1() + "," + this.getF2() + "," + this.getF3() + "," + this.getF4() + ")";
    }

    public String toString(String format) {
        return String.format(format, this.getF1(), this.getF2(), this.getF3(), this.getF4());
    }

    private static final class QuarterAdapter<L, M, R, S>
    extends Quartet<L, M, R, S> {
        private static final long serialVersionUID = 1L;

        private QuarterAdapter() {
        }

        @Override
        public L getF1() {
            return null;
        }

        @Override
        public M getF2() {
            return null;
        }

        @Override
        public R getF3() {
            return null;
        }

        @Override
        public S getF4() {
            return null;
        }
    }
}

