/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.util.Preconditions;

public class InlongCollectionUtils {
    public static <K, V, T> Map<K, V> transformToImmutableMap(Collection<T> originCollection, Function<T, K> keyTransformFunction, Function<T, V> valueTransformFunction) {
        if (CollectionUtils.isEmpty(originCollection)) {
            return ImmutableMap.of();
        }
        Preconditions.expectNotNull(keyTransformFunction, "KeyTransformFunction cannot be null");
        Preconditions.expectNotNull(valueTransformFunction, "ValueTransformFunction cannot be null");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        originCollection.forEach(originObject -> builder.put(keyTransformFunction.apply(originObject), valueTransformFunction.apply(originObject)));
        return builder.build();
    }
}

