/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.data.rest.core.config.EnumTranslationConfiguration;
import org.springframework.data.util.StreamUtils;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EnumTranslator
implements EnumTranslationConfiguration {
    private final MessageResolver resolver;
    private boolean enableDefaultTranslation;
    private boolean parseEnumNameAsFallback;

    public EnumTranslator(MessageResolver resolver) {
        Assert.notNull((Object)resolver, (String)"MessageResolver must not be null!");
        this.resolver = resolver;
        this.enableDefaultTranslation = true;
        this.parseEnumNameAsFallback = true;
    }

    public void setEnableDefaultTranslation(boolean enableDefaultTranslation) {
        this.enableDefaultTranslation = enableDefaultTranslation;
    }

    public void setParseEnumNameAsFallback(boolean parseEnumNameAsFallback) {
        this.parseEnumNameAsFallback = parseEnumNameAsFallback;
    }

    public String asText(Enum<?> value) {
        Assert.notNull(value, (String)"Enum value must not be null!");
        return this.resolver.resolve((MessageSourceResolvable)TranslatedEnum.of(value, this.enableDefaultTranslation));
    }

    public List<String> getValues(Class<? extends Enum<?>> type) {
        Assert.notNull(type, (String)"Enum type must not be null!");
        return (List)Arrays.stream(type.getEnumConstants()).map(this::asText).collect(StreamUtils.toUnmodifiableList());
    }

    public <T extends Enum<?>> T fromText(Class<T> type, String text) {
        if (!StringUtils.hasText((String)text)) {
            return null;
        }
        Assert.notNull(type, (String)"Enum type must not be null!");
        T value = this.resolveEnum(type, text, true);
        if (value != null) {
            return value;
        }
        value = this.fromDefault(type, text);
        if (value != null && this.enableDefaultTranslation && this.asText((Enum<?>)value).equals(text)) {
            return value;
        }
        return this.parseEnumNameAsFallback ? (T)this.resolveEnum(type, text, false) : null;
    }

    private <T extends Enum<?>> T resolveEnum(Class<T> type, String text, boolean resolve) {
        for (Enum value : (Enum[])type.getEnumConstants()) {
            String resolved;
            String string = resolved = resolve ? this.asText(value) : value.name();
            if (resolved == null || !resolved.equals(text)) continue;
            return (T)value;
        }
        return null;
    }

    private <T extends Enum<?>> T fromDefault(Class<T> type, String text) {
        return this.resolveEnum(type, text.toUpperCase(Locale.US).replaceAll(" ", "_"), true);
    }

    private static class TranslatedEnum
    implements MessageSourceResolvable {
        private final Enum<?> value;
        private final boolean withDefaultTranslation;

        private TranslatedEnum(Enum<?> value, boolean withDefaultTranslation) {
            this.value = value;
            this.withDefaultTranslation = withDefaultTranslation;
        }

        public static TranslatedEnum of(Enum<?> value, boolean withDefaultTranslation) {
            return new TranslatedEnum(value, withDefaultTranslation);
        }

        public String[] getCodes() {
            return new String[]{String.format("%s.%s", this.value.getDeclaringClass().getName(), this.value.name())};
        }

        public String getDefaultMessage() {
            return this.withDefaultTranslation ? TranslatedEnum.toDefault(this.value) : this.value.name();
        }

        private static String toDefault(Enum<?> value) {
            return StringUtils.capitalize((String)value.name().toLowerCase(Locale.US).replaceAll("_", " "));
        }
    }
}

