/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.webmvc.json.MappedProperties;
import org.springframework.data.rest.webmvc.json.patch.BindContext;
import org.springframework.util.Assert;

class JacksonBindContext
implements BindContext {
    private final PersistentEntities entities;
    private final ObjectMapper mapper;

    public JacksonBindContext(PersistentEntities entities, ObjectMapper mapper) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        this.entities = entities;
        this.mapper = mapper;
    }

    @Override
    public Optional<String> getReadableProperty(String segment, Class<?> type) {
        return JacksonBindContext.getProperty(this.entities.getPersistentEntity(type).map(it -> MappedProperties.forSerialization(it, this.mapper)).filter(it -> it.isReadableField(segment)), segment);
    }

    @Override
    public Optional<String> getWritableProperty(String segment, Class<?> type) {
        return JacksonBindContext.getProperty(this.entities.getPersistentEntity(type).map(it -> MappedProperties.forDeserialization(it, this.mapper)).filter(it -> it.isWritableField(segment)), segment);
    }

    private static Optional<String> getProperty(Optional<MappedProperties> properties, String segment) {
        return properties.map(it -> it.getPersistentProperty(segment)).map(PersistentProperty::getName);
    }
}

