/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.statisticslevel;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;

public class StatisticsFilter
implements FilterPredicate.Visitor<Boolean> {
    private static final boolean BLOCK_MIGHT_MATCH = false;
    private static final boolean BLOCK_CANNOT_MATCH = true;
    private final Map<ColumnPath, ColumnChunkMetaData> columns = new HashMap<ColumnPath, ColumnChunkMetaData>();

    public static boolean canDrop(FilterPredicate pred, List<ColumnChunkMetaData> columns) {
        Objects.requireNonNull(pred, "pred cannot be null");
        Objects.requireNonNull(columns, "columns cannot be null");
        return (Boolean)pred.accept((FilterPredicate.Visitor)new StatisticsFilter(columns));
    }

    private StatisticsFilter(List<ColumnChunkMetaData> columnsList) {
        for (ColumnChunkMetaData chunk : columnsList) {
            this.columns.put(chunk.getPath(), chunk);
        }
    }

    private ColumnChunkMetaData getColumnChunk(ColumnPath columnPath) {
        return this.columns.get(columnPath);
    }

    private boolean isAllNulls(ColumnChunkMetaData column) {
        return column.getStatistics().getNumNulls() == column.getValueCount();
    }

    private boolean hasNulls(ColumnChunkMetaData column) {
        return column.getStatistics().getNumNulls() > 0L;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.Eq<T> eq) {
        Operators.Column filterColumn = eq.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        Comparable value = eq.getValue();
        if (meta == null) {
            if (value != null) {
                return true;
            }
            return false;
        }
        Statistics stats = meta.getStatistics();
        if (stats.isEmpty()) {
            return false;
        }
        if (value == null) {
            if (!stats.isNumNullsSet()) {
                return false;
            }
            return !this.hasNulls(meta);
        }
        if (this.isAllNulls(meta)) {
            return true;
        }
        if (!stats.hasNonNullValue()) {
            return false;
        }
        return stats.compareMinToValue(value) > 0 || stats.compareMaxToValue(value) < 0;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.NotEq<T> notEq) {
        Operators.Column filterColumn = notEq.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        Comparable value = notEq.getValue();
        if (meta == null) {
            if (value == null) {
                return true;
            }
            return false;
        }
        Statistics stats = meta.getStatistics();
        if (stats.isEmpty()) {
            return false;
        }
        if (value == null) {
            return this.isAllNulls(meta);
        }
        if (stats.isNumNullsSet() && this.hasNulls(meta)) {
            return false;
        }
        if (!stats.hasNonNullValue()) {
            return false;
        }
        return stats.compareMinToValue(value) == 0 && stats.compareMaxToValue(value) == 0;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.Lt<T> lt) {
        Operators.Column filterColumn = lt.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        if (meta == null) {
            return true;
        }
        Statistics stats = meta.getStatistics();
        if (stats.isEmpty()) {
            return false;
        }
        if (this.isAllNulls(meta)) {
            return true;
        }
        if (!stats.hasNonNullValue()) {
            return false;
        }
        Comparable value = lt.getValue();
        return stats.compareMinToValue(value) >= 0;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.LtEq<T> ltEq) {
        Operators.Column filterColumn = ltEq.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        if (meta == null) {
            return true;
        }
        Statistics stats = meta.getStatistics();
        if (stats.isEmpty()) {
            return false;
        }
        if (this.isAllNulls(meta)) {
            return true;
        }
        if (!stats.hasNonNullValue()) {
            return false;
        }
        Comparable value = ltEq.getValue();
        return stats.compareMinToValue(value) > 0;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.Gt<T> gt) {
        Operators.Column filterColumn = gt.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        if (meta == null) {
            return true;
        }
        Statistics stats = meta.getStatistics();
        if (stats.isEmpty()) {
            return false;
        }
        if (this.isAllNulls(meta)) {
            return true;
        }
        if (!stats.hasNonNullValue()) {
            return false;
        }
        Comparable value = gt.getValue();
        return stats.compareMaxToValue(value) <= 0;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.GtEq<T> gtEq) {
        Operators.Column filterColumn = gtEq.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        if (meta == null) {
            return true;
        }
        Statistics stats = meta.getStatistics();
        if (stats.isEmpty()) {
            return false;
        }
        if (this.isAllNulls(meta)) {
            return true;
        }
        if (!stats.hasNonNullValue()) {
            return false;
        }
        Comparable value = gtEq.getValue();
        return stats.compareMaxToValue(value) < 0;
    }

    public Boolean visit(Operators.And and) {
        return (Boolean)and.getLeft().accept((FilterPredicate.Visitor)this) != false || (Boolean)and.getRight().accept((FilterPredicate.Visitor)this) != false;
    }

    public Boolean visit(Operators.Or or) {
        return (Boolean)or.getLeft().accept((FilterPredicate.Visitor)this) != false && (Boolean)or.getRight().accept((FilterPredicate.Visitor)this) != false;
    }

    public Boolean visit(Operators.Not not) {
        throw new IllegalArgumentException("This predicate contains a not! Did you forget to run this predicate through LogicalInverseRewriter? " + not);
    }

    private <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.UserDefined<T, U> ud, boolean inverted) {
        Operators.Column filterColumn = ud.getColumn();
        ColumnChunkMetaData columnChunk = this.getColumnChunk(filterColumn.getColumnPath());
        UserDefinedPredicate udp = ud.getUserDefinedPredicate();
        if (columnChunk == null) {
            if (inverted) {
                return udp.acceptsNullValue();
            }
            return !udp.acceptsNullValue();
        }
        Statistics stats = columnChunk.getStatistics();
        if (stats.isEmpty()) {
            return false;
        }
        if (this.isAllNulls(columnChunk)) {
            if (inverted) {
                return udp.acceptsNullValue();
            }
            return !udp.acceptsNullValue();
        }
        if (!stats.hasNonNullValue()) {
            return false;
        }
        org.apache.parquet.filter2.predicate.Statistics udpStats = new org.apache.parquet.filter2.predicate.Statistics((Object)stats.genericGetMin(), (Object)stats.genericGetMax(), (Comparator)stats.comparator());
        if (inverted) {
            return udp.inverseCanDrop(udpStats);
        }
        return udp.canDrop(udpStats);
    }

    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.UserDefined<T, U> ud) {
        return this.visit(ud, false);
    }

    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.LogicalNotUserDefined<T, U> lnud) {
        return this.visit(lnud.getUserDefined(), true);
    }
}

