/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.audit.AuditAlertRule;
import org.apache.inlong.manager.pojo.audit.AuditAlertRulePageRequest;
import org.apache.inlong.manager.pojo.audit.AuditAlertRuleRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.core.AuditAlertRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"Audit-Alert-Rule-API"})
public class AuditAlertRuleController {
    @Lazy
    @Autowired
    private AuditAlertRuleService auditAlertRuleService;

    @PostMapping(value={"/audit/alert/rule"})
    @ApiOperation(value="Create an Audit alarm policy")
    public Response<Integer> create(@Valid @RequestBody AuditAlertRuleRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        Integer ruleId = this.auditAlertRuleService.create(request, operator);
        return Response.success((Object)ruleId);
    }

    @GetMapping(value={"/audit/alert/rule/get/{id}"})
    @ApiOperation(value="Query the details of the alarm policy")
    public Response<AuditAlertRule> get(@PathVariable Integer id) {
        return Response.success((Object)this.auditAlertRuleService.get(id));
    }

    @PostMapping(value={"/audit/alert/rule/list"})
    @ApiOperation(value="Batch query alarm policies")
    public Response<PageResult<AuditAlertRule>> selectByCondition(@RequestBody AuditAlertRulePageRequest request) {
        return Response.success((Object)this.auditAlertRuleService.selectByCondition(request));
    }

    @PutMapping(value={"/audit/alert/rule/update"})
    @ApiOperation(value="Update the Audit alarm policy")
    public Response<Boolean> update(@Validated(value={UpdateValidation.class}) @RequestBody AuditAlertRuleRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        Boolean result = this.auditAlertRuleService.update(request, operator);
        return Response.success((Object)result);
    }

    @DeleteMapping(value={"/audit/delete/{id}"})
    @ApiOperation(value="Delete the Audit alarm policy")
    public Response<Boolean> delete(@PathVariable Integer id) {
        return Response.success((Object)this.auditAlertRuleService.delete(id));
    }
}

