/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.enums.OperationTarget;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.TenantRoleInfo;
import org.apache.inlong.manager.pojo.user.TenantRolePageRequest;
import org.apache.inlong.manager.pojo.user.TenantRoleRequest;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.apache.inlong.manager.service.user.TenantRoleService;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-InlongTenantRole-API"})
public class OpenInlongTenantRoleController {
    @Autowired
    private TenantRoleService tenantRoleService;

    @RequestMapping(value={"/role/tenant/get/{id}"}, method={RequestMethod.GET})
    @ApiOperation(value="Get tenant role by ID")
    @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)
    @RequiresRoles(logical=Logical.OR, value={"TENANT_ADMIN", "TENANT_OPERATOR", "INLONG_ADMIN"})
    public Response<TenantRoleInfo> get(@PathVariable int id) {
        return Response.success((Object)this.tenantRoleService.get(id));
    }

    @RequestMapping(value={"/role/tenant/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.TENANT)
    @ApiOperation(value="Save tenant role")
    @RequiresRoles(logical=Logical.OR, value={"TENANT_ADMIN", "INLONG_ADMIN"})
    public Response<Integer> save(@Validated @RequestBody TenantRoleRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.tenantRoleService.save(request, operator));
    }

    @RequestMapping(value={"/role/tenant/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.TENANT)
    @ApiOperation(value="Update tenant role")
    @RequiresRoles(logical=Logical.OR, value={"TENANT_ADMIN", "INLONG_ADMIN"})
    public Response<Boolean> update(@Validated @RequestBody TenantRoleRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.tenantRoleService.update(request, operator));
    }

    @RequestMapping(value={"/role/tenant/list"}, method={RequestMethod.POST})
    @ApiOperation(value="List tenant roles by paginating")
    public Response<PageResult<TenantRoleInfo>> listByCondition(@RequestBody TenantRolePageRequest request) {
        return Response.success((Object)this.tenantRoleService.listByCondition(request));
    }

    @RequestMapping(value={"/role/tenant/delete/{id}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete tenant role by ID")
    @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)
    @RequiresRoles(logical=Logical.OR, value={"TENANT_ADMIN", "INLONG_ADMIN"})
    public Response<Boolean> delete(@PathVariable int id) {
        return Response.success((Object)this.tenantRoleService.delete(Integer.valueOf(id)));
    }
}

