/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"fibonacci"}, parameter="(Numeric numeric)", descriptions={"- Return NULL if 'numeric' is NULL;", "- Returns the nth Fibonacci number"}, examples={"fibonacci(0) = 0", "fibonacci(1) = 1", "fibonacci(2) = 1", "fibonacci(3) = 2", "fibonacci(4) = 3"})
public class FibonacciFunction
implements ValueParser {
    private ValueParser numberParser;

    public FibonacciFunction(Function expr) {
        List expressions;
        if (expr.getParameters() != null && (expressions = expr.getParameters().getExpressions()) != null && expressions.size() == 1) {
            this.numberParser = OperatorTools.buildParser((Expression)expressions.get(0));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.numberParser != null) {
            Object valueObj = this.numberParser.parse(sourceData, rowIndex, context);
            if (valueObj == null) {
                return null;
            }
            BigDecimal numberValue = OperatorTools.parseBigDecimal(valueObj);
            return this.fibonacci(numberValue.intValue());
        }
        return null;
    }

    private long fibonacci(int n) {
        if (n <= 1) {
            return n;
        }
        long prev = 0L;
        long curr = 1L;
        for (int i = 2; i <= n; ++i) {
            long temp = curr;
            curr += prev;
            prev = temp;
        }
        return curr;
    }
}

